/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringEncoder;

class StringEncoderTest {
    StringEncoderTest() {
    }

    @Test
    void shouldEncodeStringWithZeroLength() {
        StringEncoder encoder = new StringEncoder();
        long eId = encoder.encode((Object)"");
        Assertions.assertTrue((eId != 0L ? 1 : 0) != 0);
    }

    @Test
    void shouldEncodeStringWithAnyLength() {
        StringEncoder encoder = new StringEncoder();
        LongHashSet encoded = new LongHashSet();
        int total = 1000;
        int duplicates = 0;
        for (int i = 0; i < total; ++i) {
            long encode = encoder.encode((Object)StringEncoderTest.abcStringOfLength(i));
            Assertions.assertTrue((encode != 0L ? 1 : 0) != 0);
            if (encoded.add(encode)) continue;
            ++duplicates;
        }
        Assertions.assertTrue(((float)duplicates / (float)total < 0.01f ? 1 : 0) != 0);
    }

    private static String abcStringOfLength(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int ch = 97 + i % 20;
            chars[i] = (char)ch;
        }
        return new String(chars);
    }
}

