/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.batchimport.input.BadCollector;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class BadCollectorTest {
    @Inject
    private FileSystemAbstraction fs;
    private final Groups groups = new Groups();
    private final Group group = this.groups.getOrCreate(null);

    BadCollectorTest() {
    }

    @Test
    void shouldCollectBadRelationshipsEvenIfThresholdNeverReached() throws IOException {
        int tolerance = 5;
        Group groupA = this.groups.getOrCreate("a");
        Group groupB = this.groups.getOrCreate("b");
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 7);){
            badCollector.collectBadRelationship((Object)"1", groupA, "T", (Object)"2", groupB, (Object)"1");
            Assertions.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    void shouldThrowExceptionIfDuplicateNodeTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 7);){
            BadCollectorTest.collectBadRelationship((Collector)badCollector, this.group);
            Assertions.assertThrows(InputException.class, () -> badCollector.collectDuplicateNode((Object)1, 1L, this.group));
        }
    }

    @Test
    void shouldThrowExceptionIfBadRelationshipsTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 7);){
            badCollector.collectDuplicateNode((Object)1, 1L, this.group);
            Assertions.assertThrows(InputException.class, () -> BadCollectorTest.collectBadRelationship((Collector)badCollector, this.group));
        }
    }

    @Test
    void shouldNotCollectBadRelationshipsIfWeShouldOnlyBeCollectingNodes() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 2);){
            badCollector.collectDuplicateNode((Object)1, 1L, this.group);
            Assertions.assertThrows(InputException.class, () -> BadCollectorTest.collectBadRelationship((Collector)badCollector, this.group));
            Assertions.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    void shouldNotCollectBadNodesIfWeShouldOnlyBeCollectingRelationships() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 1);){
            BadCollectorTest.collectBadRelationship((Collector)badCollector, this.group);
            Assertions.assertThrows(InputException.class, () -> badCollector.collectDuplicateNode((Object)1, 1L, this.group));
            Assertions.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    void shouldCollectUnlimitedNumberOfBadEntriesIfToldTo() {
        try (BadCollector collector = new BadCollector(OutputStream.nullOutputStream(), -1L, 7);){
            int count = 10000;
            for (int i = 0; i < count; ++i) {
                collector.collectDuplicateNode((Object)i, (long)i, this.group);
            }
            Assertions.assertEquals((long)count, (long)collector.badEntries());
        }
    }

    @Test
    void skipBadEntriesLogging() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (BadCollector badCollector = new BadCollector((OutputStream)outputStream, 100L, 7, 10, true, BadCollector.NO_MONITOR);){
            BadCollectorTest.collectBadRelationship((Collector)badCollector, this.group);
            for (int i = 0; i < 2; ++i) {
                badCollector.collectDuplicateNode((Object)i, (long)i, this.group);
            }
            BadCollectorTest.collectBadRelationship((Collector)badCollector, this.group);
            badCollector.collectExtraColumns("a,b,c", 1L, "a");
            Assertions.assertEquals((int)0, (int)outputStream.size(), (String)"Output stream should not have any reported entries");
        }
    }

    @Test
    void shouldApplyBackPressure() throws Exception {
        int backPressureThreshold = 10;
        BlockableMonitor monitor = new BlockableMonitor();
        try (OtherThreadExecutor t2 = new OtherThreadExecutor("T2");
             BadCollector badCollector = new BadCollector(OutputStream.nullOutputStream(), -1L, 7, backPressureThreshold, false, (BadCollector.Monitor)monitor);
             BlockableMonitor blockableMonitor = monitor;){
            for (int i = 0; i < backPressureThreshold; ++i) {
                badCollector.collectDuplicateNode((Object)i, (long)i, this.group);
            }
            Future enqueue = t2.executeDontWait(OtherThreadExecutor.command(() -> badCollector.collectDuplicateNode((Object)999, 999L, this.group)));
            t2.waitUntilWaiting(waitDetails -> waitDetails.isAt(BadCollector.class, "collect"));
            monitor.unblock();
            enqueue.get();
        }
    }

    private static void collectBadRelationship(Collector collector, Group group) {
        collector.collectBadRelationship((Object)"A", group, "TYPE", (Object)"B", group, (Object)"A");
    }

    private OutputStream badOutputFile() throws IOException {
        Path badDataPath = Path.of("/tmp/foo2", new String[0]).toAbsolutePath();
        Path badDataFile = BadCollectorTest.badDataFile(this.fs, badDataPath);
        return this.fs.openAsOutputStream(badDataFile, true);
    }

    private static Path badDataFile(FileSystemAbstraction fileSystem, Path badDataPath) throws IOException {
        fileSystem.mkdir(badDataPath.getParent());
        fileSystem.write(badDataPath);
        return badDataPath;
    }

    private static class BlockableMonitor
    implements BadCollector.Monitor,
    AutoCloseable {
        private final CountDownLatch latch = new CountDownLatch(1);

        private BlockableMonitor() {
        }

        public void beforeProcessEvent() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        void unblock() {
            this.latch.countDown();
        }

        @Override
        public void close() {
            this.unblock();
        }
    }
}

