/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.HeaderException;
import org.neo4j.test.Race;

class GroupsTest {
    GroupsTest() {
    }

    @Test
    void shouldHandleConcurrentGetOrCreate() throws Throwable {
        Groups groups = new Groups();
        Race race = new Race();
        String name = "MyGroup";
        for (int i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            race.addContestant(() -> {
                Group group = groups.getOrCreate(name);
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.id());
            });
        }
        race.go();
        Group otherGroup = groups.getOrCreate("MyOtherGroup");
        Assertions.assertThat((int)otherGroup.id()).isEqualTo(1);
    }

    @Test
    void shouldSupportMixedGroupModeInGetOrCreate() {
        Groups groups = new Groups();
        Group globalGroup = groups.getOrCreate(null);
        Group otherGroup = groups.getOrCreate("Something");
        Assertions.assertThat((Object)otherGroup).isNotEqualTo((Object)globalGroup);
    }

    @Test
    void shouldSupportMixedGroupModeInGetOrCreate2() {
        Groups groups = new Groups();
        Group otherGroup = groups.getOrCreate("Something");
        Group globalGroup = groups.getOrCreate(null);
        Assertions.assertThat((Object)globalGroup).isNotEqualTo((Object)otherGroup);
    }

    @Test
    void shouldGetCreatedGroup() {
        Groups groups = new Groups();
        String name = "Something";
        Group createdGroup = groups.getOrCreate(name);
        Group gottenGroup = groups.get(name);
        Assertions.assertThat((Object)gottenGroup).isEqualTo((Object)createdGroup);
    }

    @Test
    void shouldGetGlobalGroup() {
        Groups groups = new Groups();
        groups.getOrCreate(null);
        Group group = groups.get(null);
        Assertions.assertThat((String)group.name()).isNull();
        Assertions.assertThat((String)group.descriptiveName()).isEqualTo("global id space");
    }

    @Test
    void shouldFailOnGettingNonExistentGroup() {
        Groups groups = new Groups();
        org.junit.jupiter.api.Assertions.assertThrows(HeaderException.class, () -> groups.get("Something"));
    }
}

