/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityDecorators;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.Iterators;

class InputEntityDecoratorsTest {
    private final InputEntity entity = new InputEntity();
    private final Groups groups = new Groups();
    private final Group group = this.groups.getOrCreate(null);

    InputEntityDecoratorsTest() {
    }

    @Test
    void shouldProvideDefaultRelationshipType() throws Exception {
        String defaultType = "TYPE";
        InputEntityVisitor relationship = (InputEntityVisitor)InputEntityDecorators.defaultRelationshipType((String)defaultType).apply((Object)this.entity);
        InputEntityDecoratorsTest.relationship(relationship, "source", 1L, 0L, InputEntity.NO_PROPERTIES, null, "start", "end", this.group, null, null);
        Assertions.assertEquals((Object)defaultType, (Object)this.entity.stringType);
    }

    @Test
    void shouldNotOverrideAlreadySetRelationshipType() throws Exception {
        String defaultType = "TYPE";
        InputEntityVisitor relationship = (InputEntityVisitor)InputEntityDecorators.defaultRelationshipType((String)defaultType).apply((Object)this.entity);
        String customType = "CUSTOM_TYPE";
        InputEntityDecoratorsTest.relationship(relationship, "source", 1L, 0L, InputEntity.NO_PROPERTIES, null, "start", "end", this.group, customType, null);
        Assertions.assertEquals((Object)customType, (Object)this.entity.stringType);
    }

    @Test
    void shouldNotOverrideAlreadySetRelationshipTypeId() throws Exception {
        String defaultType = "TYPE";
        Decorator decorator = InputEntityDecorators.defaultRelationshipType((String)defaultType);
        InputEntityVisitor relationship = (InputEntityVisitor)decorator.apply((Object)this.entity);
        int typeId = 5;
        InputEntityDecoratorsTest.relationship(relationship, "source", 1L, 0L, InputEntity.NO_PROPERTIES, null, "start", "end", this.group, null, typeId);
        Assertions.assertTrue((boolean)this.entity.hasIntType);
        Assertions.assertEquals((int)typeId, (int)this.entity.intType);
    }

    @Test
    void shouldAddLabelsToNodeWithoutLabels() throws Exception {
        Object[] toAdd = new String[]{"Add1", "Add2"};
        InputEntityVisitor node = (InputEntityVisitor)InputEntityDecorators.additiveLabels((String[])toAdd).apply((Object)this.entity);
        InputEntityDecoratorsTest.node(node, "source", 1L, 0L, "id", this.group, InputEntity.NO_PROPERTIES, null, InputEntity.NO_LABELS, null);
        Assertions.assertArrayEquals((Object[])toAdd, (Object[])this.entity.labels());
    }

    @Test
    void shouldAddMissingLabels() throws Exception {
        Object[] toAdd = new String[]{"Add1", "Add2"};
        InputEntityVisitor node = (InputEntityVisitor)InputEntityDecorators.additiveLabels((String[])toAdd).apply((Object)this.entity);
        Object[] nodeLabels = new String[]{"SomeOther"};
        InputEntityDecoratorsTest.node(node, "source", 1L, 0L, "id", this.group, InputEntity.NO_PROPERTIES, null, (String[])nodeLabels, null);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])((String[])ArrayUtil.union((Object[])toAdd, (Object[])nodeLabels))), (Object)Iterators.asSet((Object[])this.entity.labels()));
    }

    @Test
    void shouldNotTouchLabelsIfNodeHasLabelFieldSet() throws Exception {
        String[] toAdd = new String[]{"Add1", "Add2"};
        InputEntityVisitor node = (InputEntityVisitor)InputEntityDecorators.additiveLabels((String[])toAdd).apply((Object)this.entity);
        long labelField = 123L;
        InputEntityDecoratorsTest.node(node, "source", 1L, 0L, "id", this.group, InputEntity.NO_PROPERTIES, null, null, labelField);
        Assertions.assertEquals((int)0, (int)this.entity.labels().length);
        Assertions.assertEquals((long)labelField, (long)this.entity.labelField);
    }

    @Test
    void shouldCramMultipleDecoratorsIntoOne() {
        Decorator decorator1 = (Decorator)Mockito.spy((Object)new IdentityDecorator());
        Decorator decorator2 = (Decorator)Mockito.spy((Object)new IdentityDecorator());
        Decorator multi = InputEntityDecorators.decorators((Decorator[])new Decorator[]{decorator1, decorator2});
        InputEntityVisitor node = (InputEntityVisitor)Mockito.mock(InputEntityVisitor.class);
        multi.apply((Object)node);
        InOrder order = Mockito.inOrder((Object[])new Object[]{decorator1, decorator2});
        ((Decorator)order.verify((Object)decorator1)).apply((Object)node);
        ((Decorator)order.verify((Object)decorator2)).apply((Object)node);
        order.verifyNoMoreInteractions();
    }

    private static void node(InputEntityVisitor entity, String sourceDescription, long lineNumber, long position, Object id, Group group, Object[] properties, Long propertyId, String[] labels, Long labelField) throws IOException {
        InputEntityDecoratorsTest.applyProperties(entity, properties, propertyId);
        entity.id(id, group);
        if (labelField != null) {
            entity.labelField(labelField.longValue());
        } else {
            entity.labels(labels);
        }
        entity.endOfEntity();
    }

    private static void relationship(InputEntityVisitor entity, String sourceDescription, long lineNumber, long position, Object[] properties, Long propertyId, Object startNode, Object endNode, Group group, String type, Integer typeId) throws IOException {
        InputEntityDecoratorsTest.applyProperties(entity, properties, propertyId);
        entity.startId(startNode, group);
        entity.endId(endNode, group);
        if (typeId != null) {
            entity.type(typeId.intValue());
        } else if (type != null) {
            entity.type(type);
        }
        entity.endOfEntity();
    }

    private static void applyProperties(InputEntityVisitor entity, Object[] properties, Long propertyId) {
        if (propertyId != null) {
            entity.propertyId(propertyId.longValue());
        }
        for (int i = 0; i < properties.length; ++i) {
            entity.property((String)properties[i++], properties[i]);
        }
    }

    private static class IdentityDecorator
    implements Decorator {
        private IdentityDecorator() {
        }

        public InputEntityVisitor apply(InputEntityVisitor entity) {
            return entity;
        }
    }
}

