/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.Flushable;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.input.ValueType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class ValueTypeTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;

    ValueTypeTest() {
    }

    @Test
    void arraysShouldCalculateCorrectLength() throws IOException {
        int[] value = new int[3];
        for (int i = 0; i < value.length; ++i) {
            value[i] = 100 + i;
        }
        ValueType valueType = ValueType.typeOf((Object)value);
        CountingChannel channel = new CountingChannel();
        int length = valueType.length((Object)value);
        valueType.write((Object)value, (FlushableChannel)channel);
        int expected = 5 + value.length * 4;
        Assertions.assertEquals((int)expected, (int)length);
        Assertions.assertEquals((long)expected, (long)channel.position());
    }

    private static class CountingChannel
    implements FlushableChannel {
        private long position;

        private CountingChannel() {
        }

        public Flushable prepareForFlush() {
            throw new UnsupportedOperationException();
        }

        public FlushableChannel put(byte value) {
            ++this.position;
            return this;
        }

        public FlushableChannel putShort(short value) {
            this.position += 2L;
            return this;
        }

        public FlushableChannel putInt(int value) {
            this.position += 4L;
            return this;
        }

        public FlushableChannel putLong(long value) {
            this.position += 8L;
            return this;
        }

        public FlushableChannel putFloat(float value) {
            this.position += 4L;
            return this;
        }

        public FlushableChannel putDouble(double value) {
            this.position += 8L;
            return this;
        }

        public FlushableChannel put(byte[] value, int offset, int length) {
            this.position += (long)length;
            return this;
        }

        public void close() {
        }

        long position() {
            return this.position;
        }
    }
}

