/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.internal.batchimport.input.csv.CsvInputIterator;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.Header;

class CsvInputIteratorTest {
    CsvInputIteratorTest() {
    }

    @Test
    void shouldAutoSkipHeadersIfExists() throws IOException {
        CharReadable stream = this.readableOverFiles(List.of(List.of(":ID,:LABEL", "1,foo", "2,bar"), List.of(":ID,:LABEL,prop", "3,foo", "4,bar"), List.of(":ID,prop", "5,foo", "6,bar")));
        Configuration config = Configuration.COMMAS;
        try (CsvInputIterator iterator = new CsvInputIterator(stream, e -> e, DataFactories.defaultFormatNodeFileHeader(), IdType.ACTUAL, config, new Groups(), Collector.EMPTY, new Extractors(config.arrayDelimiter()), 0, true, Header.NO_MONITOR);){
            CsvInputChunkProxy chunk = new CsvInputChunkProxy();
            InputEntity visitor = new InputEntity();
            long nextExpectedId = 1L;
            while (iterator.next(chunk)) {
                while (chunk.next((InputEntityVisitor)visitor)) {
                    Assertions.assertThat((long)visitor.longId).isEqualTo(nextExpectedId++);
                }
            }
            Assertions.assertThat((long)nextExpectedId).isEqualTo(7L);
        }
    }

    private CharReadable readableOverFiles(List<List<String>> data) {
        MutableInt counter = new MutableInt();
        Object[] sources = (CharReadable[])data.stream().map(contents -> CsvInputIteratorTest.reader(contents, counter.getAndIncrement())).toArray(CharReadable[]::new);
        return new MultiReadable(Readables.iterator(r -> r, (Object[])sources));
    }

    private static CharReadable reader(List<String> contents, int id) {
        String data = StringUtils.join(contents, (String)String.format("%n", new Object[0]));
        return Readables.wrap((String)("source_" + id), (String)data);
    }
}

