/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.DuplicateHeaderException;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityDecorators;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.Data;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.ByteUnit;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
class CsvInputTest {
    @Inject
    private RandomSupport random;
    @Inject
    private TestDirectory directory;
    private final Extractors extractors = new Extractors(',');
    private final InputEntity visitor = new InputEntity();
    private final Groups groups = new Groups();
    private final Group globalGroup = this.groups.getOrCreate(null);
    private InputChunk chunk;
    private InputIterator referenceData;

    CsvInputTest() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldProvideNodesFromCsvInput(boolean allowMultilineFields) throws Exception {
        IdType idType = IdType.INTEGER;
        Iterable<DataFactory> data = CsvInputTest.dataIterable(CsvInputTest.data("123,Mattias Persson,HACKER"));
        CsvInput input = new CsvInput(data, CsvInputTest.header(this.entry(null, Type.ID, CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors)), this.entry("name", Type.PROPERTY, this.extractors.string()), this.entry("labels", Type.LABEL, this.extractors.string())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), idType, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 123L, CsvInputTest.properties("name", "Mattias Persson"), CsvInputTest.labels("HACKER"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.chunk.next((InputEntityVisitor)this.visitor));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldProvideRelationshipsFromCsvInput(boolean allowMultilineFields) throws Exception {
        IdType idType = IdType.STRING;
        Iterable<DataFactory> data = CsvInputTest.dataIterable(CsvInputTest.data("node1,node2,KNOWS,1234567\nnode2,node10,HACKS,987654"));
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, CsvInputTest.header(this.entry("from", Type.START_ID, CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors)), this.entry("to", Type.END_ID, CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors)), this.entry("type", Type.TYPE, this.extractors.string()), this.entry("since", Type.PROPERTY, (Extractor<?>)this.extractors.long_())), idType, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator relationships = input.relationships(Collector.EMPTY).iterator();){
            this.assertNextRelationship(relationships, "node1", "node2", "KNOWS", CsvInputTest.properties("since", 1234567L));
            this.assertNextRelationship(relationships, "node2", "node10", "HACKS", CsvInputTest.properties("since", 987654L));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldCloseDataIteratorsInTheEnd(boolean allowMultilineFields) throws Exception {
        CapturingDataFactories nodeData = new CapturingDataFactories(config -> CsvInputTest.charReader("1"), InputEntityDecorators.NO_DECORATOR);
        CapturingDataFactories relationshipData = new CapturingDataFactories(config -> CsvInputTest.charReader("1,1"), InputEntityDecorators.defaultRelationshipType((String)"TYPE"));
        IdType idType = IdType.STRING;
        CsvInput input = new CsvInput((Iterable)nodeData, CsvInputTest.header(this.entry(null, Type.ID, CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors))), (Iterable)relationshipData, CsvInputTest.header(this.entry(null, Type.START_ID, CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors)), this.entry(null, Type.END_ID, CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors))), idType, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator iterator = input.nodes(Collector.EMPTY).iterator();){
            this.readNext(iterator);
        }
        iterator = input.relationships(Collector.EMPTY).iterator();
        try {
            this.readNext(iterator);
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        CsvInputTest.assertClosed(nodeData.last());
        CsvInputTest.assertClosed(relationshipData.last());
    }

    private static void assertClosed(CharReadable reader) {
        try {
            reader.read(new char[1], 0, 1);
            org.junit.jupiter.api.Assertions.fail((String)(reader + " not closed"));
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("closed"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldCopeWithLinesThatHasTooFewValuesButStillValidates(boolean allowMultilineFields) throws Exception {
        Iterable<DataFactory> data = CsvInputTest.dataIterable(CsvInputTest.data("1,ultralisk,ZERG,10\n2,corruptor,ZERG\n3,mutalisk,ZERG,3"));
        CsvInput input = new CsvInput(data, CsvInputTest.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("unit", Type.PROPERTY, this.extractors.string()), this.entry("type", Type.LABEL, this.extractors.string()), this.entry("kills", Type.PROPERTY, (Extractor<?>)this.extractors.int_())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 1L, new Object[]{"unit", "ultralisk", "kills", 10}, CsvInputTest.labels("ZERG"));
            this.assertNextNode(nodes, 2L, new Object[]{"unit", "corruptor"}, CsvInputTest.labels("ZERG"));
            this.assertNextNode(nodes, 3L, new Object[]{"unit", "mutalisk", "kills", 3}, CsvInputTest.labels("ZERG"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldIgnoreValuesAfterHeaderEntries(boolean allowMultilineFields) throws Exception {
        Iterable<DataFactory> data = CsvInputTest.dataIterable(CsvInputTest.data("1,zergling,bubble,bobble\n2,scv,pun,intended"));
        CsvInput input = new CsvInput(data, CsvInputTest.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("name", Type.PROPERTY, this.extractors.string())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 1L, new Object[]{"name", "zergling"}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "scv"}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldHandleMultipleInputGroups(boolean allowMultilineFields) throws Exception {
        DataFactory group1 = CsvInputTest.data(":ID,name,kills:int,health:int\n1,Jim,10,100\n2,Abathur,0,200\n");
        DataFactory group2 = CsvInputTest.data(":ID,type\n3,zergling\n4,csv\n");
        Iterable<DataFactory> data = CsvInputTest.dataIterable(group1, group2);
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, "1", CsvInputTest.properties("name", "Jim", "kills", 10, "health", 100), CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, "2", CsvInputTest.properties("name", "Abathur", "kills", 0, "health", 200), CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, "3", CsvInputTest.properties("type", "zergling"), CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, "4", CsvInputTest.properties("type", "csv"), CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldProvideAdditiveLabels(boolean allowMultilineFields) throws Exception {
        Object[] addedLabels = new String[]{"Two", "AddTwo"};
        DataFactory data = CsvInputTest.data(":ID,name,:LABEL\n0,First,\n1,Second,One\n2,Third,One;Two", InputEntityDecorators.additiveLabels((String[])addedLabels));
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, CsvInputTest.properties("name", "First"), CsvInputTest.labels((String[])addedLabels));
            this.assertNextNode(nodes, 1L, CsvInputTest.properties("name", "Second"), CsvInputTest.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            this.assertNextNode(nodes, 2L, CsvInputTest.properties("name", "Third"), CsvInputTest.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldProvideDefaultRelationshipType(boolean allowMultilineFields) throws Exception {
        String defaultType = "DEFAULT";
        String customType = "CUSTOM";
        DataFactory data = CsvInputTest.data(":START_ID,:END_ID,:TYPE\n0,1,\n1,2," + customType + "\n2,1," + defaultType, InputEntityDecorators.defaultRelationshipType((String)defaultType));
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator relationships = input.relationships(Collector.EMPTY).iterator();){
            this.assertNextRelationship(relationships, 0L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            this.assertNextRelationship(relationships, 1L, 2L, customType, InputEntity.NO_PROPERTIES);
            this.assertNextRelationship(relationships, 2L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldAllowNodesWithoutIdHeader(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data("name:string,level:int\nMattias,1\nJohan,2\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, null, null, new Object[]{"name", "Mattias", "level", 1}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, null, null, new Object[]{"name", "Johan", "level", 2}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldAllowSomeNodesToBeAnonymous(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, "abc", new Object[]{"name", "Mattias", "level", 1}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, null, null, new Object[]{"name", "Johan", "level", 2}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldAllowNodesToBeAnonymousEvenIfIdHeaderIsNamed(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data("id:ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, "abc", new Object[]{"id", "abc", "name", "Mattias", "level", 1}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, null, null, new Object[]{"name", "Johan", "level", 2}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldNotHaveIdSetAsPropertyIfIdHeaderEntryIsNamedForActualIds(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data("myId:ID,name:string,level:int\n0,Mattias,1\n1,Johan,2\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, null, 0L, new Object[]{"name", "Mattias", "level", 1}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, null, 1L, new Object[]{"name", "Johan", "level", 2}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldIgnoreEmptyPropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,extra\n0,Mattias,\n1,Johan,Additional\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias"}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "extra", "Additional"}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldIgnoreEmptyIntPropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,extra:int\n0,Mattias,\n1,Johan,10\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias"}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "extra", 10}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParsePointPropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point\n0,Mattias,\"{x: 2.7, y:3.2 }\"\n1,Johan,\" { height :0.01 ,longitude:5, latitude : -4.2 } \"\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{2.7, 3.2})}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84_3D, (double[])new double[]{5.0, -4.2, 0.01})}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldNotParsePointPropertyValuesWithDuplicateKeys(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point\n1,Johan,\" { height :0.01 ,longitude:5, latitude : -4.2, latitude : 4.2 } \"\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.readNext(nodes);
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed when key assigned multiple times, but didn't.");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParsePointPropertyValuesWithCRSInHeader(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point{crs:WGS-84-3D}\n0,Johan,\" { height :0.01 ,longitude:5, latitude : -4.2 } \"\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Johan", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84_3D, (double[])new double[]{5.0, -4.2, 0.01})}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldUseHeaderInformationToParsePoint(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point{crs:WGS-84}\n0,Johan,\" { x :1 ,y:2 } \"\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Johan", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{1.0, 2.0})}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseDatePropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,date:Date\n0,Mattias,2018-02-27\n1,Johan,2018-03-01\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "date", DateValue.date((int)2018, (int)2, (int)27)}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "date", DateValue.date((int)2018, (int)3, (int)1)}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseTimePropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:Time\n0,Mattias,13:37\n1,Johan,\"16:20:01\"\n2,Bob,07:30-05:00\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", TimeValue.time((int)13, (int)37, (int)0, (int)0, (String)"+00:00")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", TimeValue.time((int)16, (int)20, (int)1, (int)0, (String)"+00:00")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", TimeValue.time((int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseTimePropertyValuesWithTimezoneInHeader(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:Time{timezone:+02:00}\n0,Mattias,13:37\n1,Johan,\"16:20:01\"\n2,Bob,07:30-05:00\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", TimeValue.time((int)13, (int)37, (int)0, (int)0, (String)"+02:00")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", TimeValue.time((int)16, (int)20, (int)1, (int)0, (String)"+02:00")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", TimeValue.time((int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseDateTimePropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:DateTime\n0,Mattias,2018-02-27T13:37\n1,Johan,\"2018-03-01T16:20:01\"\n2,Bob,1981-05-11T07:30-05:00\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", DateTimeValue.datetime((int)2018, (int)2, (int)27, (int)13, (int)37, (int)0, (int)0, (String)"+00:00")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", DateTimeValue.datetime((int)2018, (int)3, (int)1, (int)16, (int)20, (int)1, (int)0, (String)"+00:00")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", DateTimeValue.datetime((int)1981, (int)5, (int)11, (int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseDateTimePropertyValuesWithTimezoneInHeader(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:DateTime{timezone:Europe/Stockholm}\n0,Mattias,2018-02-27T13:37\n1,Johan,\"2018-03-01T16:20:01\"\n2,Bob,1981-05-11T07:30-05:00\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", DateTimeValue.datetime((int)2018, (int)2, (int)27, (int)13, (int)37, (int)0, (int)0, (String)"Europe/Stockholm")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", DateTimeValue.datetime((int)2018, (int)3, (int)1, (int)16, (int)20, (int)1, (int)0, (String)"Europe/Stockholm")}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", DateTimeValue.datetime((int)1981, (int)5, (int)11, (int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseLocalTimePropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:LocalTime\n0,Mattias,13:37\n1,Johan,\"16:20:01\"\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", LocalTimeValue.localTime((int)13, (int)37, (int)0, (int)0)}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", LocalTimeValue.localTime((int)16, (int)20, (int)1, (int)0)}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseLocalDateTimePropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:LocalDateTime\n0,Mattias,2018-02-27T13:37\n1,Johan,\"2018-03-01T16:20:01\"\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", LocalDateTimeValue.localDateTime((int)2018, (int)2, (int)27, (int)13, (int)37, (int)0, (int)0)}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", LocalDateTimeValue.localDateTime((int)2018, (int)3, (int)1, (int)16, (int)20, (int)1, (int)0)}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldParseDurationPropertyValues(boolean allowMultilineFields) throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,duration:Duration\n0,Mattias,P3MT13H37M\n1,Johan,\"P-1YT4H20M\"\n");
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "duration", DurationValue.duration((long)3L, (long)0L, (long)49020L, (long)0L)}, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "duration", DurationValue.duration((long)-12L, (long)0L, (long)15600L, (long)0L)}, CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldFailOnArrayDelimiterBeingSameAsDelimiter(boolean allowMultilineFields) {
        try {
            new CsvInput(null, null, null, null, IdType.INTEGER, CsvInputTest.config(allowMultilineFields).toBuilder().withDelimiter(',').withArrayDelimiter(',').build(), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("array delimiter"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldFailOnQuotationCharacterBeingSameAsDelimiter(boolean allowMultilineFields) {
        try {
            new CsvInput(null, null, null, null, IdType.INTEGER, CsvInputTest.config(allowMultilineFields).toBuilder().withDelimiter(',').withArrayDelimiter(';').withQuotationCharacter(',').build(), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("delimiter"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldFailOnQuotationCharacterBeingSameAsArrayDelimiter(boolean allowMultilineFields) {
        try {
            new CsvInput(null, null, null, null, IdType.INTEGER, CsvInputTest.config(allowMultilineFields).toBuilder().withQuotationCharacter(';').build(), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("array delimiter"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldHaveNodesBelongToGroupSpecifiedInHeader(boolean allowMultilineFields) throws Exception {
        IdType idType = IdType.INTEGER;
        Iterable<DataFactory> data = CsvInputTest.dataIterable(CsvInputTest.data("123,one\n456,two"));
        Group group = this.groups.getOrCreate("MyGroup");
        CsvInput input = new CsvInput(data, CsvInputTest.header(this.entry(null, Type.ID, group.name(), CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors)), this.entry("name", Type.PROPERTY, this.extractors.string())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), idType, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, group, 123L, CsvInputTest.properties("name", "one"), CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, group, 456L, CsvInputTest.properties("name", "two"), CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldHaveRelationshipsSpecifyStartEndNodeIdGroupsInHeader(boolean allowMultilineFields) throws Exception {
        IdType idType = IdType.INTEGER;
        Iterable<DataFactory> data = CsvInputTest.dataIterable(CsvInputTest.data("123,TYPE,234\n345,TYPE,456"));
        Group startNodeGroup = this.groups.getOrCreate("StartGroup");
        Group endNodeGroup = this.groups.getOrCreate("EndGroup");
        Iterable<DataFactory> nodeHeader = CsvInputTest.dataIterable(CsvInputTest.data(":ID(" + startNodeGroup.name() + ")"), CsvInputTest.data(":ID(" + endNodeGroup.name() + ")"));
        CsvInput input = new CsvInput(nodeHeader, DataFactories.defaultFormatNodeFileHeader(), data, CsvInputTest.header(this.entry(null, Type.START_ID, startNodeGroup.name(), CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors)), this.entry(null, Type.TYPE, this.extractors.string()), this.entry(null, Type.END_ID, endNodeGroup.name(), CsvInput.idExtractor((IdType)idType, (Extractors)this.extractors))), idType, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator relationships = input.relationships(Collector.EMPTY).iterator();){
            this.assertRelationship(relationships, startNodeGroup, 123L, endNodeGroup, 234L, "TYPE", CsvInputTest.properties(new Object[0]));
            this.assertRelationship(relationships, startNodeGroup, 345L, endNodeGroup, 456L, "TYPE", CsvInputTest.properties(new Object[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldDoWithoutRelationshipTypeHeaderIfDefaultSupplied(boolean allowMultilineFields) throws Exception {
        String defaultType = "HERE";
        DataFactory data = CsvInputTest.data(":START_ID,:END_ID,name\n0,1,First\n2,3,Second\n", InputEntityDecorators.defaultRelationshipType((String)defaultType));
        Iterable<DataFactory> dataIterable = CsvInputTest.dataIterable(data);
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator relationships = input.relationships(Collector.EMPTY).iterator();){
            this.assertNextRelationship(relationships, 0L, 1L, defaultType, CsvInputTest.properties("name", "First"));
            this.assertNextRelationship(relationships, 2L, 3L, defaultType, CsvInputTest.properties("name", "Second"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldIgnoreNodeEntriesMarkedIgnoreUsingHeader(boolean allowMultilineFields) throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,name:IGNORE,other:int,:LABEL\n1,Mattias,10,Person\n2,Johan,111,Person\n3,Emil,12,Person")});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 1L, new Object[]{"other", 10}, CsvInputTest.labels("Person"));
            this.assertNextNode(nodes, 2L, new Object[]{"other", 111}, CsvInputTest.labels("Person"));
            this.assertNextNode(nodes, 3L, new Object[]{"other", 12}, CsvInputTest.labels("Person"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldIgnoreRelationshipEntriesMarkedIgnoreUsingHeader(boolean allowMultilineFields) throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID,:TYPE,:END_ID,prop:IGNORE,other:int\n1,KNOWS,2,Mattias,10\n2,KNOWS,3,Johan,111\n3,KNOWS,4,Emil,12")});
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator relationships = input.relationships(Collector.EMPTY).iterator();){
            this.assertNextRelationship(relationships, 1L, 2L, "KNOWS", new Object[]{"other", 10});
            this.assertNextRelationship(relationships, 2L, 3L, "KNOWS", new Object[]{"other", 111});
            this.assertNextRelationship(relationships, 3L, 4L, "KNOWS", new Object[]{"other", 12});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldPropagateExceptionFromFailingDecorator(boolean allowMultilineFields) throws Exception {
        RuntimeException failure = new RuntimeException("FAILURE");
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,name\n1,Mattias", new FailingNodeDecorator(failure))});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.readNext(nodes);
        }
        catch (InputException e) {
            org.junit.jupiter.api.Assertions.assertSame((Object)e.getCause(), (Object)failure);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldNotIncludeEmptyArraysInEntities(boolean allowMultilineFields) throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,sprop:String[],lprop:long[]\n1,,\n2,a;b,10;20")});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 1L, InputEntity.NO_PROPERTIES, CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 2L, CsvInputTest.properties("sprop", new String[]{"a", "b"}, "lprop", new long[]{10L, 20L}), CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldTreatEmptyQuotedStringsAsNullIfConfiguredTo(boolean allowMultilineFields) throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,one,two,three\n1,\"\",,value")});
        Configuration config = CsvInputTest.config(allowMultilineFields).toBuilder().withEmptyQuotedStringsAsNull(true).build();
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, config, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();){
            this.assertNextNode(nodes, 1L, CsvInputTest.properties("three", "value"), CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldIgnoreEmptyExtraColumns(boolean allowMultilineFields) throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,one\n1,test,\n2,test,,additional")});
        Collector collector = (Collector)Mockito.mock(Collector.class);
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator nodes = input.nodes(collector).iterator();){
            this.assertNextNode(nodes, 1L, CsvInputTest.properties("one", "test"), CsvInputTest.labels(new String[0]));
            this.assertNextNode(nodes, 2L, CsvInputTest.properties("one", "test"), CsvInputTest.labels(new String[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.readNext(nodes));
        }
        ((Collector)Mockito.verify((Object)collector)).collectExtraColumns(ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)1L), (String)ArgumentMatchers.eq(null));
        ((Collector)Mockito.verify((Object)collector)).collectExtraColumns(ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)2L), (String)ArgumentMatchers.eq(null));
        ((Collector)Mockito.verify((Object)collector)).collectExtraColumns(ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)2L), (String)ArgumentMatchers.eq((Object)"additional"));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldSkipRelationshipValidationIfToldTo(boolean allowMultilineFields) throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID,:END_ID,:TYPE\n,,")});
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, CsvInputTest.config(allowMultilineFields), false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (InputIterator relationships = input.relationships(Collector.EMPTY).iterator();){
            this.readNext(relationships);
            org.junit.jupiter.api.Assertions.assertNull((Object)this.visitor.startId());
            org.junit.jupiter.api.Assertions.assertNull((Object)this.visitor.endId());
            org.junit.jupiter.api.Assertions.assertNull((Object)this.visitor.stringType);
        }
    }

    @Test
    void shouldFailOnUnparsableNodeHeader() {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":SOMETHING,abcde#rtg:123,")});
        try {
            new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should not parse");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    void shouldFailOnUnparsableRelationshipHeader() {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":SOMETHING,abcde#rtg:123,")});
        try {
            new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should not parse");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    void shouldFailOnUndefinedGroupInRelationshipHeader() {
        Iterable nodeData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID(left)"), CsvInputTest.data(":ID(right)")});
        Iterable relationshipData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID(left),:END_ID(rite)")});
        try {
            new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should not validate");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    void shouldFailOnGlobalGroupInRelationshipHeaderIfNoGLobalGroupInNodeHeader() {
        Iterable nodeData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID(left)"), CsvInputTest.data(":ID(right)")});
        Iterable relationshipData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID(left),:END_ID(rite)")});
        try {
            new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should not validate");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    void shouldReportDuplicateNodeSourceFiles() {
        String sourceDescription = "The single data source";
        final Supplier<CharReadable> source = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":ID", sourceDescription), (long)3L);
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object[])new CharReadable[]{(CharReadable)source.get(), (CharReadable)source.get()}));
            }

            public Decorator decorator() {
                return InputEntityDecorators.NO_DECORATOR;
            }
        }});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, monitor, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor)).duplicateSourceFile(sourceDescription);
    }

    @Test
    void shouldReportDuplicateRelationshipSourceFiles() {
        String sourceDescription = "The single data source";
        final Supplier<CharReadable> source = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":START_ID,:END_ID,:TYPE", sourceDescription), (long)3L);
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object[])new CharReadable[]{(CharReadable)source.get(), (CharReadable)source.get()}));
            }

            public Decorator decorator() {
                return InputEntityDecorators.NO_DECORATOR;
            }
        }});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, monitor, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor)).duplicateSourceFile(sourceDescription);
    }

    @Test
    void shouldReportDuplicateSourceFileUsedAsBothNodeAndRelationshipSourceFile() {
        String sourceDescription = "The single data source";
        final Supplier<CharReadable> nodeHeaderSource = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":ID", "node source"), (long)3L);
        final Supplier<CharReadable> relationshipHeaderSource = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":START_ID,:END_ID,:TYPE", "relationship source"), (long)10L);
        final Supplier<CharReadable> source = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription("1,2,3", sourceDescription), (long)6L);
        Iterable nodeData = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object[])new CharReadable[]{(CharReadable)nodeHeaderSource.get(), (CharReadable)source.get()}));
            }

            public Decorator decorator() {
                return InputEntityDecorators.NO_DECORATOR;
            }
        }});
        Iterable relationshipData = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object[])new CharReadable[]{(CharReadable)relationshipHeaderSource.get(), (CharReadable)source.get()}));
            }

            public Decorator decorator() {
                return InputEntityDecorators.NO_DECORATOR;
            }
        }});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, monitor, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor)).duplicateSourceFile(sourceDescription);
    }

    private static Reader dataWithSourceDescription(String data, final String sourceDescription) {
        return new StringReader(data){

            public String toString() {
                return sourceDescription;
            }
        };
    }

    @Test
    void shouldNormalizeTypes() throws IOException {
        Iterable nodeData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data("source1", ":ID,shortProp:short,intProp:int"), CsvInputTest.data("source2", ":ID,floatProp:float,doubleProp:double")});
        Iterable relationshipData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data("source3", ":START_ID,:END_ID,byteProp:byte,longProp:long")});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        CsvInput input = new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader((boolean)true), relationshipData, DataFactories.defaultFormatRelationshipFileHeader((boolean)true), IdType.INTEGER, Configuration.COMMAS, false, monitor, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        input.calculateEstimates((values, NULL, INSTANCE) -> 1);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).typeNormalized("source1", "shortProp", "short", "long");
        ((CsvInput.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).typeNormalized("source1", "intProp", "int", "long");
        ((CsvInput.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).typeNormalized("source2", "floatProp", "float", "double");
        ((CsvInput.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).typeNormalized("source3", "byteProp", "byte", "long");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }

    @Test
    void shouldCalculateCorrectEstimatesForZippedInputFile() throws IOException {
        IdType idType = IdType.STRING;
        Path uncompressedFile = this.createNodeInputDataFile(ByteUnit.mebiBytes((long)10L));
        Path compressedFile = this.compressWithZip(uncompressedFile);
        Assertions.assertThat((long)Files.size(compressedFile)).isLessThan(Files.size(uncompressedFile));
        Input.Estimates uncompressedEstimates = CsvInputTest.calculateEstimatesOnSingleFileNodeData(idType, uncompressedFile);
        Input.Estimates compressedEstimates = CsvInputTest.calculateEstimatesOnSingleFileNodeData(idType, compressedFile);
        CsvInputTest.assertEstimatesEquals(uncompressedEstimates, compressedEstimates, 0.0);
    }

    @Test
    void shouldCalculateCorrectEstimatesForGZippedInputFile() throws IOException {
        IdType idType = IdType.STRING;
        Path uncompressedFile = this.createNodeInputDataFile(ByteUnit.mebiBytes((long)10L));
        Path compressedFile = this.compressWithGZip(uncompressedFile);
        Assertions.assertThat((long)Files.size(compressedFile)).isLessThan(Files.size(uncompressedFile));
        Input.Estimates uncompressedEstimates = CsvInputTest.calculateEstimatesOnSingleFileNodeData(idType, uncompressedFile);
        Input.Estimates compressedEstimates = CsvInputTest.calculateEstimatesOnSingleFileNodeData(idType, compressedFile);
        CsvInputTest.assertEstimatesEquals(uncompressedEstimates, compressedEstimates, 0.01);
    }

    @Test
    void shouldReportNoNodeLabels() {
        String sourceDescription = "source";
        final Supplier<CharReadable> headerSource = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":ID", sourceDescription), (long)3L);
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object)((CharReadable)headerSource.get())));
            }

            public Decorator decorator() {
                return InputEntityDecorators.NO_DECORATOR;
            }
        }});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, monitor, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor)).noNodeLabelsSpecified(sourceDescription);
    }

    @Test
    void shouldNotReportNoNodeLabelsIfDecorated() {
        String sourceDescription = "source";
        final Supplier<CharReadable> headerSource = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":ID", sourceDescription), (long)3L);
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object)((CharReadable)headerSource.get())));
            }

            public Decorator decorator() {
                return InputEntityDecorators.additiveLabels((String[])new String[]{"MyLabel"});
            }
        }});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, monitor, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).noRelationshipTypeSpecified(sourceDescription);
    }

    @Test
    void shouldReportNoRelationshipType() {
        String sourceDescription = "source";
        final Supplier<CharReadable> headerSource = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":START_ID,:END_ID", sourceDescription), (long)3L);
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object)((CharReadable)headerSource.get())));
            }

            public Decorator decorator() {
                return InputEntityDecorators.NO_DECORATOR;
            }
        }});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, monitor, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor)).noRelationshipTypeSpecified(sourceDescription);
    }

    @Test
    void shouldNotReportNoRelationshipTypeIfDecorated() {
        String sourceDescription = "source";
        final Supplier<CharReadable> headerSource = () -> Readables.wrap((Reader)CsvInputTest.dataWithSourceDescription(":START_ID,:END_ID", sourceDescription), (long)3L);
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{config -> new Data(){

            public RawIterator<CharReadable, IOException> stream() {
                return Iterators.asRawIterator((Iterator)Iterators.iterator((Object)((CharReadable)headerSource.get())));
            }

            public Decorator decorator() {
                return InputEntityDecorators.defaultRelationshipType((String)"MyType");
            }
        }});
        CsvInput.Monitor monitor = (CsvInput.Monitor)Mockito.mock(CsvInput.Monitor.class);
        new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, false, monitor, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((CsvInput.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).noRelationshipTypeSpecified(sourceDescription);
    }

    @Test
    void shouldReportDuplicateNodeHeader() throws FileNotFoundException {
        Path file = this.directory.file("node-header");
        try (PrintWriter writer = new PrintWriter(file.toFile());){
            writer.println(":ID,name:string,name");
        }
        try {
            new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (Path[])new Path[]{file})}), DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, Configuration.COMMAS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed");
        }
        catch (DuplicateHeaderException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)file.getFileName().toString()));
        }
    }

    @Test
    void shouldReportDuplicateRelationshipHeader() throws FileNotFoundException {
        Path file = this.directory.file("relationship-header");
        try (PrintWriter writer = new PrintWriter(file.toFile());){
            writer.println(":START_ID,:TYPE,:END_ID,:TYPE,name:string");
        }
        try {
            new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (Path[])new Path[]{file})}), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, Configuration.COMMAS, false, CsvInput.NO_MONITOR, this.groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed");
        }
        catch (DuplicateHeaderException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)file.getFileName().toString()));
        }
    }

    @Test
    void shouldThrowOnReferencedNodeSchemaWithoutExplicitLabelOptionData() throws FileNotFoundException {
        Path file = this.directory.file("relationship-header");
        try (PrintWriter writer = new PrintWriter(file.toFile());){
            writer.println("myId:ID(Person)\tname:string\t:LABEL");
        }
        try (CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (Path[])new Path[]{file})}), DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, Configuration.TABS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            TokenHolders tokenHolders = new TokenHolders(this.tokenHolder(Map.of("myId", 4)), this.tokenHolder(Map.of("Person", 2)), this.tokenHolder(Map.of()));
            Assertions.assertThatThrownBy(() -> input.referencedNodeSchema(tokenHolders)).hasMessageContaining("No label was specified");
        }
    }

    @Test
    void shouldParseReferencedNodeSchemaWithExplicitLabelOptionData() throws FileNotFoundException {
        Path file = this.directory.file("relationship-header");
        try (PrintWriter writer = new PrintWriter(file.toFile());){
            writer.println("myId:ID(My Group){label:Person}\tname:string\t:LABEL");
        }
        try (CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (Path[])new Path[]{file})}), DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, Configuration.TABS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            TokenHolders tokenHolders = new TokenHolders(this.tokenHolder(Map.of("myId", 4)), this.tokenHolder(Map.of("Person", 2)), this.tokenHolder(Map.of()));
            Map schema = input.referencedNodeSchema(tokenHolders);
            Assertions.assertThat((Map)schema).isEqualTo(Map.of("My Group", SchemaDescriptors.forLabel((int)2, (int[])new int[]{4})));
        }
    }

    private TokenHolder tokenHolder(Map<String, Integer> tokens) {
        DelegatingTokenHolder tokenHolder = new DelegatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "type");
        tokenHolder.setInitialTokens(tokens.entrySet().stream().map(e -> new NamedToken((String)e.getKey(), ((Integer)e.getValue()).intValue())).toList());
        return tokenHolder;
    }

    private static void assertEstimatesEquals(Input.Estimates a, Input.Estimates b, double errorMargin) {
        org.junit.jupiter.api.Assertions.assertEquals((double)a.numberOfNodes(), (double)b.numberOfNodes(), (double)((double)a.numberOfNodes() * errorMargin));
        org.junit.jupiter.api.Assertions.assertEquals((double)a.numberOfNodeLabels(), (double)b.numberOfNodeLabels(), (double)((double)a.numberOfNodeLabels() * errorMargin));
        org.junit.jupiter.api.Assertions.assertEquals((double)a.numberOfNodeProperties(), (double)b.numberOfNodeProperties(), (double)((double)a.numberOfNodeProperties() * errorMargin));
        org.junit.jupiter.api.Assertions.assertEquals((double)a.numberOfRelationships(), (double)b.numberOfRelationships(), (double)((double)a.numberOfRelationships() * errorMargin));
        org.junit.jupiter.api.Assertions.assertEquals((double)a.numberOfRelationshipProperties(), (double)b.numberOfRelationshipProperties(), (double)((double)a.numberOfRelationshipProperties() * errorMargin));
        org.junit.jupiter.api.Assertions.assertEquals((double)a.sizeOfNodeProperties(), (double)b.sizeOfNodeProperties(), (double)((double)a.sizeOfNodeProperties() * errorMargin));
        org.junit.jupiter.api.Assertions.assertEquals((double)a.sizeOfRelationshipProperties(), (double)b.sizeOfRelationshipProperties(), (double)((double)a.sizeOfRelationshipProperties() * errorMargin));
    }

    private static Input.Estimates calculateEstimatesOnSingleFileNodeData(IdType idType, Path nodeDataFile) throws IOException {
        CsvInput input = new CsvInput(CsvInputTest.dataIterable(config -> Data.undecorated(() -> Readables.individualFiles((Charset)Charset.defaultCharset(), (Path[])new Path[]{nodeDataFile}))), DataFactories.defaultFormatNodeFileHeader(), Collections.emptyList(), DataFactories.defaultFormatRelationshipFileHeader(), idType, Configuration.COMMAS, false, CsvInput.NO_MONITOR, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return input.calculateEstimates((values, tracer, memTracker) -> Stream.of(values).mapToInt(v -> v.toString().length()).sum());
    }

    private Path compressWithZip(Path uncompressedFile) throws IOException {
        Path file = this.directory.file(uncompressedFile.getFileName() + "-compressed");
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file.toFile()));
             BufferedInputStream in = new BufferedInputStream(new FileInputStream(uncompressedFile.toFile()));){
            out.putNextEntry(new ZipEntry(uncompressedFile.getFileName().toString()));
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return file;
    }

    private Path compressWithGZip(Path uncompressedFile) throws IOException {
        Path file = this.directory.file(uncompressedFile.getFileName() + "-compressed");
        try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(file.toFile()));
             BufferedInputStream in = new BufferedInputStream(new FileInputStream(uncompressedFile.toFile()));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return file;
    }

    private Path createNodeInputDataFile(long roughSize) throws FileNotFoundException {
        Path file = this.directory.file("data-file");
        final MutableLong bytesWritten = new MutableLong();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file.toFile())){

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                bytesWritten.add((long)len);
            }

            @Override
            public synchronized void write(int b) throws IOException {
                super.write(b);
                bytesWritten.add(1L);
            }

            @Override
            public void write(byte[] b) throws IOException {
                super.write(b);
                bytesWritten.add((long)b.length);
            }
        };
        try (PrintWriter writer = new PrintWriter(out);){
            writer.println(":ID,name:string,prop:int");
            while (bytesWritten.longValue() < roughSize) {
                writer.println(String.format("%s,%s,%d", this.random.nextAlphaNumericString(6, 6), this.random.nextAlphaNumericString(5, 20), this.random.nextInt()));
            }
        }
        return file;
    }

    private static Data dataItem(CharReadable data, Decorator decorator) {
        return DataFactories.data((Decorator)decorator, () -> data).create(Configuration.COMMAS);
    }

    private void assertNextRelationship(InputIterator relationship, Object startNode, Object endNode, String type, Object[] properties) throws IOException {
        this.assertRelationship(relationship, this.globalGroup, startNode, this.globalGroup, endNode, type, properties);
    }

    private void assertRelationship(InputIterator data, Group startNodeGroup, Object startNode, Group endNodeGroup, Object endNode, String type, Object[] properties) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.readNext(data));
        org.junit.jupiter.api.Assertions.assertEquals((Object)startNodeGroup, (Object)this.visitor.startIdGroup);
        org.junit.jupiter.api.Assertions.assertEquals((Object)startNode, (Object)this.visitor.startId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)endNodeGroup, (Object)this.visitor.endIdGroup);
        org.junit.jupiter.api.Assertions.assertEquals((Object)endNode, (Object)this.visitor.endId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)type, (Object)this.visitor.stringType);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])properties, (Object[])this.visitor.properties());
    }

    private void assertNextNode(InputIterator data, Object id, Object[] properties, Set<String> labels) throws IOException {
        this.assertNextNode(data, this.globalGroup, id, properties, labels);
    }

    private void assertNextNode(InputIterator data, Group group, Object id, Object[] properties, Set<String> labels) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.readNext(data));
        org.junit.jupiter.api.Assertions.assertEquals((Object)group, (Object)this.visitor.idGroup);
        org.junit.jupiter.api.Assertions.assertEquals((Object)id, (Object)this.visitor.id());
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])properties, (Object[])this.visitor.properties());
        org.junit.jupiter.api.Assertions.assertEquals(labels, (Object)Iterators.asSet((Object[])this.visitor.labels()));
    }

    private boolean readNext(InputIterator data) throws IOException {
        if (this.referenceData != data) {
            this.chunk = null;
            this.referenceData = data;
        }
        if (this.chunk == null) {
            this.chunk = data.newChunk();
            if (!data.next(this.chunk)) {
                return false;
            }
        }
        if (this.chunk.next((InputEntityVisitor)this.visitor)) {
            return true;
        }
        if (!data.next(this.chunk)) {
            return false;
        }
        return this.chunk.next((InputEntityVisitor)this.visitor);
    }

    private static Object[] properties(Object ... keysAndValues) {
        return keysAndValues;
    }

    private static Set<String> labels(String ... labels) {
        return Iterators.asSet((Object[])labels);
    }

    private static Header.Factory header(final Header.Entry ... entries) {
        return new Header.Factory(){

            public boolean isDefined() {
                return true;
            }

            public Header create(CharSeeker dataSeeker, Configuration configuration, IdType idType, Groups groups, Header.Monitor monitor) {
                return new Header(entries);
            }
        };
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor) {
        return this.entry(name, type, null, extractor);
    }

    private Header.Entry entry(String name, Type type, String groupName, Extractor<?> extractor) {
        return new Header.Entry(name, type, this.groups.getOrCreate(groupName), extractor);
    }

    private static DataFactory data(String sourceDescription, String data) {
        return config -> CsvInputTest.dataItem(CsvInputTest.charReader(sourceDescription, data), d -> d);
    }

    private static DataFactory data(String data) {
        return CsvInputTest.data(data, value -> value);
    }

    private static DataFactory data(String data, Decorator decorator) {
        return config -> CsvInputTest.dataItem(CsvInputTest.charReader(data), decorator);
    }

    private static CharReadable charReader(String sourceDescription, String data) {
        return Readables.wrap((String)sourceDescription, (String)data);
    }

    private static CharReadable charReader(String data) {
        return Readables.wrap((String)data);
    }

    private static Iterable<DataFactory> dataIterable(DataFactory ... data) {
        return Iterables.iterable((Object[])data);
    }

    private static Configuration config(boolean allowMultilineFields) {
        return Configuration.COMMAS.toBuilder().withMultilineFields(allowMultilineFields).build();
    }

    private static class CapturingDataFactories
    implements Iterable<DataFactory> {
        private final Function<Configuration, CharReadable> factory;
        private CharReadable last;
        private final Decorator decorator;

        CapturingDataFactories(Function<Configuration, CharReadable> factory, Decorator decorator) {
            this.factory = factory;
            this.decorator = decorator;
        }

        @Override
        public Iterator<DataFactory> iterator() {
            return Iterators.iterator(config -> new Data(){

                public RawIterator<CharReadable, IOException> stream() {
                    last = factory.apply(config);
                    return Readables.iterator(in -> in, (Object[])new CharReadable[]{last});
                }

                public Decorator decorator() {
                    return decorator;
                }
            });
        }

        CharReadable last() {
            return this.last;
        }
    }

    private static class FailingNodeDecorator
    implements Decorator {
        private final RuntimeException failure;

        FailingNodeDecorator(RuntimeException failure) {
            this.failure = failure;
        }

        public InputEntityVisitor apply(InputEntityVisitor t) {
            return new InputEntityVisitor.Delegate(t){

                public void endOfEntity() {
                    throw failure;
                }
            };
        }
    }
}

