/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.function.IOFunctions;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.batchimport.input.DuplicateHeaderException;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;

public class DataFactoriesTest {
    private static final int BUFFER_SIZE = 10000;
    private static final Configuration COMMAS = Configuration.COMMAS.toBuilder().withBufferSize(10000).build();
    private static final Configuration TABS = Configuration.TABS.toBuilder().withBufferSize(10000).build();
    private final Groups groups = new Groups();
    private final Group globalGroup = this.groups.getOrCreate(null);
    private static final Configuration SEEKER_CONFIG = Configuration.TABS.toBuilder().withBufferSize(1000).build();

    @Test
    public void shouldParseDefaultNodeFileHeaderCorrectly() throws Exception {
        CharSeeker seeker = DataFactoriesTest.seeker("ID:ID,label-one:label,also-labels:LABEL,name,age:long,location:Point{crs:WGS-84}");
        IdType idType = IdType.STRING;
        Extractors extractors = new Extractors(',');
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, COMMAS, idType, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("ID", Type.ID, this.globalGroup, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry("label-one", Type.LABEL, extractors.stringArray()), this.entry("also-labels", Type.LABEL, extractors.stringArray()), this.entry("name", Type.PROPERTY, extractors.string()), this.entry("age", Type.PROPERTY, (Extractor<?>)extractors.long_()), this.entry("location", Type.PROPERTY, (Extractor<?>)extractors.point(), Map.of("crs", "WGS-84"), (CSVHeaderInformation)PointValue.parseHeaderInformation((CharSequence)"{crs:WGS-84}"))}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseNodeArrayTypesHeaderCorrectly() throws Exception {
        CharSeeker seeker = DataFactoriesTest.seeker("ID:ID,longArray:long[],pointArray:Point[]{crs:WGS-84},timeArray:time[]{timezone:+02:00},dateTimeArray:datetime[]{timezone:+02:00}");
        IdType idType = IdType.STRING;
        Extractors extractors = new Extractors(',');
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, COMMAS, idType, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("ID", Type.ID, this.globalGroup, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry("longArray", Type.PROPERTY, extractors.longArray()), this.entry("pointArray", Type.PROPERTY, (Extractor<?>)extractors.pointArray(), Map.of("crs", "WGS-84"), (CSVHeaderInformation)PointValue.parseHeaderInformation((CharSequence)"{crs:WGS-84}")), this.entry("timeArray", Type.PROPERTY, (Extractor<?>)extractors.timeArray(), Map.of("timezone", "+02:00"), (CSVHeaderInformation)TimeValue.parseHeaderInformation((String)"{timezone:+02:00}")), this.entry("dateTimeArray", Type.PROPERTY, (Extractor<?>)extractors.dateTimeArray(), Map.of("timezone", "+02:00"), (CSVHeaderInformation)DateTimeValue.parseHeaderInformation((String)"{timezone:+02:00}"))}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseDefaultRelationshipFileHeaderCorrectly() throws Exception {
        CharSeeker seeker = DataFactoriesTest.seeker(":START_ID\t:END_ID\ttype:TYPE\tdate:long\tmore:long[]");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatRelationshipFileHeader().create(seeker, TABS, idType, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry(null, Type.START_ID, this.globalGroup, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry(null, Type.END_ID, this.globalGroup, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry("type", Type.TYPE, extractors.string()), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_()), this.entry("more", Type.PROPERTY, extractors.longArray())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParsetRelationshipArrayTypesFileHeaderCorrectly() throws Exception {
        CharSeeker seeker = DataFactoriesTest.seeker(":START_ID\t:END_ID\ttype:TYPE\tlongArray:long[]\tpointArray:Point[]{crs:WGS-84}\ttimeArray:time[]{timezone:+02:00}\tdateTimeArray:datetime[]{timezone:+02:00}");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatRelationshipFileHeader().create(seeker, TABS, idType, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry(null, Type.START_ID, this.globalGroup, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry(null, Type.END_ID, this.globalGroup, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry("type", Type.TYPE, extractors.string()), this.entry("longArray", Type.PROPERTY, extractors.longArray()), this.entry("pointArray", Type.PROPERTY, (Extractor<?>)extractors.pointArray(), Map.of("crs", "WGS-84"), (CSVHeaderInformation)PointValue.parseHeaderInformation((CharSequence)"{crs:WGS-84}")), this.entry("timeArray", Type.PROPERTY, (Extractor<?>)extractors.timeArray(), Map.of("timezone", "+02:00"), (CSVHeaderInformation)TimeValue.parseHeaderInformation((String)"{timezone:+02:00}")), this.entry("dateTimeArray", Type.PROPERTY, (Extractor<?>)extractors.dateTimeArray(), Map.of("timezone", "+02:00"), (CSVHeaderInformation)DateTimeValue.parseHeaderInformation((String)"{timezone:+02:00}"))}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldHaveEmptyHeadersBeInterpretedAsIgnored() throws Exception {
        CharSeeker seeker = DataFactoriesTest.seeker("one:id\ttwo\t\tdate:long");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, idType, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("one", Type.ID, this.globalGroup, (Extractor<?>)extractors.long_()), this.entry("two", Type.PROPERTY, extractors.string()), this.entry(null, Type.IGNORE, null), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldFailForDuplicatePropertyHeaderEntries() throws Exception {
        CharSeeker seeker = DataFactoriesTest.seeker("one:id\tname\tname:long");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        DuplicateHeaderException e = (DuplicateHeaderException)org.junit.jupiter.api.Assertions.assertThrows(DuplicateHeaderException.class, () -> DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, idType, this.groups));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.entry("name", Type.PROPERTY, extractors.string()), (Object)e.getFirst());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.entry("name", Type.PROPERTY, (Extractor<?>)extractors.long_()), (Object)e.getOther());
        seeker.close();
    }

    @Test
    public void shouldFailForDuplicateIdHeaderEntries() {
        CharSeeker seeker = DataFactoriesTest.seeker("one:id\ttwo:id");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        DuplicateHeaderException e = (DuplicateHeaderException)org.junit.jupiter.api.Assertions.assertThrows(DuplicateHeaderException.class, () -> DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, idType, this.groups));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.entry("one", Type.ID, this.globalGroup, (Extractor<?>)extractors.long_()), (Object)e.getFirst());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.entry("two", Type.ID, this.globalGroup, (Extractor<?>)extractors.long_()), (Object)e.getOther());
    }

    @Test
    public void shouldAllowMissingIdHeaderEntry() throws Exception {
        CharSeeker seeker = DataFactoriesTest.seeker("one\ttwo");
        Extractors extractors = new Extractors(';');
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, IdType.ACTUAL, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("one", Type.PROPERTY, extractors.string()), this.entry("two", Type.PROPERTY, extractors.string())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseHeaderFromFirstLineOfFirstInputFile() throws Exception {
        CharReadable firstSource = Readables.wrap((String)"id:ID\tname:String\tbirth_date:long");
        CharReadable secondSource = Readables.wrap((String)"0\tThe node\t123456789");
        DataFactory dataFactory = DataFactories.data(value -> value, () -> new MultiReadable(Readables.iterator((ThrowingFunction)IOFunctions.identity(), (Object[])new CharReadable[]{firstSource, secondSource})));
        Header.Factory headerFactory = DataFactories.defaultFormatNodeFileHeader();
        Extractors extractors = new Extractors(';');
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)new MultiReadable(dataFactory.create(TABS).stream()), (Configuration)TABS, (boolean)false);
        Header header = headerFactory.create(seeker, TABS, IdType.ACTUAL, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, this.globalGroup, (Extractor<?>)extractors.long_()), this.entry("name", Type.PROPERTY, extractors.string()), this.entry("birth_date", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseGroupName() throws Exception {
        String groupOneName = "GroupOne";
        String groupTwoName = "GroupTwo";
        CharSeeker seeker = DataFactoriesTest.seeker(":START_ID(" + groupOneName + ")\t:END_ID(" + groupTwoName + ")\ttype:TYPE\tdate:long\tmore:long[]");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        this.groups.getOrCreate(groupOneName);
        this.groups.getOrCreate(groupTwoName);
        Header header = DataFactories.defaultFormatRelationshipFileHeader().create(seeker, TABS, idType, this.groups);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry(null, Type.START_ID, this.groups.get("GroupOne"), CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry(null, Type.END_ID, this.groups.get("GroupTwo"), CsvInput.idExtractor((IdType)idType, (Extractors)extractors)), this.entry("type", Type.TYPE, extractors.string()), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_()), this.entry("more", Type.PROPERTY, extractors.longArray())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldFailOnUnexpectedNodeHeaderType() {
        CharSeeker seeker = DataFactoriesTest.seeker(":ID,:START_ID");
        IdType idType = IdType.ACTUAL;
        InputException e = (InputException)org.junit.jupiter.api.Assertions.assertThrows(InputException.class, () -> DataFactories.defaultFormatNodeFileHeader().create(seeker, COMMAS, idType, this.groups));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"START_ID"});
    }

    @Test
    public void shouldFailOnUnexpectedRelationshipHeaderType() {
        CharSeeker seeker = DataFactoriesTest.seeker(":LABEL,:START_ID,:END_ID,:TYPE");
        IdType idType = IdType.ACTUAL;
        InputException e = (InputException)org.junit.jupiter.api.Assertions.assertThrows(InputException.class, () -> DataFactories.defaultFormatRelationshipFileHeader().create(seeker, COMMAS, idType, this.groups));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"LABEL"});
    }

    @Test
    void shouldParseHeaderOptionsMap() {
        CharSeeker seeker = DataFactoriesTest.seeker("id:ID(myGroup){myFirstKey:10,mySecondKey:\"Some string\"}\t:LABEL");
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, IdType.ACTUAL, this.groups);
        Extractors extractors = new Extractors(';');
        Assertions.assertThat((Object[])header.entries()).isEqualTo((Object)ArrayUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, this.groups.get("myGroup"), (Extractor<?>)extractors.long_(), Map.of("myFirstKey", "10", "mySecondKey", "Some string"), null), this.entry(null, Type.LABEL, extractors.stringArray())}));
    }

    @Test
    void shouldParseHeaderOptionsMapEvenWhenItIsBeforeTheGroup() {
        CharSeeker seeker = DataFactoriesTest.seeker("id:ID{myFirstKey:10,mySecondKey:\"Some string\"}(myGroup)\t:LABEL");
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, IdType.ACTUAL, this.groups);
        Extractors extractors = new Extractors(';');
        Assertions.assertThat((Object[])header.entries()).isEqualTo((Object)ArrayUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, this.groups.get("myGroup"), (Extractor<?>)extractors.long_(), Map.of("myFirstKey", "10", "mySecondKey", "Some string"), null), this.entry(null, Type.LABEL, extractors.stringArray())}));
    }

    @Test
    void shouldParseHeaderOptionsMapWithoutGroup() {
        CharSeeker seeker = DataFactoriesTest.seeker("id:ID{myFirstKey:10,mySecondKey:\"Some string\"}\t:LABEL");
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, IdType.ACTUAL, this.groups);
        Extractors extractors = new Extractors(';');
        Assertions.assertThat((Object[])header.entries()).isEqualTo((Object)ArrayUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, this.globalGroup, (Extractor<?>)extractors.long_(), Map.of("myFirstKey", "10", "mySecondKey", "Some string"), null), this.entry(null, Type.LABEL, extractors.stringArray())}));
    }

    @Test
    void shouldCreateGroupWithSpecificIdType() {
        CharSeeker seeker = DataFactoriesTest.seeker("id:ID(MyGroup){id-type:long}");
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, IdType.STRING, this.groups);
        Extractors extractors = new Extractors(';');
        Group group = this.groups.get("MyGroup");
        Assertions.assertThat((Object[])header.entries()).isEqualTo((Object)ArrayUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, group, (Extractor<?>)extractors.long_(), Map.of("id-type", "long"), null)}));
        Assertions.assertThat((String)group.specificIdType()).isEqualTo("long");
    }

    private static CharSeeker seeker(String data) {
        return CharSeekers.charSeeker((CharReadable)Readables.wrap((String)data), (Configuration)SEEKER_CONFIG, (boolean)false);
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor) {
        return this.entry(name, type, null, extractor);
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor, Map<String, String> rawOptions, CSVHeaderInformation optionalParameter) {
        return new Header.Entry(null, name, type, null, extractor, rawOptions, optionalParameter);
    }

    private Header.Entry entry(String name, Type type, Group group, Extractor<?> extractor, Map<String, String> rawOptions, CSVHeaderInformation optionalParameter) {
        return new Header.Entry(null, name, type, group, extractor, rawOptions, optionalParameter);
    }

    private Header.Entry entry(String name, Type type, Group group, Extractor<?> extractor) {
        return new Header.Entry(name, type, group, extractor);
    }
}

