/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.lang.reflect.Array;
import java.util.function.Function;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.internal.batchimport.input.csv.Deserialization;
import org.neo4j.internal.batchimport.input.csv.Header;

public class StringDeserialization
implements Deserialization<String> {
    private final StringBuilder builder = new StringBuilder();
    private final Configuration config;
    private int field;

    public StringDeserialization(Configuration config) {
        this.config = config;
    }

    public void handle(Header.Entry entry, Object value) {
        if (this.field > 0) {
            this.builder.append(this.config.delimiter());
        }
        if (value != null) {
            this.stringify(value);
        }
        ++this.field;
    }

    private void stringify(Object value) {
        if (value instanceof String) {
            boolean quote;
            String string = (String)value;
            boolean bl = quote = string.indexOf(46) != -1 || string.indexOf(this.config.quotationCharacter()) != -1;
            if (quote) {
                this.builder.append(this.config.quotationCharacter());
            }
            this.builder.append(string);
            if (quote) {
                this.builder.append(this.config.quotationCharacter());
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                if (i > 0) {
                    this.builder.append(this.config.arrayDelimiter());
                }
                this.stringify(item);
            }
        } else if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Float) {
                this.builder.append(number.floatValue());
            } else if (value instanceof Double) {
                this.builder.append(number.doubleValue());
            } else {
                this.builder.append(number.longValue());
            }
        } else if (value instanceof Boolean) {
            this.builder.append((Boolean)value);
        } else {
            throw new IllegalArgumentException(value + " " + value.getClass().getSimpleName());
        }
    }

    public String materialize() {
        return this.builder.toString();
    }

    public void clear() {
        this.builder.delete(0, this.builder.length());
        this.field = 0;
    }

    public static Function<SourceTraceability, Deserialization<String>> factory(Configuration config) {
        return from -> new StringDeserialization(config);
    }
}

