/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.StringDeserialization;
import org.neo4j.internal.batchimport.input.csv.Type;

class StringDeserializationTest {
    private final Configuration configuration = Configuration.COMMAS;
    private final Extractors extractors = new Extractors(this.configuration.arrayDelimiter());
    private final Header.Entry entry1 = new Header.Entry(null, Type.START_ID, null, (Extractor)this.extractors.int_());
    private final Header.Entry entry2 = new Header.Entry(null, Type.TYPE, null, this.extractors.string());
    private final Header.Entry entry3 = new Header.Entry(null, Type.END_ID, null, (Extractor)this.extractors.int_());

    StringDeserializationTest() {
    }

    @Test
    void shouldProvideDelimiterAfterFirstEmptyField() {
        StringDeserialization deserialization = new StringDeserialization(this.configuration);
        deserialization.handle(this.entry1, null);
        deserialization.handle(this.entry2, "MyType");
        deserialization.handle(this.entry3, 123);
        String line = deserialization.materialize();
        Assertions.assertEquals((Object)line, (Object)",MyType,123");
    }

    @Test
    void shouldProvideDelimiterBeforeLastEmptyField() {
        StringDeserialization deserialization = new StringDeserialization(this.configuration);
        deserialization.handle(this.entry1, 123);
        deserialization.handle(this.entry2, "MyType");
        deserialization.handle(this.entry3, null);
        String line = deserialization.materialize();
        Assertions.assertEquals((Object)line, (Object)"123,MyType,");
    }
}

