/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ControlledStep;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.stats.Keys;

class CoarseBoundedProgressExecutionMonitorTest {
    CoarseBoundedProgressExecutionMonitorTest() {
    }

    @ParameterizedTest
    @ValueSource(ints={1, 10, 123})
    void shouldReportProgressOnSingleExecution(int batchSize) {
        Configuration config = CoarseBoundedProgressExecutionMonitorTest.config(batchSize);
        ProgressExecutionMonitor progressExecutionMonitor = new ProgressExecutionMonitor(batchSize, CoarseBoundedProgressExecutionMonitorTest.config(batchSize));
        long total = CoarseBoundedProgressExecutionMonitorTest.monitorSingleStageExecution(progressExecutionMonitor, config);
        Assertions.assertEquals((long)total, (long)progressExecutionMonitor.getProgress());
    }

    @ParameterizedTest
    @ValueSource(ints={1, 10, 123})
    void progressOnMultipleExecutions(int batchSize) {
        Configuration config = CoarseBoundedProgressExecutionMonitorTest.config(batchSize);
        ProgressExecutionMonitor progressExecutionMonitor = new ProgressExecutionMonitor(batchSize, config);
        long total = progressExecutionMonitor.total();
        for (int i = 0; i < 4; ++i) {
            progressExecutionMonitor.start(CoarseBoundedProgressExecutionMonitorTest.execution(0L, config));
            progressExecutionMonitor.check(CoarseBoundedProgressExecutionMonitorTest.execution(total / 4L, config));
        }
        progressExecutionMonitor.done(true, 0L, "Completed");
        Assertions.assertEquals((long)total, (long)progressExecutionMonitor.getProgress(), (String)"Each item should be completed");
    }

    private static long monitorSingleStageExecution(ProgressExecutionMonitor progressExecutionMonitor, Configuration config) {
        progressExecutionMonitor.start(CoarseBoundedProgressExecutionMonitorTest.execution(0L, config));
        long total = progressExecutionMonitor.total();
        long part = total / 10L;
        for (int i = 0; i < 9; ++i) {
            progressExecutionMonitor.check(CoarseBoundedProgressExecutionMonitorTest.execution(part * (long)(i + 1), config));
            Assertions.assertTrue((progressExecutionMonitor.getProgress() < total ? 1 : 0) != 0);
        }
        progressExecutionMonitor.done(true, 0L, "Test");
        return total;
    }

    private static StageExecution execution(long doneBatches, Configuration config) {
        ControlledStep<?> step = ControlledStep.stepWithStats("Test", 0, Keys.done_batches, doneBatches);
        return new StageExecution("Test", null, config, Collections.singletonList(step), 0);
    }

    private static Configuration config(final int batchSize) {
        return new Configuration.Overridden(Configuration.DEFAULT){

            public int batchSize() {
                return batchSize;
            }
        };
    }

    private static class ProgressExecutionMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private long progress;

        ProgressExecutionMonitor(int batchSize, Configuration configuration) {
            super((long)(100 * batchSize), (long)(100 * batchSize), configuration);
        }

        protected void progress(long progress) {
            this.progress += progress;
        }

        long getProgress() {
            return this.progress;
        }
    }
}

