/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.ControlledStep;
import org.neo4j.internal.batchimport.staging.DynamicProcessorAssigner;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.Keys;

class DynamicProcessorAssignerTest {
    DynamicProcessorAssignerTest() {
    }

    @Test
    void shouldAssignProcessorsToSlowestStep() {
        Configuration config = DynamicProcessorAssignerTest.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> slowStep = ControlledStep.stepWithStats("slow", 0, Keys.avg_processing_time, 10L, Keys.done_batches, 10L);
        ControlledStep<?> fastStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 2L, Keys.done_batches, 10L);
        StageExecution execution = DynamicProcessorAssignerTest.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        Assertions.assertEquals((int)4, (int)slowStep.processors(0));
        Assertions.assertEquals((int)1, (int)fastStep.processors(0));
    }

    @Test
    void shouldMoveProcessorFromOverlyAssignedStep() {
        Configuration config = DynamicProcessorAssignerTest.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> slowStep = ControlledStep.stepWithStats("slow", 0, Keys.avg_processing_time, 6L, Keys.done_batches, 10L).setProcessors(2);
        ControlledStep<?> fastStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 2L, Keys.done_batches, 10L).setProcessors(3);
        StageExecution execution = DynamicProcessorAssignerTest.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        Assertions.assertEquals((int)2, (int)fastStep.processors(0));
        Assertions.assertEquals((int)3, (int)slowStep.processors(0));
    }

    @Test
    void shouldNotMoveProcessorFromFastStepSoThatItBecomesBottleneck() {
        Configuration config = DynamicProcessorAssignerTest.config(10, 4);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> slowStep = ControlledStep.stepWithStats("slow", 1, Keys.avg_processing_time, 10L, Keys.done_batches, 10L);
        ControlledStep<?> fastStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 7L, Keys.done_batches, 10L).setProcessors(3);
        StageExecution execution = DynamicProcessorAssignerTest.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        Assertions.assertEquals((int)3, (int)fastStep.processors(0));
        Assertions.assertEquals((int)1, (int)slowStep.processors(0));
    }

    @Test
    void shouldHandleZeroAverage() {
        Configuration config = DynamicProcessorAssignerTest.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> aStep = ControlledStep.stepWithStats("slow", 0, Keys.avg_processing_time, 0L, Keys.done_batches, 0L);
        ControlledStep<?> anotherStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 0L, Keys.done_batches, 0L);
        StageExecution execution = DynamicProcessorAssignerTest.executionOf(config, aStep, anotherStep);
        assigner.start(execution);
        assigner.check(execution);
        Assertions.assertEquals((int)1, (int)aStep.processors(0));
        Assertions.assertEquals((int)1, (int)anotherStep.processors(0));
    }

    @Test
    void shouldMoveProcessorFromNotOnlyFastestStep() {
        Configuration config = DynamicProcessorAssignerTest.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> wayFastest = ControlledStep.stepWithStats("wayFastest", 0, Keys.avg_processing_time, 50L, Keys.done_batches, 20L);
        ControlledStep<?> fast = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 100L, Keys.done_batches, 20L).setProcessors(3);
        ControlledStep<?> slow = ControlledStep.stepWithStats("slow", 2, Keys.avg_processing_time, 220L, Keys.done_batches, 20L);
        StageExecution execution = DynamicProcessorAssignerTest.executionOf(config, slow, wayFastest, fast);
        assigner.start(execution);
        assigner.check(execution);
        Assertions.assertEquals((int)2, (int)fast.processors(0));
        Assertions.assertEquals((int)2, (int)slow.processors(0));
    }

    @Test
    void shouldNotMoveProcessorFromOverlyAssignedStepIfRemainingPermits() {
        Configuration config = DynamicProcessorAssignerTest.config(10, 10);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> wayFastest = ControlledStep.stepWithStats("wayFastest", 0, Keys.avg_processing_time, 50L, Keys.done_batches, 20L);
        ControlledStep<?> fast = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 100L, Keys.done_batches, 20L).setProcessors(3);
        ControlledStep<?> slow = ControlledStep.stepWithStats("slow", 2, Keys.avg_processing_time, 220L, Keys.done_batches, 20L);
        StageExecution execution = DynamicProcessorAssignerTest.executionOf(config, slow, wayFastest, fast);
        assigner.start(execution);
        assigner.check(execution);
        Assertions.assertEquals((int)3, (int)fast.processors(0));
        Assertions.assertEquals((int)2, (int)slow.processors(0));
    }

    private static Configuration config(final int movingAverage, final int processors) {
        return new Configuration(){

            public int movingAverageSize() {
                return movingAverage;
            }

            public int maxNumberOfWorkerThreads() {
                return processors;
            }
        };
    }

    private static StageExecution executionOf(Configuration config, Step<?> ... steps) {
        return new StageExecution("Test", null, config, Arrays.asList(steps), 1);
    }
}

