/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.StageExecution;

class ExecutionSupervisorsTest {
    ExecutionSupervisorsTest() {
    }

    @Test
    void shouldStartCheckAndEndMonitor() throws InterruptedException {
        final AtomicBoolean started = new AtomicBoolean();
        final AtomicBoolean ended = new AtomicBoolean();
        final AtomicInteger checked = new AtomicInteger();
        ExecutionMonitor.Adapter monitor = new ExecutionMonitor.Adapter(1L, TimeUnit.MILLISECONDS){

            public void start(StageExecution execution) {
                started.set(true);
            }

            public void end(StageExecution execution, long totalTimeMillis) {
                ended.set(true);
            }

            public void check(StageExecution execution) {
                checked.incrementAndGet();
            }
        };
        Stage stage = (Stage)Mockito.mock(Stage.class);
        StageExecution execution = (StageExecution)Mockito.mock(StageExecution.class);
        Mockito.when((Object)stage.execute()).thenReturn((Object)execution);
        int checks = 10;
        AtomicInteger completionCounter = new AtomicInteger(checks);
        Mockito.when((Object)execution.awaitCompletion(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenAnswer(invocation -> completionCounter.getAndDecrement() == 0);
        ExecutionSupervisors.superviseExecution((ExecutionMonitor)monitor, (Stage)stage);
        Assertions.assertThat((AtomicBoolean)started).isTrue();
        Assertions.assertThat((AtomicBoolean)ended).isTrue();
        Assertions.assertThat((int)checked.get()).isEqualTo(checks);
    }
}

