/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.executor.ProcessorScheduler;
import org.neo4j.internal.batchimport.staging.LonelyProcessingStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.staging.TrackingPanicMonitor;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.test.extension.SuppressOutputExtension;

@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class LonelyProcessingStepTest {
    LonelyProcessingStepTest() {
    }

    @Test
    void issuePanicBeforeCompletionOnError() throws Exception {
        ArrayList stepsPipeline = new ArrayList();
        TrackingPanicMonitor panicMonitor = new TrackingPanicMonitor();
        FaultyLonelyProcessingStepTest faultyStep = new FaultyLonelyProcessingStepTest(stepsPipeline, panicMonitor);
        stepsPipeline.add((Step<?>)faultyStep);
        faultyStep.receive(1L, null);
        faultyStep.awaitCompleted();
        Assertions.assertTrue((boolean)faultyStep.endOfUpstreamCalled);
        Assertions.assertTrue((boolean)faultyStep.isPanicOnEndUpstream(), (String)"On upstream end step should be already on panic in case of exception");
        Assertions.assertTrue((boolean)faultyStep.isPanic());
        Assertions.assertFalse((boolean)faultyStep.stillWorking());
        Assertions.assertTrue((boolean)faultyStep.isCompleted());
        Assertions.assertTrue((boolean)panicMonitor.hasReceivedPanic());
    }

    private static class FaultyLonelyProcessingStepTest
    extends LonelyProcessingStep {
        private volatile boolean endOfUpstreamCalled;
        private volatile boolean panicOnEndUpstream;

        FaultyLonelyProcessingStepTest(List<Step<?>> pipeLine, TrackingPanicMonitor panicMonitor) {
            super((StageControl)new StageExecution("Faulty", null, Configuration.DEFAULT, pipeLine, 0, ProcessorScheduler.SPAWN_THREAD, (StageExecution.PanicMonitor)panicMonitor), "Faulty", Configuration.DEFAULT, new StatsProvider[0]);
        }

        protected void process() {
            throw new RuntimeException("Process exception");
        }

        public void endOfUpstream() {
            this.endOfUpstreamCalled = true;
            this.panicOnEndUpstream = this.isPanic();
            super.endOfUpstream();
        }

        private boolean isPanicOnEndUpstream() {
            return this.panicOnEndUpstream;
        }
    }
}

