/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;

class MultiExecutionMonitorTest {
    MultiExecutionMonitorTest() {
    }

    @Test
    void shouldCheckMultipleMonitors() {
        TestableMonitor first = new TestableMonitor(100L, TimeUnit.MILLISECONDS, "first");
        TestableMonitor other = new TestableMonitor(250L, TimeUnit.MILLISECONDS, "other");
        MultiExecutionMonitor multiMonitor = new MultiExecutionMonitor(new ExecutionMonitor[]{first, other});
        Assertions.assertThat((long)multiMonitor.checkIntervalMillis()).isEqualTo(100L);
        MultiExecutionMonitorTest.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 1, other, 0});
        MultiExecutionMonitorTest.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 2, other, 0});
        MultiExecutionMonitorTest.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 3, other, 1});
    }

    private static void expectCallsToCheck(ExecutionMonitor multiMonitor, Object ... alternatingMonitorAndCount) {
        multiMonitor.check(null);
        for (int i = 0; i < alternatingMonitorAndCount.length; ++i) {
            TestableMonitor monitor = (TestableMonitor)((Object)alternatingMonitorAndCount[i++]);
            int count = (Integer)alternatingMonitorAndCount[i];
            Assertions.assertThat((int)monitor.timesPolled).isLessThanOrEqualTo(count);
            if (monitor.timesPolled >= count) continue;
            org.junit.jupiter.api.Assertions.fail((String)("Polls didn't occur, expected " + Arrays.toString(alternatingMonitorAndCount)));
        }
    }

    private static class TestableMonitor
    extends ExecutionMonitor.Adapter {
        private int timesPolled;
        private final String name;

        TestableMonitor(long interval, TimeUnit unit, String name) {
            super(interval, unit);
            this.name = name;
        }

        public void check(StageExecution execution) {
            ++this.timesPolled;
        }

        public String toString() {
            return "[" + this.name + ":" + this.timesPolled + "]";
        }
    }
}

