/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.function.Supplier;
import org.neo4j.internal.batchimport.executor.ProcessorScheduler;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.helpers.Exceptions;

public class SimpleStageControl
implements StageControl {
    private volatile Throwable panic;
    private volatile Step<?>[] steps;

    public void steps(Step<?> ... steps) {
        this.steps = steps;
    }

    public void panic(Throwable cause) {
        this.panic = cause;
        for (Step<?> step : this.steps) {
            step.receivePanic(cause);
            step.endOfUpstream();
        }
    }

    public void assertHealthy() {
        if (this.panic != null) {
            Exceptions.throwIfUnchecked((Throwable)this.panic);
            throw new RuntimeException(this.panic);
        }
    }

    public void recycle(Object batch) {
    }

    public boolean isIdle() {
        for (int i = 1; i < this.steps.length; ++i) {
            if (this.steps[i].isIdle()) continue;
            return false;
        }
        return true;
    }

    public <T> T reuse(Supplier<T> fallback) {
        return fallback.get();
    }

    public ProcessorScheduler scheduler() {
        return ProcessorScheduler.SPAWN_THREAD;
    }
}

