/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.ControlledStep;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.WeightedStep;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;

class StageExecutionTest {
    StageExecutionTest() {
    }

    @Test
    void shouldOrderStepsAscending() {
        ArrayList steps = new ArrayList();
        steps.add(ControlledStep.stepWithAverageOf("step1", 0, 10L));
        steps.add(ControlledStep.stepWithAverageOf("step2", 0, 5L));
        steps.add(ControlledStep.stepWithAverageOf("step3", 0, 30L));
        StageExecution execution = new StageExecution("Test", null, Configuration.DEFAULT, steps, 1);
        Iterator ordered = execution.stepsOrderedBy((Key)Keys.avg_processing_time, true).iterator();
        WeightedStep fastest = (WeightedStep)ordered.next();
        Assertions.assertEquals((float)0.5f, (float)fastest.weight().floatValue(), (float)0.0f);
        WeightedStep faster = (WeightedStep)ordered.next();
        Assertions.assertEquals((float)0.33333334f, (float)faster.weight().floatValue(), (float)0.0f);
        WeightedStep fast = (WeightedStep)ordered.next();
        Assertions.assertEquals((float)1.0f, (float)fast.weight().floatValue(), (float)0.0f);
        Assertions.assertFalse((boolean)ordered.hasNext());
    }

    @Test
    void shouldOrderStepsDescending() {
        ArrayList steps = new ArrayList();
        steps.add(ControlledStep.stepWithAverageOf("step1", 0, 10L));
        steps.add(ControlledStep.stepWithAverageOf("step2", 0, 5L));
        steps.add(ControlledStep.stepWithAverageOf("step3", 0, 30L));
        steps.add(ControlledStep.stepWithAverageOf("step4", 0, 5L));
        StageExecution execution = new StageExecution("Test", null, Configuration.DEFAULT, steps, 1);
        Iterator ordered = execution.stepsOrderedBy((Key)Keys.avg_processing_time, false).iterator();
        WeightedStep slowest = (WeightedStep)ordered.next();
        Assertions.assertEquals((float)3.0f, (float)slowest.weight().floatValue(), (float)0.0f);
        WeightedStep slower = (WeightedStep)ordered.next();
        Assertions.assertEquals((float)2.0f, (float)slower.weight().floatValue(), (float)0.0f);
        WeightedStep slow = (WeightedStep)ordered.next();
        Assertions.assertEquals((float)1.0f, (float)slow.weight().floatValue(), (float)0.0f);
        WeightedStep alsoSlow = (WeightedStep)ordered.next();
        Assertions.assertEquals((float)1.0f, (float)alsoSlow.weight().floatValue(), (float)0.0f);
        Assertions.assertFalse((boolean)ordered.hasNext());
    }
}

