/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.neo4j.jdbc.Wrapper;
import org.neo4j.jdbc.utils.ExceptionBuilder;
import org.neo4j.jdbc.utils.Neo4jJdbcRuntimeException;

public abstract class Neo4jDataSource
implements DataSource {
    public static final String NEO4J_JDBC_PREFIX = "jdbc:neo4j:";
    protected String serverName = "localhost";
    protected String user;
    protected String password;
    protected int portNumber = 0;
    protected boolean isSsl = false;

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return Wrapper.unwrap(iface, this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return Wrapper.isWrapperFor(iface, this.getClass());
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getUrl(String protocol) {
        String url = NEO4J_JDBC_PREFIX + protocol + "://" + this.getServerName() + (this.getPortNumber() > 0 ? ":" + this.getPortNumber() : "") + "?" + (!this.getIsSsl() ? "nossl," : "");
        if (null != this.getUser()) {
            url = url + "user=" + this.getUser();
            if (null != this.getPassword()) {
                url = url + ",password=" + this.encodeUrlComponent(this.getPassword());
            }
        }
        return url;
    }

    public boolean getIsSsl() {
        return this.isSsl;
    }

    public void setIsSsl(boolean ssl) {
        this.isSsl = ssl;
    }

    private String encodeUrlComponent(String urlProps) {
        try {
            return URLEncoder.encode(urlProps, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Neo4jJdbcRuntimeException(e);
        }
    }

    static {
        try {
            Class.forName("org.neo4j.jdbc.Neo4jDriver");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Neo4jDataSource is unable to load org.neo4j.jdbc.Neo4jDriver. Please check if you have proper Neo4j JDBC Driver jar on the classpath", e);
        }
    }
}

