/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;

public class BoltNeo4jUtils {
    public static int calculateUpdateCount(SummaryCounters stats) {
        int objectCount = 0;
        objectCount += stats.nodesCreated();
        objectCount += stats.nodesDeleted();
        objectCount += stats.relationshipsCreated();
        objectCount += stats.relationshipsDeleted();
        int schemaCount = 0;
        schemaCount += stats.constraintsAdded();
        schemaCount += stats.constraintsRemoved();
        schemaCount += stats.indexesAdded();
        schemaCount += stats.indexesRemoved();
        schemaCount += stats.labelsAdded();
        int updateCount = objectCount == 0 ? (schemaCount += stats.labelsRemoved()) : objectCount;
        return updateCount == 0 ? stats.propertiesSet() : updateCount;
    }

    public static <R> R executeInTx(BoltNeo4jConnection connection, String sql, Map<String, Object> params, Function<Result, R> body) throws SQLException {
        try {
            Result statementResult = BoltNeo4jUtils.execute(connection, sql, params);
            R result = body.apply(statementResult);
            if (connection.getAutoCommit()) {
                connection.doCommit();
            }
            return result;
        }
        catch (Exception e) {
            connection.doRollback();
            throw new SQLException(e);
        }
    }

    public static <R> R executeInTx(BoltNeo4jConnection connection, String sql, Function<Result, R> body) throws SQLException {
        return BoltNeo4jUtils.executeInTx(connection, sql, Collections.emptyMap(), body);
    }

    public static Result execute(BoltNeo4jConnection connection, String statement, Map<String, Object> params) {
        Transaction transaction = connection.getTransaction();
        return transaction.run(statement, params);
    }
}

