/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.cache;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.jdbc.bolt.cache.BoltDriverCacheKey;
import org.neo4j.jdbc.bolt.cache.BoltDriverCached;

public class BoltDriverCache {
    private Map<BoltDriverCacheKey, Driver> cache;
    private Function<BoltDriverCacheKey, Driver> builder;

    public BoltDriverCache(Function<BoltDriverCacheKey, Driver> builder) {
        this.builder = builder;
        this.cache = new ConcurrentHashMap<BoltDriverCacheKey, Driver>();
    }

    public Driver getDriver(List<URI> routingUris, Config config, AuthToken authToken, Properties info) throws URISyntaxException {
        BoltDriverCacheKey key = new BoltDriverCacheKey(routingUris, config, authToken, info);
        Driver driver = this.cache.get(key);
        if (null == driver) {
            driver = new BoltDriverCached(this.builder.apply(key), this, key);
            this.cache.put(key, driver);
        }
        return driver;
    }

    public Driver removeFromCache(BoltDriverCacheKey key) {
        return this.cache.remove(key);
    }

    public Map<BoltDriverCacheKey, Driver> getCache() {
        return this.cache;
    }
}

