/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.cache;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.types.TypeSystem;
import org.neo4j.jdbc.bolt.cache.BoltDriverCache;
import org.neo4j.jdbc.bolt.cache.BoltDriverCacheKey;

public class BoltDriverCached
implements Driver {
    private static final UnsupportedOperationException UNSUPPORTED_OPERATION_EXCEPTION = new UnsupportedOperationException("Async operation are not supported over JDBC");
    private Driver internal;
    private BoltDriverCache cache;
    private BoltDriverCacheKey key;
    private final AtomicInteger sessionCounter = new AtomicInteger(0);

    public BoltDriverCached(Driver internal, BoltDriverCache cache, BoltDriverCacheKey key) {
        this.internal = internal;
        this.cache = cache;
        this.key = key;
    }

    @Override
    public boolean isEncrypted() {
        return this.internal.isEncrypted();
    }

    @Override
    public Session session() {
        this.sessionCounter.incrementAndGet();
        return this.internal.session();
    }

    @Override
    public Session session(SessionConfig sessionConfig) {
        this.sessionCounter.incrementAndGet();
        return this.internal.session(sessionConfig);
    }

    @Override
    public RxSession rxSession() {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public RxSession rxSession(SessionConfig sessionConfig) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public AsyncSession asyncSession() {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public AsyncSession asyncSession(SessionConfig sessionConfig) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public void close() {
        if (this.sessionCounter.decrementAndGet() <= 0) {
            this.cache.removeFromCache(this.key);
            this.internal.close();
        }
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public Metrics metrics() {
        return this.internal.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.internal.isMetricsEnabled();
    }

    @Override
    public TypeSystem defaultTypeSystem() {
        return this.internal.defaultTypeSystem();
    }

    @Override
    public void verifyConnectivity() {
        this.internal.verifyConnectivity();
    }

    @Override
    public CompletionStage<Void> verifyConnectivityAsync() {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public boolean supportsMultiDb() {
        return this.internal.supportsMultiDb();
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDbAsync() {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }
}

