/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.jdbc.Neo4jDatabaseMetaData;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;
import org.neo4j.jdbc.bolt.BoltNeo4jDatabaseMetaData;
import org.neo4j.jdbc.bolt.BoltNeo4jPreparedStatement;
import org.neo4j.jdbc.bolt.BoltNeo4jStatement;
import org.neo4j.jdbc.impl.Neo4jConnectionImpl;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;
import org.neo4j.jdbc.utils.TimeLimitedCodeBlock;

public class BoltNeo4jConnectionImpl
extends Neo4jConnectionImpl
implements BoltNeo4jConnection {
    public static final String BOOKMARK_SEPARATOR = ",";
    public static final String BOOKMARK_VALUES_SEPARATOR = ";";
    private Driver driver;
    private Session session;
    private Transaction transaction;
    private boolean autoCommit = true;
    private BoltNeo4jDatabaseMetaData metadata;
    private boolean readOnly = Boolean.parseBoolean(this.getProperties().getProperty("readonly"));
    private static final Logger LOGGER = Logger.getLogger(BoltNeo4jConnectionImpl.class.getName());

    public BoltNeo4jConnectionImpl(Driver driver, Properties properties, String url) {
        super(properties, url, 2);
        this.driver = driver;
        this.initSession();
    }

    public static BoltNeo4jConnection newInstance(Driver driver, Properties info, String url) {
        BoltNeo4jConnectionImpl boltConnection = new BoltNeo4jConnectionImpl(driver, info, url);
        return (BoltNeo4jConnection)Proxy.newProxyInstance(BoltNeo4jConnectionImpl.class.getClassLoader(), new Class[]{Connection.class, BoltNeo4jConnection.class}, (InvocationHandler)new Neo4jInvocationHandler(boltConnection, BoltNeo4jConnectionImpl.hasDebug(info)));
    }

    @Override
    public Transaction getTransaction() {
        this.initTransaction();
        return this.transaction;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public Session newNeo4jSession() {
        try {
            String stringBookmark = this.getClientInfo("bookmark");
            Bookmark[] bookmarks = StringUtils.isNotBlank(stringBookmark) ? (Bookmark[])Stream.of(stringBookmark.split(BOOKMARK_SEPARATOR)).map(b -> InternalBookmark.parse(Stream.of(b.split(BOOKMARK_VALUES_SEPARATOR)).collect(Collectors.toSet()))).toArray(Bookmark[]::new) : null;
            SessionConfig.Builder config = SessionConfig.builder().withBookmarks(bookmarks).withDefaultAccessMode(this.readOnly || this.getReadOnly() ? AccessMode.READ : AccessMode.WRITE);
            String database = (String)this.getProperties().get("database");
            if (database != null && !database.trim().isEmpty()) {
                config.withDatabase(database.trim());
            }
            return this.driver.session(config.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Neo4jDatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new BoltNeo4jDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.transaction != null && this.transaction.isOpen()) {
            throw new SQLException("Method can't be called during a transaction");
        }
        super.doSetReadOnly(readOnly);
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
            this.initSession();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit != autoCommit) {
            this.checkClosed();
            this.doCommit();
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        this.checkAutoCommit();
        this.doCommit();
    }

    @Override
    public void doCommit() throws SQLException {
        if (this.transaction != null && this.transaction.isOpen()) {
            this.transaction.commit();
            this.transaction.close();
            this.transaction = null;
            this.setBookmark();
        }
    }

    private void setBookmark() throws SQLClientInfoException {
        InternalBookmark internalBookmark = (InternalBookmark)this.session.lastBookmark();
        if (internalBookmark != null && internalBookmark.values().iterator().hasNext()) {
            String bookmark = String.join((CharSequence)BOOKMARK_SEPARATOR, internalBookmark.values());
            this.setClientInfo("bookmark", bookmark);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        this.checkAutoCommit();
        this.doRollback();
    }

    @Override
    public void doRollback() {
        if (this.transaction != null && this.transaction.isOpen()) {
            this.transaction.rollback();
            this.transaction.close();
            this.transaction = null;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        this.checkTypeParams(resultSetType);
        this.checkConcurrencyParams(resultSetConcurrency);
        this.checkHoldabilityParams(resultSetHoldability);
        this.initTransaction();
        return BoltNeo4jStatement.newInstance(false, this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(this.nativeSQL(sql), 1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(this.nativeSQL(sql), resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        this.checkTypeParams(resultSetType);
        this.checkConcurrencyParams(resultSetConcurrency);
        this.checkHoldabilityParams(resultSetHoldability);
        this.initTransaction();
        return BoltNeo4jPreparedStatement.newInstance(false, this, this.nativeSQL(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.driver == null || this.session != null && !this.session.isOpen();
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.isClosed()) {
                if (this.transaction != null) {
                    this.transaction.close();
                    this.transaction = null;
                }
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                    this.driver.close();
                    this.driver = null;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("A database access error has occurred: " + e.getMessage());
        }
    }

    public void closeSession(Session session) {
        if (session != null) {
            session.close();
            this.driver.close();
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout can't be less than zero");
        }
        if (this.isClosed()) {
            return false;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Session s = BoltNeo4jConnectionImpl.this.getSession();
                Transaction tr = BoltNeo4jConnectionImpl.this.getTransaction();
                if (tr != null && tr.isOpen()) {
                    tr.run("RETURN 1");
                } else {
                    s.run("RETURN 1");
                }
            }
        };
        try {
            TimeLimitedCodeBlock.runWithTimeout(r, timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Catch exception totally fine", e);
            return false;
        }
        return true;
    }

    private void initSession() {
        this.session = this.newNeo4jSession();
    }

    private void initTransaction() {
        try {
            if (this.transaction == null) {
                this.transaction = this.session.beginTransaction();
            } else if (this.getAutoCommit()) {
                this.doCommit();
                this.transaction = this.session.beginTransaction();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

