/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http.driver;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.neo4j.jdbc.http.driver.Neo4jResponse;
import org.neo4j.jdbc.http.driver.Neo4jStatement;

public class CypherExecutor {
    final String transactionUrl;
    private Boolean secure;
    private Boolean autoCommit;
    private CloseableHttpClient http;
    private String currentTransactionUrl;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String DB_DATA_TRANSACTION = "/db/data/transaction";

    public CypherExecutor(String host, Integer port, Boolean secure, Properties properties) throws SQLException {
        this.secure = secure;
        HttpClientBuilder builder = HttpClients.custom();
        String userAgent = properties.getProperty("useragent");
        builder.setUserAgent(this.getUserAgent(userAgent));
        try {
            if (this.isAuthenticationRequired(host, port, secure, properties)) {
                CredentialsProvider credentialsProvider = this.getCredentialsProvider(host, port, properties);
                if (credentialsProvider == null) {
                    throw new SQLException("Authentication required");
                }
                builder.setDefaultCredentialsProvider(credentialsProvider);
                builder.addInterceptorFirst(new PreemptiveAuthInterceptor());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        this.http = builder.build();
        this.transactionUrl = this.createTransactionUrl(host, port, this.secure);
        this.setAutoCommit(Boolean.valueOf(properties.getProperty("autoCommit", "true")));
    }

    public String getUserAgent(String userAgent) {
        return "Neo4j JDBC Driver" + (userAgent != null ? " via " + userAgent : "");
    }

    public boolean isAuthenticationRequired(String host, Integer port, Boolean secure, Properties properties) throws Exception {
        HttpUriRequest request = RequestBuilder.head().setUri(new URL(secure != false ? "https" : "http", host, port, "/db/data/").toURI()).build();
        try (CloseableHttpClient minimalHttp = HttpClients.custom().disableAutomaticRetries().setUserAgent(this.getUserAgent(properties.getProperty("useragent"))).build();){
            CloseableHttpResponse response = minimalHttp.execute(request);
            boolean bl = response.getStatusLine().getStatusCode() == 401;
            return bl;
        }
    }

    private String createTransactionUrl(String host, Integer port, Boolean secure) throws SQLException {
        try {
            if (secure.booleanValue()) {
                return new URL("https", host, port, DB_DATA_TRANSACTION).toString();
            }
            return new URL("http", host, port, DB_DATA_TRANSACTION).toString();
        }
        catch (MalformedURLException e) {
            throw new SQLException("Invalid server URL", e);
        }
    }

    private CredentialsProvider getCredentialsProvider(String host, Integer port, Properties properties) {
        if (properties.containsKey("password")) {
            String user = properties.getProperty("user", properties.getProperty("username", "neo4j"));
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, properties.getProperty("password"));
            credsProvider.setCredentials(new AuthScope(host, port), credentials);
            return credsProvider;
        }
        return null;
    }

    public Neo4jResponse executeQueries(List<Neo4jStatement> queries) throws SQLException {
        HttpPost request = new HttpPost(this.currentTransactionUrl);
        StringEntity requestEntity = new StringEntity(Neo4jStatement.toJson(queries, mapper), ContentType.APPLICATION_JSON);
        request.setEntity(requestEntity);
        return this.executeHttpRequest(request);
    }

    public Neo4jResponse executeQuery(Neo4jStatement query) throws SQLException {
        ArrayList<Neo4jStatement> queries = new ArrayList<Neo4jStatement>();
        queries.add(query);
        return this.executeQueries(queries);
    }

    public void commit() throws SQLException {
        if (this.getOpenTransactionId() > 0) {
            HttpPost request = new HttpPost(this.currentTransactionUrl + "/commit");
            Neo4jResponse response = this.executeHttpRequest(request);
            if (response.hasErrors()) {
                throw new SQLException(response.displayErrors());
            }
            this.currentTransactionUrl = this.transactionUrl;
        }
    }

    public void rollback() throws SQLException {
        if (this.getOpenTransactionId() > 0) {
            HttpDelete request = new HttpDelete(this.currentTransactionUrl);
            Neo4jResponse response = this.executeHttpRequest(request);
            if (response.getCode() != 200 & response.hasErrors()) {
                throw new SQLException(response.displayErrors());
            }
            this.currentTransactionUrl = this.transactionUrl;
        }
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) throws SQLException {
        if (this.autoCommit != autoCommit) {
            if (autoCommit.booleanValue()) {
                if (this.getOpenTransactionId() > 0) {
                    this.commit();
                }
                this.autoCommit = Boolean.TRUE;
                this.currentTransactionUrl = this.transactionUrl + "/commit";
            } else {
                this.autoCommit = Boolean.FALSE;
                this.currentTransactionUrl = this.transactionUrl;
            }
        }
    }

    public String getServerVersion() {
        String result = null;
        HttpGet request = new HttpGet(this.transactionUrl.replace(DB_DATA_TRANSACTION, "/db/data"));
        for (Header header : this.getDefaultHeaders()) {
            request.addHeader(header.getName(), header.getValue());
        }
        try (CloseableHttpResponse response = this.http.execute(request);
             InputStream is = response.getEntity().getContent();){
            Map body = mapper.readValue(is, Map.class);
            String neo4j_version = (String)body.get("neo4j_version");
            if (neo4j_version != null) {
                result = neo4j_version;
            }
        }
        catch (Exception e) {
            result = "Unknown";
        }
        return result;
    }

    public void close() throws SQLException {
        try {
            this.http.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    Integer getTransactionId(String url) {
        Integer transactId = -1;
        if (url != null && url.contains(this.transactionUrl)) {
            String[] tab = url.split("/");
            String last = tab[tab.length - 1];
            try {
                transactId = Integer.valueOf(last);
            }
            catch (NumberFormatException e) {
                transactId = -1;
            }
        }
        return transactId;
    }

    public Integer getOpenTransactionId() {
        return this.getTransactionId(this.currentTransactionUrl);
    }

    private Header[] getDefaultHeaders() {
        Header[] headers = new Header[]{new BasicHeader("Accept", ContentType.APPLICATION_JSON.toString()), new BasicHeader("X-Stream", "true")};
        return headers;
    }

    private Neo4jResponse executeHttpRequest(HttpRequestBase request) throws SQLException {
        Neo4jResponse result;
        for (Header header : this.getDefaultHeaders()) {
            request.addHeader(header.getName(), header.getValue());
        }
        try (CloseableHttpResponse response = this.http.execute(request);){
            result = new Neo4jResponse(response, mapper);
            if (!this.getAutoCommit().booleanValue()) {
                if (result.hasErrors()) {
                    this.currentTransactionUrl = this.transactionUrl;
                } else if (result.getLocation() != null) {
                    Integer transactionId = this.getTransactionId(result.getLocation());
                    this.currentTransactionUrl = this.transactionUrl + "/" + transactionId;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return result;
    }

    static {
        mapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
    }

    private class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveAuthInterceptor() {
        }

        @Override
        public void process(HttpRequest request, HttpContext context) throws HttpException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.update(new BasicScheme(), creds);
            }
        }
    }
}

