/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http.driver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Neo4jStatement {
    public final String statement;
    public final Map<String, Object> parameters;
    public final Boolean includeStats;

    public Neo4jStatement(String statement, Map<String, Object> parameters, Boolean includeStats) throws SQLException {
        if (statement == null || "".equals(statement)) {
            throw new SQLException("Creating a NULL query");
        }
        this.statement = statement;
        this.parameters = parameters != null ? parameters : new HashMap<String, Object>();
        this.includeStats = includeStats != null ? includeStats : Boolean.FALSE;
    }

    public static String toJson(List<Neo4jStatement> queries, ObjectMapper mapper) throws SQLException {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("{\"statements\":");
            sb.append(mapper.writeValueAsString(queries));
            sb.append("}");
        }
        catch (JsonProcessingException e) {
            throw new SQLException("Can't convert Cypher statement(s) into JSON", e);
        }
        return sb.toString();
    }

    public String getStatement() {
        return this.statement;
    }
}

