/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;

final class ParameterNameGenerator {
    private static final IntBinaryOperator ACCUMULATOR = (o, n) -> {
        if (o == n) {
            return o + 1;
        }
        int diff = n - o;
        if (diff >= 1) {
            return n;
        }
        return o + 1;
    };
    private final AtomicInteger parameterIndex = new AtomicInteger(0);

    ParameterNameGenerator() {
    }

    String newIndex() {
        return Integer.toString(this.parameterIndex.incrementAndGet());
    }

    String newIndex(String name) {
        if (name == null) {
            return null;
        }
        try {
            int idx = Integer.parseInt(name) + 1;
            return Integer.toString(this.parameterIndex.accumulateAndGet(idx, ACCUMULATOR));
        }
        catch (NumberFormatException nf) {
            return name;
        }
    }
}

