/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.impl;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Asterisk;
import org.jooq.CreateTableElementListStep;
import org.jooq.DSLContext;
import org.jooq.False;
import org.jooq.Field;
import org.jooq.Null;
import org.jooq.Param;
import org.jooq.Parser;
import org.jooq.QualifiedAsterisk;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.True;
import org.jooq.conf.ParamType;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.conf.ParseWithMetaLookups;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.ParserException;
import org.jooq.impl.QOM;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.ExposesReturning;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Dialect;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.jdbc.translator.impl.ParameterNameGenerator;
import org.neo4j.jdbc.translator.impl.SqlToCypherConfig;
import org.neo4j.jdbc.translator.spi.Cache;
import org.neo4j.jdbc.translator.spi.Translator;

final class SqlToCypher
implements Translator {
    private static final Map<String, String> FUNCTION_MAPPING;
    static final Logger LOGGER;
    private static final int STATEMENT_CACHE_SIZE = 64;
    private final SqlToCypherConfig config;
    private final Configuration rendererConfig;
    private final Cache<Query, String> cache = Cache.getInstance((int)64);

    static Translator defaultTranslator() {
        return new SqlToCypher(SqlToCypherConfig.defaultConfig());
    }

    static Translator with(SqlToCypherConfig config) {
        return new SqlToCypher(config);
    }

    private SqlToCypher(SqlToCypherConfig config) {
        this.config = config;
        this.rendererConfig = Configuration.newConfig().withPrettyPrint(this.config.isPrettyPrint()).alwaysEscapeNames(this.config.isAlwaysEscapeNames()).withDialect(Dialect.NEO4J_5).build();
    }

    public void flushCache() {
        this.cache.flush();
    }

    public int getOrder() {
        return Optional.ofNullable(this.config.getPrecedence()).orElseGet(() -> super.getOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String translate(String sql, DatabaseMetaData optionalDatabaseMetaData) {
        Query query;
        try {
            DSLContext dsl = this.createDSLContext();
            Parser parser = dsl.parser();
            query = parser.parseQuery(sql);
        }
        catch (ParserException pe) {
            throw new IllegalArgumentException(pe);
        }
        if (this.config.isCacheEnabled()) {
            SqlToCypher sqlToCypher = this;
            synchronized (sqlToCypher) {
                return (String)this.cache.computeIfAbsent((Object)query, key -> this.translate0(query, optionalDatabaseMetaData));
            }
        }
        return this.translate0(query, optionalDatabaseMetaData);
    }

    private String translate0(Query query, DatabaseMetaData databaseMetaData) {
        return this.render(ContextAwareStatementBuilder.build(this.config, databaseMetaData, query));
    }

    private DSLContext createDSLContext() {
        Settings settings = new DefaultConfiguration().settings().withParseNameCase(this.config.getParseNameCase()).withRenderNameCase(this.config.getRenderNameCase()).withParseWithMetaLookups(ParseWithMetaLookups.IGNORE_ON_FAILURE).withDiagnosticsLogging(Boolean.valueOf(true)).withParseUnknownFunctions(ParseUnknownFunctions.IGNORE).withParseDialect(this.config.getSqlDialect());
        Optional.ofNullable(this.config.getParseNamedParamPrefix()).filter(Predicate.not(String::isBlank)).map(String::trim).ifPresent(arg_0 -> ((Settings)settings).withParseNamedParamPrefix(arg_0));
        DSLContext context = DSL.using((SQLDialect)this.config.getSqlDialect(), (Settings)settings);
        context.configuration().set(() -> {
            HashMap tables = new HashMap();
            this.config.getJoinColumnsToTypeMappings().forEach((k, v) -> {
                String[] tableAndColumnName = k.split("\\.");
                CreateTableElementListStep createTableStep = (CreateTableElementListStep)tables.computeIfAbsent(tableAndColumnName[0], DSL::createTable);
                createTableStep.column(DSL.field((String)tableAndColumnName[1]).comment("type=" + v));
            });
            this.config.getTableToLabelMappings().forEach((k, v) -> {
                CreateTableElementListStep createTableStep = (CreateTableElementListStep)tables.computeIfAbsent(k, DSL::createTable);
                createTableStep.comment("label=" + v);
            });
            return context.meta((Query[])tables.values().toArray(Query[]::new));
        });
        return context;
    }

    private String render(Statement statement) {
        return Renderer.getRenderer((Configuration)this.rendererConfig).render(statement);
    }

    static {
        Logger.getLogger("org.jooq.Constants").setLevel(Level.WARNING);
        Logger.getLogger("org.neo4j.jdbc.internal.shaded.jooq.Constants").setLevel(Level.WARNING);
        System.setProperty("org.jooq.no-logo", "true");
        System.setProperty("org.jooq.no-tips", "true");
        FUNCTION_MAPPING = Map.of("strpos", "apoc.text.indexOf");
        LOGGER = Logger.getLogger(SqlToCypher.class.getName());
    }

    static class ContextAwareStatementBuilder {
        private final Map<String, Expression> columnsAndValues = new LinkedHashMap<String, Expression>();
        private final Map<String, AtomicInteger> returnColumns = new HashMap<String, AtomicInteger>();
        private final SqlToCypherConfig config;
        private final DatabaseMetaData databaseMetaData;
        private final ParameterNameGenerator parameterNameGenerator = new ParameterNameGenerator();
        private final List<Table<?>> tables = new ArrayList();

        static Statement build(SqlToCypherConfig config, DatabaseMetaData databaseMetaData, Query query) {
            if (query instanceof Select) {
                Select s = (Select)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(s);
            }
            if (query instanceof QOM.Delete) {
                QOM.Delete d = (QOM.Delete)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(d);
            }
            if (query instanceof QOM.Truncate) {
                QOM.Truncate t = (QOM.Truncate)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(t);
            }
            if (query instanceof QOM.Insert) {
                QOM.Insert t = (QOM.Insert)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(t);
            }
            if (query instanceof QOM.InsertReturning) {
                QOM.InsertReturning t = (QOM.InsertReturning)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(t.$insert(), (List<? extends SelectFieldOrAsterisk>)t.$returning());
            }
            if (query instanceof QOM.Update) {
                QOM.Update u = (QOM.Update)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(u);
            }
            throw ContextAwareStatementBuilder.unsupported((QueryPart)query);
        }

        ContextAwareStatementBuilder(SqlToCypherConfig config, DatabaseMetaData databaseMetaData) {
            this.config = config;
            this.databaseMetaData = databaseMetaData;
        }

        private static IllegalArgumentException unsupported(QueryPart p) {
            String typeMsg = p != null ? " (Was of type " + p.getClass().getName() + ")" : "";
            return new IllegalArgumentException("Unsupported SQL expression: " + p + typeMsg);
        }

        private static Node nodeWithProperties(Node src, Map<String, Expression> properties) {
            return (Node)src.withProperties(properties.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).toArray());
        }

        private static SymbolicName symbolicName(String value) {
            return Cypher.name((String)value.toLowerCase(Locale.ROOT));
        }

        private static String relationshipTypeName(Field<?> lhsJoinColumn) {
            return Objects.requireNonNull(lhsJoinColumn.getQualifiedName().last()).toUpperCase(Locale.ROOT);
        }

        private Statement statement(QOM.Delete<?> d) {
            this.tables.clear();
            this.tables.add(d.$from());
            Node e = (Node)this.resolveTableOrJoin(this.tables.get(0));
            StatementBuilder.OngoingReadingWithoutWhere m1 = Cypher.match((PatternElement[])new PatternElement[]{e});
            StatementBuilder.OngoingReadingWithWhere m2 = d.$where() != null ? (StatementBuilder.OngoingReadingWithWhere)m1.where(this.condition(d.$where())) : (StatementBuilder.OngoingReadingWithWhere)m1;
            return m2.delete(new Expression[]{e.asExpression()}).build();
        }

        private Statement statement(QOM.Truncate<?> t) {
            this.tables.clear();
            this.tables.addAll((Collection<Table<?>>)t.$table());
            Node e = (Node)this.resolveTableOrJoin(this.tables.get(0));
            return Cypher.match((PatternElement[])new PatternElement[]{e}).detachDelete(new Expression[]{e.asExpression()}).build();
        }

        private ResultStatement statement(Select<?> incoming) {
            StatementBuilder.OngoingMatchAndReturnWithOrder buildableStatement;
            Select x;
            QOM.TableAlias tableAlias;
            boolean addLimit = false;
            QueryPart queryPart = incoming.$from().$first();
            if (queryPart instanceof QOM.TableAlias && (queryPart = (tableAlias = (QOM.TableAlias)queryPart).$table()) instanceof QOM.DerivedTable) {
                QOM.DerivedTable d = (QOM.DerivedTable)queryPart;
                addLimit = incoming.$where() != null;
                x = (Select)d.$arg1();
            } else {
                x = incoming;
            }
            this.tables.clear();
            this.tables.addAll(ContextAwareStatementBuilder.unnestFromClause(x.$from()));
            Supplier<List> resultColumnsSupplier = () -> x.$select().stream().flatMap(this::expression).toList();
            if (x.$from().isEmpty()) {
                return (ResultStatement)Cypher.returning((Collection)resultColumnsSupplier.get()).build();
            }
            StatementBuilder.OngoingReadingWithoutWhere m1 = Cypher.match(x.$from().stream().map(this::resolveTableOrJoin).toList());
            StatementBuilder.OngoingReadingWithWhere m2 = x.$where() != null ? (StatementBuilder.OngoingReadingWithWhere)m1.where(this.condition(x.$where())) : (StatementBuilder.OngoingReadingWithWhere)m1;
            StatementBuilder.OngoingReadingAndReturn intermediate = x.$distinct() ? m2.returningDistinct((Collection)resultColumnsSupplier.get()) : m2.returning((Collection)resultColumnsSupplier.get());
            StatementBuilder.OngoingMatchAndReturnWithOrder returning = intermediate.orderBy(x.$orderBy().stream().map(this::expression).toList());
            Field field = x.$limit();
            if (!(field instanceof Param)) {
                buildableStatement = addLimit ? returning.limit((Number)1) : returning;
            } else {
                Param param = (Param)field;
                buildableStatement = returning.limit(this.expression((Field<?>)param));
            }
            return (ResultStatement)buildableStatement.build();
        }

        private Statement statement(QOM.Insert<?> insert) {
            return this.statement(insert, List.of());
        }

        private Statement statement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning) {
            boolean useMerge;
            this.tables.clear();
            this.tables.add(insert.$into());
            Node node = (Node)this.resolveTableOrJoin(this.tables.get(0));
            QOM.UnmodifiableList rows = insert.$values();
            boolean hasMergeProperties = !insert.$onConflict().isEmpty();
            boolean bl = useMerge = insert.$onDuplicateKeyIgnore() || hasMergeProperties;
            if (rows.size() == 1) {
                return this.buildSingleCreateStatement(insert, returning, node, useMerge, hasMergeProperties);
            }
            return this.buildUnwindCreateStatement(insert, returning, node, useMerge, hasMergeProperties);
        }

        private Statement buildSingleCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Node node, boolean useMerge, boolean hasMergeProperties) {
            Row row = Objects.requireNonNull((Row)insert.$values().$first());
            QOM.UnmodifiableList columns = insert.$columns();
            LinkedHashMap<String, Expression> nodeProperties = new LinkedHashMap<String, Expression>();
            for (int i = 0; i < columns.size(); ++i) {
                nodeProperties.put(((Field)columns.get(i)).getName(), this.expression(row.field(i)));
            }
            if (useMerge) {
                LinkedHashMap<String, Expression> mergeProperties = hasMergeProperties ? new LinkedHashMap<String, Expression>() : nodeProperties;
                insert.$onConflict().forEach(c -> {
                    mergeProperties.put(c.getName(), (Expression)nodeProperties.get(c.getName()));
                    nodeProperties.remove(c.getName());
                });
                ArrayList properties = new ArrayList();
                nodeProperties.forEach((k, v) -> properties.add(Cypher.set((Expression)node.property(k), (Expression)v)));
                StatementBuilder.OngoingMerge merge = Cypher.merge((PatternElement[])new PatternElement[]{ContextAwareStatementBuilder.nodeWithProperties(node, mergeProperties)});
                if (hasMergeProperties) {
                    merge = ((StatementBuilder.ExposesMergeAction)merge).onCreate().set(properties);
                }
                if (!insert.$updateSet().isEmpty()) {
                    ArrayList updates = new ArrayList();
                    insert.$updateSet().forEach((c, v) -> {
                        ContextAwareStatementBuilder contextAwareStatementBuilder = this;
                        synchronized (contextAwareStatementBuilder) {
                            try {
                                this.columnsAndValues.putAll(nodeProperties);
                                updates.add(Cypher.set((Expression)node.property(((Field)c).getName()), (Expression)this.expression((Field)v)));
                            }
                            finally {
                                nodeProperties.keySet().forEach(this.columnsAndValues::remove);
                            }
                        }
                    });
                    merge = ((StatementBuilder.ExposesMergeAction)merge).onMatch().set(updates);
                }
                return this.addOptionalReturnAndBuild((ExposesReturning)merge, returning);
            }
            return this.addOptionalReturnAndBuild(Cypher.create((PatternElement[])new PatternElement[]{ContextAwareStatementBuilder.nodeWithProperties(node, nodeProperties)}), returning);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Statement buildUnwindCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Node node, boolean useMerge, boolean hasMergeProperties) {
            if (useMerge && !hasMergeProperties) {
                throw new UnsupportedOperationException("MERGE is not supported when inserting multiple rows without using a property to merge on");
            }
            QOM.UnmodifiableList columns = insert.$columns();
            ListExpression props = Cypher.listOf(insert.$values().stream().map(row -> {
                HashMap<String, Expression> result = new HashMap<String, Expression>(columns.size());
                for (int i = 0; i < columns.size(); ++i) {
                    result.put(((Field)columns.get(i)).getName(), this.expression(row.field(i)));
                }
                return Cypher.literalOf(result);
            }).toList());
            if (useMerge) {
                SymbolicName symName = Cypher.name((String)"properties");
                LinkedHashMap<String, Expression> mergeProperties = new LinkedHashMap<String, Expression>();
                insert.$onConflict().forEach(c -> mergeProperties.put(c.getName(), (Expression)Cypher.property((Expression)symName, (Expression)Cypher.literalOf((Object)c.getName()))));
                ArrayList properties = new ArrayList();
                columns.stream().filter(c -> !mergeProperties.containsKey(c.getName())).forEach(c -> properties.add(Cypher.set((Expression)node.property(c.getName()), (Expression)Cypher.property((Expression)symName, (String[])new String[]{c.getName()}))));
                ArrayList updates = new ArrayList();
                ContextAwareStatementBuilder contextAwareStatementBuilder = this;
                synchronized (contextAwareStatementBuilder) {
                    try {
                        columns.forEach(c -> this.columnsAndValues.put(c.getName(), (Expression)Cypher.property((Expression)symName, (Expression)Cypher.literalOf((Object)c.getName()))));
                        insert.$updateSet().forEach((c, v) -> updates.add(Cypher.set((Expression)node.property(((Field)c).getName()), (Expression)this.expression((Field)v))));
                    }
                    finally {
                        columns.forEach(c -> this.columnsAndValues.remove(c.getName()));
                    }
                }
                return this.addOptionalReturnAndBuild(Cypher.unwind((Expression)props).as("properties").merge(new PatternElement[]{ContextAwareStatementBuilder.nodeWithProperties(node, mergeProperties)}).onCreate().set(properties).onMatch().set(updates), returning);
            }
            return this.addOptionalReturnAndBuild(Cypher.unwind((Expression)props).as("properties").create(new PatternElement[]{node}).set((Named)node, (Expression)Cypher.name((String)"properties")), returning);
        }

        private <T extends ExposesReturning & StatementBuilder.BuildableStatement<?>> Statement addOptionalReturnAndBuild(T exposesReturning, List<? extends SelectFieldOrAsterisk> returning) {
            if (returning == null || returning.isEmpty()) {
                return ((StatementBuilder.BuildableStatement<?>)exposesReturning).build();
            }
            return exposesReturning.returning(returning.stream().flatMap(this::expression).toList()).build();
        }

        private String uniqueColumnName(String s) {
            int cnt = this.returnColumns.computeIfAbsent(s, k -> new AtomicInteger(0)).getAndAccumulate(1, Integer::sum);
            return s + (Serializable)(cnt > 0 ? Integer.valueOf(cnt) : "");
        }

        private Statement statement(QOM.Update<?> update) {
            this.tables.clear();
            this.tables.add(update.$table());
            Node node = (Node)this.resolveTableOrJoin(this.tables.get(0));
            ArrayList updates = new ArrayList();
            update.$set().forEach((c, v) -> {
                updates.add(node.property(((Field)c).getName()));
                updates.add(this.expression((Field)v));
            });
            Object exposesSet = update.$where() != null ? (StatementBuilder.ExposesSet)Cypher.match((PatternElement[])new PatternElement[]{node}).where(this.condition(update.$where())) : Cypher.match((PatternElement[])new PatternElement[]{node});
            return exposesSet.set(updates).build();
        }

        private Stream<Expression> expression(SelectFieldOrAsterisk t) {
            QualifiedAsterisk q;
            Object properties2;
            if (t instanceof SelectField) {
                TableField tf;
                SelectField selectField;
                SelectField s = (SelectField)t;
                if (s instanceof QOM.FieldAlias) {
                    QOM.FieldAlias fa = (QOM.FieldAlias)s;
                    selectField = fa.$aliased();
                } else {
                    selectField = s;
                }
                SelectField theField = selectField;
                Expression col = theField instanceof TableField && (tf = (TableField)theField).getTable() == null ? this.findTableFieldInTables(tf) : this.expression(s);
                if (s instanceof QOM.FieldAlias) {
                    QOM.FieldAlias fa = (QOM.FieldAlias)s;
                    col = col.as(fa.$alias().last());
                }
                return Stream.of(col);
            }
            if (t instanceof Asterisk) {
                Asterisk a = (Asterisk)t;
                List<Expression> properties2 = this.projectAllColumns();
                if (properties2.isEmpty()) {
                    properties2.add((Expression)Cypher.asterisk());
                }
                return properties2.stream();
            }
            if (t instanceof QualifiedAsterisk && (properties2 = this.resolveTableOrJoin((q = (QualifiedAsterisk)t).$table())) instanceof Node) {
                Node node = (Node)properties2;
                properties2 = new ArrayList();
                for (Table<?> table : this.tables) {
                    QOM.TableAlias tableAlias;
                    if (!(table instanceof QOM.TableAlias) || !(tableAlias = (QOM.TableAlias)table).getName().equals(q.$table().getName())) continue;
                    ((ArrayList)properties2).addAll(this.projectAllColumns(List.of(tableAlias)));
                    break;
                }
                if (((ArrayList)properties2).isEmpty()) {
                    SymbolicName symbolicName = node.getSymbolicName().orElseGet(() -> Cypher.name((String)q.$table().getName()));
                    ((ArrayList)properties2).add(symbolicName.project(new Object[]{Cypher.asterisk()}).as(symbolicName));
                }
                return properties2.stream();
            }
            throw ContextAwareStatementBuilder.unsupported((QueryPart)t);
        }

        private List<Expression> projectAllColumns() {
            return this.projectAllColumns(this.tables);
        }

        private List<Expression> projectAllColumns(List<Table<?>> from) {
            ArrayList<Expression> properties = new ArrayList<Expression>();
            if (this.databaseMetaData == null) {
                return properties;
            }
            for (Table<?> table : from) {
                PropertyContainer pc = (PropertyContainer)this.resolveTableOrJoin(table);
                String tableName = this.labelOrType(table);
                try {
                    ResultSet columns = this.databaseMetaData.getColumns(null, null, tableName, null);
                    try {
                        properties.add((Expression)((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)"elementId").withArgs(new Expression[]{pc.asExpression()})).asFunction().as(this.uniqueColumnName("element_id")));
                        while (columns.next()) {
                            String columnName = columns.getString("COLUMN_NAME");
                            properties.add((Expression)pc.property(columnName).as(this.uniqueColumnName(columnName)));
                        }
                    }
                    finally {
                        if (columns == null) continue;
                        columns.close();
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return properties;
        }

        private static List<? extends Table<?>> unnestFromClause(List<? extends Table<?>> tables) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Table<?> table : tables) {
                if (table instanceof QOM.JoinTable) {
                    QOM.JoinTable join = (QOM.JoinTable)table;
                    result.addAll(ContextAwareStatementBuilder.unnestFromClause(List.of(join.$table1())));
                    result.addAll(ContextAwareStatementBuilder.unnestFromClause(List.of(join.$table2())));
                    continue;
                }
                result.add(table);
            }
            return result;
        }

        private Expression expression(SelectField<?> s) {
            if (s instanceof QOM.FieldAlias) {
                QOM.FieldAlias fa = (QOM.FieldAlias)s;
                return this.expression(fa.$aliased()).as(fa.$alias().last());
            }
            if (s instanceof Field) {
                Field f = (Field)s;
                return this.expression(f);
            }
            throw ContextAwareStatementBuilder.unsupported(s);
        }

        private SortItem expression(SortField<?> s) {
            Expression col;
            String direction;
            block3: {
                direction = s.$sortOrder().name().toUpperCase(Locale.ROOT);
                Field theField = s.$field();
                col = null;
                try {
                    col = this.expression(theField);
                }
                catch (IllegalArgumentException ex) {
                    TableField tf;
                    if (theField instanceof TableField && (tf = (TableField)theField).getTable() == null) {
                        col = this.findTableFieldInTables(tf);
                    }
                    if (!(s instanceof QOM.FieldAlias)) break block3;
                    QOM.FieldAlias fa = (QOM.FieldAlias)s;
                    if (col == null) break block3;
                    col = col.as(fa.$alias().last());
                }
            }
            return Cypher.sort((Expression)col, (SortItem.Direction)("DEFAULT".equals(direction) ? SortItem.Direction.UNDEFINED : SortItem.Direction.valueOf((String)direction)));
        }

        private Expression findTableFieldInTables(TableField<?, ?> tf) {
            return this.findTableFieldInTables(tf, true);
        }

        private Expression findTableFieldInTables(TableField<?, ?> tf, boolean fallbackToFieldName) {
            SymbolicName col = null;
            if (this.tables.size() == 1) {
                PropertyContainer propertyContainer = (PropertyContainer)this.resolveTableOrJoin(this.tables.get(0));
                col = propertyContainer.getSymbolicName().filter(f -> !f.getValue().equals(tf.getName())).map(__ -> propertyContainer.property(tf.getName())).orElse(null);
            } else if (this.databaseMetaData != null) {
                for (Table<?> table : this.tables) {
                    String tableName = this.labelOrType(table);
                    try {
                        ResultSet columns = this.databaseMetaData.getColumns(null, null, tableName, null);
                        try {
                            while (columns.next()) {
                                String columnName = columns.getString("COLUMN_NAME");
                                if (!columnName.equals(tf.getName())) continue;
                                PropertyContainer pc = (PropertyContainer)this.resolveTableOrJoin(table);
                                col = pc.property(tf.getName());
                            }
                        }
                        finally {
                            if (columns == null) continue;
                            columns.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            if (col == null && fallbackToFieldName) {
                col = Cypher.name((String)tf.getName());
            }
            return col;
        }

        private Expression expression(Field<?> f) {
            return this.expression(f, false);
        }

        private Expression expression(Field<?> f, boolean turnUnknownIntoNames) {
            QOM.Excluded excluded;
            if (f instanceof Param) {
                Param p = (Param)f;
                if (p.$inline()) {
                    return Cypher.literalOf((Object)p.getValue());
                }
                String parameterName = p.getParamType() == ParamType.INDEXED || p.getParamType() == ParamType.FORCE_INDEXED ? this.parameterNameGenerator.newIndex() : this.parameterNameGenerator.newIndex(p.getParamName());
                return parameterName != null ? Cypher.parameter((String)parameterName, (Object)p.getValue()) : Cypher.anonParameter((Object)p.getValue());
            }
            if (f instanceof TableField) {
                Expression tableField;
                TableField tf = (TableField)f;
                if (tf.getTable() != null) {
                    PatternElement pe = this.resolveTableOrJoin(tf.getTable());
                    if (pe instanceof Node) {
                        Node node = (Node)pe;
                        return node.property(tf.getName());
                    }
                    if (pe instanceof Relationship) {
                        Relationship rel = (Relationship)pe;
                        return rel.property(tf.getName());
                    }
                }
                if ((tableField = this.findTableFieldInTables(tf, turnUnknownIntoNames)) == null) {
                    throw ContextAwareStatementBuilder.unsupported((QueryPart)tf);
                }
                return tableField;
            }
            if (f instanceof QOM.Add) {
                QOM.Add e = (QOM.Add)f;
                return this.expression((Field)e.$arg1()).add(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Sub) {
                QOM.Sub e = (QOM.Sub)f;
                return this.expression((Field)e.$arg1()).subtract(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Mul) {
                QOM.Mul e = (QOM.Mul)f;
                return this.expression((Field)e.$arg1()).multiply(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Square) {
                QOM.Square e = (QOM.Square)f;
                return this.expression((Field)e.$arg1()).multiply(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Div) {
                QOM.Div e = (QOM.Div)f;
                return this.expression((Field)e.$arg1()).divide(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Neg) {
                QOM.Neg e = (QOM.Neg)f;
                throw ContextAwareStatementBuilder.unsupported((QueryPart)e);
            }
            if (f instanceof QOM.Abs) {
                QOM.Abs e = (QOM.Abs)f;
                return Cypher.abs((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ceil) {
                QOM.Ceil e = (QOM.Ceil)f;
                return Cypher.ceil((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Floor) {
                QOM.Floor e = (QOM.Floor)f;
                return Cypher.floor((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Round) {
                QOM.Round e = (QOM.Round)f;
                if (e.$arg2() == null) {
                    return Cypher.round((Expression)this.expression((Field)e.$arg1()), (Expression[])new Expression[0]);
                }
                return Cypher.round((Expression)this.expression((Field)e.$arg1()), (Expression[])new Expression[]{this.expression((Field)e.$arg2())});
            }
            if (f instanceof QOM.Sign) {
                QOM.Sign e = (QOM.Sign)f;
                return Cypher.sign((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Rand) {
                return Cypher.rand();
            }
            if (f instanceof QOM.Euler) {
                return Cypher.e();
            }
            if (f instanceof QOM.Exp) {
                QOM.Exp e = (QOM.Exp)f;
                return Cypher.exp((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ln) {
                QOM.Ln e = (QOM.Ln)f;
                return Cypher.log((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Log) {
                QOM.Log e = (QOM.Log)f;
                return Cypher.log((Expression)this.expression((Field)e.$arg1())).divide((Expression)Cypher.log((Expression)this.expression((Field)e.$arg2())));
            }
            if (f instanceof QOM.Log10) {
                QOM.Log10 e = (QOM.Log10)f;
                return Cypher.log10((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Sqrt) {
                QOM.Sqrt e = (QOM.Sqrt)f;
                return Cypher.sqrt((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Acos) {
                QOM.Acos e = (QOM.Acos)f;
                return Cypher.acos((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Asin) {
                QOM.Asin e = (QOM.Asin)f;
                return Cypher.asin((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Atan) {
                QOM.Atan e = (QOM.Atan)f;
                return Cypher.atan((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Atan2) {
                QOM.Atan2 e = (QOM.Atan2)f;
                return Cypher.atan2((Expression)this.expression((Field)e.$arg1()), (Expression)this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Cos) {
                QOM.Cos e = (QOM.Cos)f;
                return Cypher.cos((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Cot) {
                QOM.Cot e = (QOM.Cot)f;
                return Cypher.cot((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Degrees) {
                QOM.Degrees e = (QOM.Degrees)f;
                return Cypher.degrees((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Pi) {
                return Cypher.pi();
            }
            if (f instanceof QOM.Radians) {
                QOM.Radians e = (QOM.Radians)f;
                return Cypher.radians((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Sin) {
                QOM.Sin e = (QOM.Sin)f;
                return Cypher.sin((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Tan) {
                QOM.Tan e = (QOM.Tan)f;
                return Cypher.tan((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.CharLength) {
                QOM.CharLength e = (QOM.CharLength)f;
                return Cypher.size((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Left) {
                QOM.Left e = (QOM.Left)f;
                return Cypher.left((Expression)this.expression((Field)e.$arg1()), (Expression)this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Lower) {
                QOM.Lower e = (QOM.Lower)f;
                return Cypher.toLower((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ltrim) {
                QOM.Ltrim e = (QOM.Ltrim)f;
                return Cypher.ltrim((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Replace) {
                QOM.Replace e = (QOM.Replace)f;
                return Cypher.replace((Expression)this.expression((Field)e.$arg1()), (Expression)this.expression((Field)e.$arg2()), (Expression)this.expression((Field)e.$arg3()));
            }
            if (f instanceof QOM.Reverse) {
                QOM.Reverse e = (QOM.Reverse)f;
                return Cypher.reverse((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Right) {
                QOM.Right e = (QOM.Right)f;
                return Cypher.right((Expression)this.expression((Field)e.$arg1()), (Expression)this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Rtrim) {
                QOM.Rtrim e = (QOM.Rtrim)f;
                return Cypher.rtrim((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Substring) {
                QOM.Substring e = (QOM.Substring)f;
                Expression length = this.expression((Field)e.$arg3());
                if (length != Cypher.literalNull()) {
                    return Cypher.substring((Expression)this.expression((Field)e.$arg1()), (Expression)this.expression((Field)e.$arg2()), (Expression)length);
                }
                return Cypher.substring((Expression)this.expression((Field)e.$arg1()), (Expression)this.expression((Field)e.$arg2()), null);
            }
            if (f instanceof QOM.Trim) {
                QOM.Trim e = (QOM.Trim)f;
                if (e.$arg2() != null) {
                    throw ContextAwareStatementBuilder.unsupported((QueryPart)e);
                }
                return Cypher.trim((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Upper) {
                QOM.Upper e = (QOM.Upper)f;
                return Cypher.toUpper((Expression)this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Coalesce) {
                QOM.Coalesce e = (QOM.Coalesce)f;
                return Cypher.coalesce((Expression[])((Expression[])((QOM.UnmodifiableList)e.$arg1()).stream().map(this::expression).toArray(Expression[]::new)));
            }
            if (f instanceof QOM.Nvl) {
                QOM.Nvl e = (QOM.Nvl)f;
                return Cypher.coalesce((Expression[])new Expression[]{this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2())});
            }
            if (f instanceof QOM.Nullif) {
                QOM.Nullif e = (QOM.Nullif)f;
                return Cypher.caseExpression().when((Expression)this.expression((Field)e.$arg1()).eq(this.expression((Field)e.$arg2()))).then((Expression)Cypher.literalNull()).elseDefault(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Nvl2) {
                QOM.Nvl2 e = (QOM.Nvl2)f;
                return Cypher.caseExpression().when((Expression)this.expression((Field)e.$arg1()).isNotNull()).then(this.expression((Field)e.$arg2())).elseDefault(this.expression((Field)e.$arg3()));
            }
            if (f instanceof QOM.CaseSimple) {
                QOM.CaseSimple e = (QOM.CaseSimple)f;
                Case c = Cypher.caseExpression((Expression)this.expression(e.$value()));
                for (QOM.Tuple2 w : e.$when()) {
                    c = c.when(this.expression((Field)w.$1())).then(this.expression((Field)w.$2()));
                }
                if (e.$else() != null) {
                    c = ((Case.CaseEnding)c).elseDefault(this.expression(e.$else()));
                }
                return c;
            }
            if (f instanceof QOM.CaseSearched) {
                QOM.CaseSearched e = (QOM.CaseSearched)f;
                Case c = Cypher.caseExpression();
                for (QOM.Tuple2 w : e.$when()) {
                    c = c.when((Expression)this.condition((org.jooq.Condition)w.$1())).then(this.expression((Field)w.$2()));
                }
                if (e.$else() != null) {
                    c = ((Case.CaseEnding)c).elseDefault(this.expression(e.$else()));
                }
                return c;
            }
            if (f instanceof QOM.Cast) {
                QOM.Cast e = (QOM.Cast)f;
                if (e.$dataType().isString()) {
                    return Cypher.toString((Expression)this.expression(e.$field()));
                }
                if (e.$dataType().isBoolean()) {
                    return Cypher.toBoolean((Expression)this.expression(e.$field()));
                }
                if (e.$dataType().isFloat()) {
                    return Cypher.toFloat((Expression)this.expression(e.$field()));
                }
                if (e.$dataType().isInteger()) {
                    return Cypher.toInteger((Expression)this.expression(e.$field()));
                }
                throw ContextAwareStatementBuilder.unsupported(f);
            }
            if (f instanceof True) {
                return Cypher.literalTrue();
            }
            if (f instanceof False) {
                return Cypher.literalFalse();
            }
            if (f instanceof QOM.Null || f == null || f instanceof Null) {
                return Cypher.literalNull();
            }
            if (f instanceof QOM.Function) {
                QOM.Function func = (QOM.Function)f;
                return this.buildFunction(func);
            }
            if (f instanceof QOM.Excluded && this.columnsAndValues.containsKey((excluded = (QOM.Excluded)f).$field().getName())) {
                return this.columnsAndValues.get(excluded.$field().getName());
            }
            if (f instanceof QOM.Count) {
                QOM.Count c = (QOM.Count)f;
                Field field = c.$field();
                Object exp = field instanceof Asterisk || "*".equals(field.toString()) ? Cypher.asterisk() : this.expression(field);
                return c.$distinct() ? Cypher.countDistinct((Expression)exp) : Cypher.count((Expression)exp);
            }
            if (f instanceof Asterisk) {
                return Cypher.asterisk();
            }
            if (f instanceof QOM.Min) {
                QOM.Min m = (QOM.Min)f;
                return Cypher.min((Expression)this.expression(m.$field()));
            }
            if (f instanceof QOM.Max) {
                QOM.Max m = (QOM.Max)f;
                return Cypher.max((Expression)this.expression(m.$field()));
            }
            if (f instanceof QOM.Position) {
                QOM.Position p = (QOM.Position)f;
                return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)FUNCTION_MAPPING.get("strpos")).withArgs(new Expression[]{this.expression(p.$in()), this.expression((Field)p.$arg2())})).asFunction();
            }
            throw ContextAwareStatementBuilder.unsupported(f);
        }

        private Expression buildFunction(QOM.Function<?> func) {
            Function<Field, Expression> asExpression = v -> this.expression((Field<?>)v, true);
            Expression[] args = (Expression[])func.$args().stream().map(asExpression).toArray(Expression[]::new);
            return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)FUNCTION_MAPPING.getOrDefault(func.getName().toLowerCase(Locale.ROOT), func.getName())).withArgs(args)).asFunction();
        }

        private <T> Condition condition(org.jooq.Condition c) {
            QOM.FieldCondition fc;
            Field field;
            if (c instanceof QOM.And) {
                QOM.And a = (QOM.And)c;
                return this.condition((org.jooq.Condition)a.$arg1()).and(this.condition((org.jooq.Condition)a.$arg2()));
            }
            if (c instanceof QOM.Or) {
                QOM.Or o = (QOM.Or)c;
                return this.condition((org.jooq.Condition)o.$arg1()).or(this.condition((org.jooq.Condition)o.$arg2()));
            }
            if (c instanceof QOM.Xor) {
                QOM.Xor o = (QOM.Xor)c;
                return this.condition((org.jooq.Condition)o.$arg1()).xor(this.condition((org.jooq.Condition)o.$arg2()));
            }
            if (c instanceof QOM.Not) {
                QOM.Not o = (QOM.Not)c;
                return this.condition((org.jooq.Condition)o.$arg1()).not();
            }
            if (c instanceof QOM.Eq) {
                QOM.Eq e = (QOM.Eq)c;
                return this.expression((Field)e.$arg1()).eq(this.expression((Field)e.$arg2()));
            }
            if (c instanceof QOM.Gt) {
                QOM.Gt e = (QOM.Gt)c;
                return this.expression((Field)e.$arg1()).gt(this.expression((Field)e.$arg2()));
            }
            if (c instanceof QOM.Ge) {
                QOM.Ge e = (QOM.Ge)c;
                return this.expression((Field)e.$arg1()).gte(this.expression((Field)e.$arg2()));
            }
            if (c instanceof QOM.Lt) {
                QOM.Lt e = (QOM.Lt)c;
                return this.expression((Field)e.$arg1()).lt(this.expression((Field)e.$arg2()));
            }
            if (c instanceof QOM.Le) {
                QOM.Le e = (QOM.Le)c;
                return this.expression((Field)e.$arg1()).lte(this.expression((Field)e.$arg2()));
            }
            if (c instanceof QOM.Between) {
                QOM.Between e = (QOM.Between)c;
                if (e.$symmetric()) {
                    QOM.Between t = e;
                    return this.condition((org.jooq.Condition)t.$symmetric(false)).or(this.condition((org.jooq.Condition)((QOM.Between)t.$symmetric(false).$arg2((Object)((Field)t.$arg3()))).$arg3((Object)((Field)t.$arg2()))));
                }
                return this.expression((Field)e.$arg2()).lte(this.expression((Field)e.$arg1())).and(this.expression((Field)e.$arg1()).lte(this.expression((Field)e.$arg3())));
            }
            if (c instanceof QOM.Ne) {
                QOM.Ne e = (QOM.Ne)c;
                return this.expression((Field)e.$arg1()).ne(this.expression((Field)e.$arg2()));
            }
            if (c instanceof QOM.IsNull) {
                QOM.IsNull e = (QOM.IsNull)c;
                return this.expression((Field)e.$arg1()).isNull();
            }
            if (c instanceof QOM.IsNotNull) {
                QOM.IsNotNull e = (QOM.IsNotNull)c;
                return this.expression((Field)e.$arg1()).isNotNull();
            }
            if (c instanceof QOM.RowEq) {
                QOM.RowEq e = (QOM.RowEq)c;
                Condition result = null;
                for (int i = 0; i < ((Row)e.$arg1()).size(); ++i) {
                    Condition r = this.expression(((Row)e.$arg1()).field(i)).eq(this.expression(((Row)e.$arg2()).field(i)));
                    result = result != null ? result.and(r) : r;
                }
                return result;
            }
            if (c instanceof QOM.RowNe) {
                QOM.RowNe e = (QOM.RowNe)c;
                Condition result = null;
                for (int i = 0; i < ((Row)e.$arg1()).size(); ++i) {
                    Condition r = this.expression(((Row)e.$arg1()).field(i)).ne(this.expression(((Row)e.$arg2()).field(i)));
                    result = result != null ? result.and(r) : r;
                }
                return result;
            }
            if (c instanceof QOM.RowGt) {
                QOM.RowGt e = (QOM.RowGt)c;
                return this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::gt, Expression::gt);
            }
            if (c instanceof QOM.RowGe) {
                QOM.RowGe e = (QOM.RowGe)c;
                return this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::gt, Expression::gte);
            }
            if (c instanceof QOM.RowLt) {
                QOM.RowLt e = (QOM.RowLt)c;
                return this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::lt, Expression::lt);
            }
            if (c instanceof QOM.RowLe) {
                QOM.RowLe e = (QOM.RowLe)c;
                return this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::lt, Expression::lte);
            }
            if (c instanceof QOM.RowIsNull) {
                QOM.RowIsNull e = (QOM.RowIsNull)c;
                return ((Row)e.$arg1()).$fields().stream().map(f -> this.expression((Field<?>)f).isNull()).reduce(Condition::and).orElseThrow();
            }
            if (c instanceof QOM.RowIsNotNull) {
                QOM.RowIsNotNull e = (QOM.RowIsNotNull)c;
                return ((Row)e.$arg1()).$fields().stream().map(f -> this.expression((Field<?>)f).isNotNull()).reduce(Condition::and).orElseThrow();
            }
            if (c instanceof QOM.Like) {
                Expression rhs;
                Param p;
                QOM.Like like = (QOM.Like)c;
                Object object = like.$arg2();
                if (object instanceof Param && (p = (Param)object).$inline() && (object = p.getValue()) instanceof String) {
                    String s = (String)object;
                    rhs = Cypher.literalOf((Object)s.replace("%", ".*"));
                } else {
                    rhs = this.expression((Field)like.$arg2());
                }
                return this.expression((Field)like.$arg1()).matches(rhs);
            }
            if (c instanceof QOM.FieldCondition && (field = (fc = (QOM.FieldCondition)c).$field()) instanceof Param) {
                Param param = (Param)field;
                return (Boolean.TRUE.equals(param.getValue()) ? Cypher.literalTrue() : Cypher.literalFalse()).asCondition();
            }
            if (c instanceof QOM.InList) {
                QOM.InList il = (QOM.InList)c;
                return this.expression(il.$field()).in((Expression)Cypher.listOf(il.$list().stream().map(this::expression).toList()));
            }
            throw ContextAwareStatementBuilder.unsupported((QueryPart)c);
        }

        private Condition rowCondition(Row r1, Row r2, BiFunction<? super Expression, ? super Expression, ? extends Condition> comp, BiFunction<? super Expression, ? super Expression, ? extends Condition> last) {
            Condition result = last.apply((Expression)this.expression(r1.field(r1.size() - 1)), (Expression)this.expression(r2.field(r1.size() - 1)));
            for (int i = r1.size() - 2; i >= 0; --i) {
                Expression e1 = this.expression(r1.field(i));
                Expression e2 = this.expression(r2.field(i));
                result = comp.apply((Expression)e1, (Expression)e2).or(e1.eq(e2).and(result));
            }
            return result;
        }

        private PatternElement resolveTableOrJoin(Table<?> t) {
            if (t instanceof QOM.JoinTable) {
                String relType;
                PatternElement lhs;
                QOM.Eq $eq;
                org.jooq.Condition condition;
                QOM.Join $join;
                QOM.JoinTable joinTable = (QOM.JoinTable)t;
                QOM.Join join = joinTable instanceof QOM.Join ? ($join = (QOM.Join)joinTable) : null;
                QOM.Eq eq = join != null && (condition = join.$on()) instanceof QOM.Eq ? ($eq = (QOM.Eq)condition) : null;
                SymbolicName relSymbolicName = null;
                Table t1 = joinTable.$table1();
                if (t1 instanceof QOM.JoinTable) {
                    QOM.JoinTable lhsJoin = (QOM.JoinTable)t1;
                    lhs = this.resolveTableOrJoin(lhsJoin.$table1());
                    relType = this.labelOrType(lhsJoin.$table2());
                    Table table = lhsJoin.$table2();
                    if (table instanceof QOM.TableAlias) {
                        QOM.TableAlias tableAlias = (QOM.TableAlias)table;
                        relSymbolicName = ContextAwareStatementBuilder.symbolicName(tableAlias.getName());
                    }
                } else if (eq != null) {
                    lhs = this.resolveTableOrJoin(t1);
                    relType = this.type(t1, (Field)eq.$arg2());
                } else {
                    if (join != null && join.$using().isEmpty()) {
                        throw ContextAwareStatementBuilder.unsupported((QueryPart)joinTable);
                    }
                    lhs = this.resolveTableOrJoin(t1);
                    String string = relType = join != null ? this.type(t1, (Field)join.$using().get(0)) : null;
                }
                if (relSymbolicName == null && relType != null) {
                    relSymbolicName = ContextAwareStatementBuilder.symbolicName(relType);
                }
                PatternElement rhs = this.resolveTableOrJoin(joinTable.$table2());
                if (lhs instanceof ExposesRelationships) {
                    ExposesRelationships from = (ExposesRelationships)lhs;
                    if (rhs instanceof Node) {
                        QOM.TableAlias ta;
                        Table table;
                        Node to = (Node)rhs;
                        Relationship.Direction direction = Relationship.Direction.LTR;
                        if (eq != null && (table = joinTable.$table2()) instanceof QOM.TableAlias && !(ta = (QOM.TableAlias)table).$alias().empty() && Objects.equals(ta.$alias().last(), ((Field)eq.$arg2()).getQualifiedName().first())) {
                            direction = Relationship.Direction.RTL;
                        }
                        RelationshipPattern relationship = from.relationshipWith(to, direction, new String[]{relType});
                        if (relSymbolicName != null) {
                            if (relationship instanceof Relationship) {
                                Relationship r = (Relationship)relationship;
                                relationship = r.named(relSymbolicName);
                            } else if (relationship instanceof RelationshipChain) {
                                RelationshipChain r = (RelationshipChain)relationship;
                                relationship = r.named(relSymbolicName);
                            }
                        }
                        return relationship;
                    }
                }
                throw ContextAwareStatementBuilder.unsupported((QueryPart)joinTable);
            }
            if (t instanceof QOM.TableAlias) {
                QOM.TableAlias ta = (QOM.TableAlias)t;
                if (this.resolveTableOrJoin(ta.$aliased()) instanceof Node && !ta.$alias().empty()) {
                    return Cypher.node((String)this.labelOrType(ta.$aliased()), (String[])new String[0]).named(ContextAwareStatementBuilder.symbolicName(Objects.requireNonNull(ta.$alias().last())));
                }
                throw ContextAwareStatementBuilder.unsupported((QueryPart)ta);
            }
            return Cypher.node((String)this.labelOrType(t), (String[])new String[0]).named(ContextAwareStatementBuilder.symbolicName(t.getName()));
        }

        private String labelOrType(Table<?> tableOrAlias) {
            Table table;
            if (tableOrAlias instanceof QOM.TableAlias) {
                QOM.TableAlias ta = (QOM.TableAlias)tableOrAlias;
                table = ta.$aliased();
            } else {
                table = tableOrAlias;
            }
            Table t = table;
            String comment = t.getComment();
            if (!comment.isBlank()) {
                Map<String, String> config = Arrays.stream(comment.split(",")).map(s -> s.split("=")).collect(Collectors.toMap(a -> a[0], a -> a[1]));
                return config.getOrDefault("label", t.getName());
            }
            return this.config.getTableToLabelMappings().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(t.getName())).findFirst().map(Map.Entry::getValue).orElseGet(() -> ((Table)t).getName());
        }

        private String type(Table<?> tableOrAlias, Field<?> field) {
            Table table;
            if (tableOrAlias instanceof QOM.TableAlias) {
                QOM.TableAlias ta = (QOM.TableAlias)tableOrAlias;
                table = ta.$aliased();
            } else {
                table = tableOrAlias;
            }
            Table t = table;
            String key = t.getName() + "." + field.getName();
            return this.config.getJoinColumnsToTypeMappings().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).findFirst().map(Map.Entry::getValue).orElseGet(() -> ContextAwareStatementBuilder.relationshipTypeName(field));
        }
    }
}

