/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooq.SQLDialect;
import org.jooq.conf.ParseNameCase;
import org.jooq.conf.RenderNameCase;
import org.neo4j.jdbc.translator.impl.SqlToCypher;

public final class SqlToCypherConfig {
    public static final String PROPERTY_ALWAYS_ESCAPE_NAMES = "s2c.alwaysEscapeNames";
    public static final String PROPERTY_PRETTY_PRINT_CYPHER = "s2c.prettyPrint";
    public static final String PROPERTY_ENABLE_CACHE = "s2c.enableCache";
    private static final SqlToCypherConfig DEFAULT_CONFIG = SqlToCypherConfig.builder().build();
    private static Map<String, String> DRIVER_CONFIG_TO_TRANSLATOR_CONFIG_MAPPING = Map.of("cacheSQLTranslations", "s2c.enableCache");
    private final ParseNameCase parseNameCase;
    private final RenderNameCase renderNameCase;
    private final boolean jooqDiagnosticLogging;
    private final Map<String, String> tableToLabelMappings;
    private final Map<String, String> joinColumnsToTypeMappings;
    private final SQLDialect sqlDialect;
    private final boolean prettyPrint;
    private final boolean alwaysEscapeNames;
    private final String parseNamedParamPrefix;
    private final boolean cacheEnabled;
    private final Integer precedence;

    public static SqlToCypherConfig of(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return SqlToCypherConfig.defaultConfig();
        }
        HashMap localConfig = new HashMap();
        config.forEach((k, v) -> localConfig.put(DRIVER_CONFIG_TO_TRANSLATOR_CONFIG_MAPPING.getOrDefault(k, (String)k), v));
        Pattern prefix = Pattern.compile("s2c\\.(.+)");
        List<Matcher> relevantProperties = localConfig.keySet().stream().map(prefix::matcher).filter(Matcher::matches).toList();
        if (relevantProperties.isEmpty()) {
            return SqlToCypherConfig.defaultConfig();
        }
        Builder builder = SqlToCypherConfig.builder();
        Pattern dashWord = Pattern.compile("-(\\w)");
        boolean customConfig = false;
        for (Matcher m : relevantProperties) {
            String k2;
            Object v2 = localConfig.get(m.group());
            customConfig = null != (switch (k2 = dashWord.matcher(m.group(1)).replaceAll(mr -> mr.group(1).toUpperCase(Locale.ROOT))) {
                case "parseNameCase" -> builder.withParseNameCase(SqlToCypherConfig.toEnum(ParseNameCase.class, v2));
                case "renderNameCase" -> builder.withRenderNameCase(SqlToCypherConfig.toEnum(RenderNameCase.class, v2));
                case "jooqDiagnosticLogging" -> builder.withJooqDiagnosticLogging(SqlToCypherConfig.toBoolean(v2));
                case "tableToLabelMappings" -> builder.withTableToLabelMappings(SqlToCypherConfig.toMap(v2));
                case "joinColumnsToTypeMappings" -> builder.withJoinColumnsToTypeMappings(SqlToCypherConfig.toMap(v2));
                case "sqlDialect" -> builder.withSqlDialect(SQLDialect.valueOf((String)SqlToCypherConfig.toString(v2)));
                case "prettyPrint" -> builder.withPrettyPrint(SqlToCypherConfig.toBoolean(v2));
                case "alwaysEscapeNames" -> builder.withAlwaysEscapeNames(SqlToCypherConfig.toBoolean(v2));
                case "parseNamedParamPrefix" -> builder.withParseNamedParamPrefix(SqlToCypherConfig.toString(v2));
                case "enableCache" -> builder.withCacheEnabled(SqlToCypherConfig.toBoolean(v2));
                case "precedence" -> builder.withPrecedence(SqlToCypherConfig.toInteger(v2));
                default -> {
                    SqlToCypher.LOGGER.log(Level.WARNING, "Unknown config option {0}", m.group());
                    yield null;
                }
            });
        }
        return customConfig ? builder.build() : SqlToCypherConfig.defaultConfig();
    }

    static Map<String, String> toMap(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map;
        }
        if (value instanceof String) {
            String source = (String)value;
            return SqlToCypherConfig.buildMap(source);
        }
        if (value == null) {
            throw new IllegalArgumentException("Unsupported Map<String, String> representation representation null");
        }
        throw new IllegalArgumentException("Unsupported Map<String, String> representation " + value.getClass());
    }

    static <T extends Enum<T>> T toEnum(Class<T> enumType, Object value) {
        if (enumType.isInstance(value)) {
            return (T)((Enum)enumType.cast(value));
        }
        if (value instanceof String) {
            String s = (String)value;
            return Enum.valueOf(enumType, s);
        }
        if (value == null) {
            throw new IllegalArgumentException("Unsupported enum representation null");
        }
        throw new IllegalArgumentException("Unsupported enum representation " + value.getClass() + " for " + enumType.getName());
    }

    static String toString(Object val) {
        if (val instanceof String) {
            String s = (String)val;
            return s;
        }
        return val != null ? val.toString() : "";
    }

    static boolean toBoolean(Object val) {
        if (val instanceof String) {
            String s = (String)val;
            return Boolean.parseBoolean(s);
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return b;
        }
        if (val == null) {
            throw new IllegalArgumentException("Unsupported boolean representation null");
        }
        throw new IllegalArgumentException("Unsupported boolean representation " + val.getClass());
    }

    static Integer toInteger(Object val) {
        if (val instanceof Integer) {
            Integer integer = (Integer)val;
            return integer;
        }
        if (val instanceof String) {
            String s = (String)val;
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Unsupported Integer representation `%s`".formatted(s), ex);
            }
        }
        if (val == null) {
            throw new IllegalArgumentException("Unsupported Integer representation null");
        }
        throw new IllegalArgumentException("Unsupported Integer representation " + val.getClass());
    }

    static Map<String, String> buildMap(String source) {
        return Arrays.stream(source.split(";")).map(String::trim).map(s -> s.split(":")).collect(Collectors.toUnmodifiableMap(a -> a[0], a -> a[1]));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SqlToCypherConfig defaultConfig() {
        return DEFAULT_CONFIG;
    }

    private SqlToCypherConfig(Builder builder) {
        this.parseNameCase = builder.parseNameCase;
        this.renderNameCase = builder.renderNameCase;
        this.jooqDiagnosticLogging = builder.jooqDiagnosticLogging;
        this.tableToLabelMappings = builder.tableToLabelMappings;
        this.joinColumnsToTypeMappings = builder.joinColumnsToTypeMappings;
        this.sqlDialect = builder.sqlDialect;
        this.prettyPrint = builder.prettyPrint;
        this.alwaysEscapeNames = builder.alwaysEscapeNames;
        this.parseNamedParamPrefix = builder.parseNamedParamPrefix;
        this.cacheEnabled = builder.enableCache;
        this.precedence = builder.precedence;
    }

    public Builder modify() {
        return new Builder(this);
    }

    public ParseNameCase getParseNameCase() {
        return this.parseNameCase;
    }

    public RenderNameCase getRenderNameCase() {
        return this.renderNameCase;
    }

    public boolean isJooqDiagnosticLogging() {
        return this.jooqDiagnosticLogging;
    }

    public Map<String, String> getTableToLabelMappings() {
        return this.tableToLabelMappings;
    }

    public Map<String, String> getJoinColumnsToTypeMappings() {
        return this.joinColumnsToTypeMappings;
    }

    public SQLDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public boolean isAlwaysEscapeNames() {
        return this.alwaysEscapeNames;
    }

    public String getParseNamedParamPrefix() {
        return this.parseNamedParamPrefix;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public Integer getPrecedence() {
        return this.precedence;
    }

    public static final class Builder {
        private ParseNameCase parseNameCase;
        private RenderNameCase renderNameCase;
        private boolean jooqDiagnosticLogging;
        private Map<String, String> tableToLabelMappings;
        private Map<String, String> joinColumnsToTypeMappings;
        private SQLDialect sqlDialect;
        private boolean prettyPrint;
        private String parseNamedParamPrefix;
        private boolean alwaysEscapeNames;
        private boolean enableCache;
        private Integer precedence;

        private Builder() {
            this(ParseNameCase.AS_IS, RenderNameCase.AS_IS, false, Map.of(), Map.of(), SQLDialect.DEFAULT, false, false, null, false, Integer.MAX_VALUE);
        }

        private Builder(SqlToCypherConfig config) {
            this(config.parseNameCase, config.renderNameCase, config.jooqDiagnosticLogging, config.tableToLabelMappings, config.joinColumnsToTypeMappings, config.sqlDialect, config.prettyPrint, config.alwaysEscapeNames, config.parseNamedParamPrefix, config.cacheEnabled, config.precedence);
        }

        private Builder(ParseNameCase parseNameCase, RenderNameCase renderNameCase, boolean jooqDiagnosticLogging, Map<String, String> tableToLabelMappings, Map<String, String> joinColumnsToTypeMappings, SQLDialect sqlDialect, boolean prettyPrint, boolean alwaysEscapeNames, String parseNamedParamPrefix, boolean enableCache, Integer precedence) {
            this.parseNameCase = parseNameCase;
            this.renderNameCase = renderNameCase;
            this.jooqDiagnosticLogging = jooqDiagnosticLogging;
            this.tableToLabelMappings = tableToLabelMappings;
            this.joinColumnsToTypeMappings = joinColumnsToTypeMappings;
            this.sqlDialect = sqlDialect;
            this.prettyPrint = prettyPrint;
            this.alwaysEscapeNames = alwaysEscapeNames;
            this.parseNamedParamPrefix = parseNamedParamPrefix;
            this.enableCache = enableCache;
            this.precedence = precedence;
        }

        public Builder withParseNameCase(ParseNameCase newParseNameCase) {
            this.parseNameCase = Objects.requireNonNull(newParseNameCase);
            return this;
        }

        public Builder withRenderNameCase(RenderNameCase newRenderNameCase) {
            this.renderNameCase = Objects.requireNonNull(newRenderNameCase);
            return this;
        }

        public Builder withJooqDiagnosticLogging(boolean enabled) {
            this.jooqDiagnosticLogging = enabled;
            return this;
        }

        public Builder withTableToLabelMappings(Map<String, String> newTableToLabelMappings) {
            this.tableToLabelMappings = Map.copyOf(Objects.requireNonNull(newTableToLabelMappings));
            return this;
        }

        public Builder withJoinColumnsToTypeMappings(Map<String, String> newJoinColumnsToTypeMappings) {
            this.joinColumnsToTypeMappings = Map.copyOf(Objects.requireNonNull(newJoinColumnsToTypeMappings));
            return this;
        }

        public Builder withSqlDialect(SQLDialect newSqlDialect) {
            this.sqlDialect = Objects.requireNonNull(newSqlDialect);
            return this;
        }

        public Builder withPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder withParseNamedParamPrefix(String parseNamedParamPrefix) {
            this.parseNamedParamPrefix = parseNamedParamPrefix;
            return this;
        }

        public Builder withAlwaysEscapeNames(boolean alwaysEscapeNames) {
            this.alwaysEscapeNames = alwaysEscapeNames;
            return this;
        }

        public Builder withCacheEnabled(boolean cacheSetting) {
            this.enableCache = cacheSetting;
            return this;
        }

        public SqlToCypherConfig build() {
            return new SqlToCypherConfig(this);
        }

        public Builder withPrecedence(Integer newPrecedence) {
            this.precedence = newPrecedence;
            return this;
        }
    }
}

