/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.jdbc.translator.spi.View;

final class ViewDefinitionReader {
    private static final Set<String> SUPPORTED_SCHEMES = Collections.unmodifiableSet(new TreeSet<String>(Set.of("file", "http", "https", "resource")));
    private final URI source;

    static ViewDefinitionReader of(String url) {
        URI uri;
        try {
            uri = URI.create(url);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported url: %s".formatted(url), ex);
        }
        String scheme = Optional.ofNullable(uri.getScheme()).map(s -> s.toLowerCase(Locale.ROOT)).orElse("n/a");
        if (!SUPPORTED_SCHEMES.contains(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme: %s, supported schemes are %s".formatted(scheme, SUPPORTED_SCHEMES));
        }
        if ("file".equals(scheme) && uri.getPath() == null || uri.getPath().isBlank()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = url;
            objectArray[1] = Optional.ofNullable(uri.getHost()).orElseGet(uri::getSchemeSpecificPart);
            objectArray[2] = uri.getHost() == null && uri.getSchemeSpecificPart() != null ? "a schema specific part" : "the host in";
            throw new IllegalArgumentException("No path specified in this url: %s (%s is %s in that format, not the path; you probably meant file:///%2$s)".formatted(objectArray));
        }
        return new ViewDefinitionReader(uri);
    }

    private ViewDefinitionReader(URI source) {
        this.source = source;
    }

    List<View> read() throws IOException {
        JsonParser parser = JSON.std.createParser((Object)this.source.toURL()).enable(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION);
        parser.nextToken();
        if (parser.isExpectedStartObjectToken()) {
            Map raw = JSON.std.mapFrom((Object)parser);
            if (raw.containsKey("Schemas")) {
                return this.readSchemas((List)raw.get("Schemas"));
            }
            if (raw.isEmpty()) {
                return List.of();
            }
            throw new IllegalArgumentException("Invalid JSON content, cannot read %s: %s".formatted(this.source, parser.currentLocation()));
        }
        if (parser.isExpectedStartArrayToken()) {
            try {
                return List.of((View[])JSON.std.arrayOfFrom(View.class, (Object)parser));
            }
            catch (JSONObjectException ex) {
                throw new IllegalArgumentException("Invalid JSON content, cannot read %s".formatted(this.source), ex);
            }
        }
        if (!parser.hasCurrentToken()) {
            return List.of();
        }
        throw new IOException("Invalid JSON content in %s".formatted(this.source));
    }

    List<View> readSchemas(List<Map<String, Object>> schemas) {
        ArrayList<View> result = new ArrayList<View>();
        for (Map<String, Object> schema : schemas) {
            List views = (List)Objects.requireNonNullElseGet(schema.get("Views"), List::of);
            for (Map view : views) {
                String name = (String)view.get("Name");
                String query = (String)view.get("CypherQuery");
                List<View.Column> columns = ((List)Objects.requireNonNullElseGet(view.get("Columns"), List::of)).stream().map(column -> {
                    List types;
                    String columnName = (String)column.get("Name");
                    String sourceName = (String)column.get("SourceName");
                    String type = "String";
                    Object patt4645$temp = column.get("Neo4jType");
                    if (patt4645$temp instanceof List && (types = (List)patt4645$temp).size() == 1) {
                        type = (String)types.get(0);
                    }
                    return View.column((String)columnName, (String)sourceName, (String)type);
                }).toList();
                result.add(new View(name, query, columns));
            }
        }
        return result;
    }
}

