/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.concurrent.TimeUnit;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.values.storable.Values;

public abstract class NodeIndexTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldPerformStringSuffixSearch() throws Exception {
        LongHashSet expected = new LongHashSet();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "1suff"));
            this.nodeWithProp(tx, "pluff");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "2suff"));
            this.nodeWithProp(tx, "skruff");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor();){
                tx.dataRead().nodeIndexSeek(index, nodes, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringSuffix((int)prop, (String)"suff")});
                LongHashSet found = new LongHashSet();
                while (nodes.next()) {
                    found.add(nodes.nodeReference());
                }
                Assert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)expected));
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformStringContainsSearch() throws Exception {
        LongHashSet expected = new LongHashSet();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "gnomebat"));
            this.nodeWithProp(tx, "fishwombat");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "homeopatic"));
            this.nodeWithProp(tx, "telephonecompany");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor();){
                tx.dataRead().nodeIndexSeek(index, nodes, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringContains((int)prop, (String)"me")});
                LongHashSet found = new LongHashSet();
                while (nodes.next()) {
                    found.add(nodes.nodeReference());
                }
                Assert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)expected));
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowIfTransactionTerminated() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            this.terminate(tx);
            this.exception.expect(TransactionTerminatedException.class);
            tx.dataRead().nodeExists(42L);
        }
    }

    protected abstract void terminate(Transaction var1);

    private long nodeWithProp(Transaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName("Node"));
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), Values.of((Object)value));
        return node;
    }

    private void createIndex() {
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop").create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var2_2 = null;
        try {
            graphDb.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

