/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.Test;
import org.neo4j.internal.kernel.api.IndexReadAsserts;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;

public abstract class NodeLabelIndexCursorTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private int labelOne = 1;
    private int labelTwo = 2;
    private int labelThree = 3;
    private int labelFirst = 4;

    @Test
    public void shouldFindNodesByLabel() throws Exception {
        long toDelete;
        try (Transaction tx = this.beginTransaction();){
            this.createNode(tx.dataWrite(), this.labelOne, this.labelFirst);
            this.createNode(tx.dataWrite(), this.labelTwo, this.labelFirst);
            this.createNode(tx.dataWrite(), this.labelThree, this.labelFirst);
            toDelete = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            this.createNode(tx.dataWrite(), this.labelThree);
            this.createNode(tx.dataWrite(), this.labelThree);
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try {
            tx.dataWrite().nodeDelete(toDelete);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try {
            Read read = tx.dataRead();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(this.labelOne, cursor);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 1, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(this.labelTwo, cursor);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 2, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(this.labelThree, cursor);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
                uniqueIds.clear();
                read.nodeLabelScan(this.labelFirst, cursor);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
            }
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldFindNodesByLabelInTx() throws Exception {
        long deletedInTx;
        long inStore;
        try (Transaction tx = this.beginTransaction();){
            inStore = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            deletedInTx = this.createNode(tx.dataWrite(), this.labelOne);
            tx.success();
        }
        tx = this.beginTransaction();
        var8_2 = null;
        try {
            tx.dataWrite().nodeDelete(deletedInTx);
            long createdInTx = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            Read read = tx.dataRead();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(this.labelOne, cursor);
                IndexReadAsserts.assertNodes((NodeIndexCursor)cursor, (MutableLongSet)uniqueIds, inStore, createdInTx);
            }
        }
        catch (Throwable throwable) {
            var8_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private long createNode(Write write, int ... labels) throws KernelException {
        long nodeId = write.nodeCreate();
        for (int label : labels) {
            write.nodeAddLabel(nodeId, label);
        }
        return nodeId;
    }
}

