/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class NodeTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    public void shouldSeeNodeInTransaction() throws Exception {
        long nodeId;
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                Assert.assertEquals((long)nodeId, (long)node.nodeReference());
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        var4_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertEquals((long)nodeId, (long)graphDb.getNodeById(nodeId).getId());
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeNewLabeledNodeInTransaction() throws Exception {
        long nodeId;
        String labelName = "Town";
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.token().labelGetOrCreateForName("Town");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                LabelSet labels = node.labels();
                Assert.assertEquals((long)1L, (long)labels.numberOfLabels());
                Assert.assertEquals((long)labelId, (long)labels.label(0));
                Assert.assertTrue((boolean)node.hasLabel(labelId));
                Assert.assertFalse((boolean)node.hasLabel(labelId + 1));
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        var6_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getLabels(), (Matcher)Matchers.equalTo((Object)Iterables.iterable((Object[])new Label[]{Label.label((String)"Town")})));
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeLabelChangesInTransaction() throws Exception {
        int toDelete;
        int toRetain;
        long nodeId;
        String toRetainName = "ToRetain";
        String toDeleteName = "ToDelete";
        String toAddName = "ToAdd";
        String toRegretName = "ToRegret";
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            toRetain = tx.token().labelGetOrCreateForName("ToRetain");
            toDelete = tx.token().labelGetOrCreateForName("ToDelete");
            tx.dataWrite().nodeAddLabel(nodeId, toRetain);
            tx.dataWrite().nodeAddLabel(nodeId, toDelete);
            tx.success();
        }
        var12_6 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)"ToRetain"), Label.label((String)"ToDelete")}));
        }
        catch (Throwable throwable) {
            var12_6 = throwable;
            throw throwable;
        }
        tx = this.beginTransaction();
        var12_6 = null;
        try {
            int toAdd = tx.token().labelGetOrCreateForName("ToAdd");
            tx.dataWrite().nodeAddLabel(nodeId, toAdd);
            tx.dataWrite().nodeRemoveLabel(nodeId, toDelete);
            int toRegret = tx.token().labelGetOrCreateForName("ToRegret");
            tx.dataWrite().nodeAddLabel(nodeId, toRegret);
            tx.dataWrite().nodeRemoveLabel(nodeId, toRegret);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                this.assertLabels(node.labels(), toRetain, toAdd);
                Assert.assertTrue((boolean)node.hasLabel(toAdd));
                Assert.assertTrue((boolean)node.hasLabel(toRetain));
                Assert.assertFalse((boolean)node.hasLabel(toDelete));
                Assert.assertFalse((boolean)node.hasLabel(toRegret));
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var12_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var12_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var12_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var12_6 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)"ToRetain"), Label.label((String)"ToAdd")}));
        }
        catch (Throwable throwable) {
            var12_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldDiscoverDeletedNodeInTransaction() throws Exception {
        long nodeId;
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try {
            Assert.assertTrue((boolean)tx.dataWrite().nodeDelete(nodeId));
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertFalse((boolean)node.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldHandleMultipleNodeDeletions() throws Exception {
        long nodeId;
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try {
            Assert.assertTrue((boolean)tx.dataWrite().nodeDelete(nodeId));
            Assert.assertFalse((boolean)tx.dataWrite().nodeDelete(nodeId));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeNewNodePropertyInTransaction() throws Exception {
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (Transaction tx = this.beginTransaction();){
            long nodeId = tx.dataWrite().nodeCreate();
            int prop1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            int prop2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, prop1, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, prop2, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)prop1, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)prop2, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assert.assertFalse((String)"should only find two properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
    }

    @Test
    public void shouldSeeAddedPropertyFromExistingNodeWithoutPropertiesInTransaction() throws Exception {
        long nodeId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var5_3 = null;
        try {
            int propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                Assert.assertFalse((String)"should only find one properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"hello"));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeAddedPropertyFromExistingNodeWithPropertiesInTransaction() throws Exception {
        int propToken1;
        long nodeId;
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken1, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var8_4 = null;
        try {
            int propToken2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken2, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken2, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken1, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                Assert.assertFalse((String)"should only find two properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var8_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var8_4 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getProperty(propKey1), (Matcher)Matchers.equalTo((Object)"hello"));
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getProperty(propKey2), (Matcher)Matchers.equalTo((Object)"world"));
        }
        catch (Throwable throwable) {
            var8_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeUpdatedPropertyFromExistingNodeWithPropertiesInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var6_3 = null;
        try {
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"world")), (Object)Values.stringValue((String)"hello"));
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assert.assertFalse((String)"should only find one property", (boolean)property.next());
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"world"));
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeRemovedPropertyInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var6_3 = null;
        try {
            Assert.assertEquals((Object)tx.dataWrite().nodeRemoveProperty(nodeId, propToken), (Object)Values.stringValue((String)"hello"));
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.properties(property);
                Assert.assertFalse((String)"should not find any properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            Assert.assertFalse((boolean)graphDb.getNodeById(nodeId).hasProperty(propKey));
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeRemovedThenAddedPropertyInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var6_3 = null;
        try {
            Assert.assertEquals((Object)tx.dataWrite().nodeRemoveProperty(nodeId, propToken), (Object)Values.stringValue((String)"hello"));
            Assert.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assert.assertFalse((String)"should not find any properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one node", (boolean)node.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"world"));
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeExistingNode() throws Exception {
        long node;
        try (Transaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try {
            Assert.assertTrue((boolean)tx.dataRead().nodeExists(node));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeNonExistingNode() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            Assert.assertFalse((boolean)tx.dataRead().nodeExists(1337L));
        }
    }

    @Test
    public void shouldSeeNodeExistingInTxOnly() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            Assert.assertTrue((boolean)tx.dataRead().nodeExists(node));
        }
    }

    @Test
    public void shouldNotSeeDeletedNode() throws Exception {
        long node;
        try (Transaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try {
            tx.dataWrite().nodeDelete(node);
            Assert.assertFalse((boolean)tx.dataRead().nodeExists(node));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotFindDeletedNodeInLabelScan() throws Exception {
        Node node = this.createNode("label");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeDelete(node.node);
            tx.dataRead().nodeLabelScan(node.labels[0], cursor);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    public void shouldNotFindNodeWithRemovedLabelInLabelScan() throws Exception {
        Node node = this.createNode("label");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(node.node, node.labels[0]);
            tx.dataRead().nodeLabelScan(node.labels[0], cursor);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    public void shouldFindUpdatedNodeInInLabelScan() throws Exception {
        Node node = this.createNode(new String[0]);
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            int label = tx.tokenWrite().labelGetOrCreateForName("label");
            tx.dataWrite().nodeAddLabel(node.node, label);
            tx.dataRead().nodeLabelScan(label, cursor);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)node.node, (long)cursor.nodeReference());
        }
    }

    @Test
    public void shouldFindSwappedNodeInLabelScan() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(node1.node, node1.labels[0]);
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            tx.dataRead().nodeLabelScan(node1.labels[0], cursor);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)node2.node, (long)cursor.nodeReference());
        }
    }

    @Ignore
    public void shouldNotFindDeletedNodeInDisjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1", "label2");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeDelete(node.node);
            tx.dataRead().nodeLabelUnionScan(cursor, node.labels);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Ignore
    public void shouldFindNodeWithOneRemovedLabelInDisjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1", "label2");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(node.node, node.labels[1]);
            tx.dataRead().nodeLabelUnionScan(cursor, node.labels);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)node.node, (long)cursor.nodeReference());
        }
    }

    @Ignore
    public void shouldNotFindNodeWithAllRemovedLabelsInDisjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1", "label2");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(node.node, node.labels[0]);
            tx.dataWrite().nodeRemoveLabel(node.node, node.labels[1]);
            tx.dataRead().nodeLabelUnionScan(cursor, node.labels);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Ignore
    public void shouldNotFindNodeWithOneRemovedLabelsInDisjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            int label1 = tx.tokenWrite().labelGetOrCreateForName("label1");
            int label2 = tx.tokenWrite().labelGetOrCreateForName("label2");
            tx.dataWrite().nodeRemoveLabel(node.node, label1);
            tx.dataRead().nodeLabelUnionScan(cursor, new int[]{label1, label2});
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Ignore
    public void shouldFindUpdatedNodeInInDisjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            int label2 = tx.tokenWrite().labelGetOrCreateForName("label2");
            tx.dataWrite().nodeAddLabel(node.node, label2);
            tx.dataRead().nodeLabelUnionScan(cursor, new int[]{node.labels[0], label2});
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)node.node, (long)cursor.nodeReference());
        }
    }

    @Ignore
    public void shouldNotFindDeletedNodeInConjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1", "label2");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeDelete(node.node);
            tx.dataRead().nodeLabelIntersectionScan(cursor, node.labels);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Ignore
    public void shouldNotFindNodeWithRemovedLabelInConjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1", "label2");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(node.node, node.labels[1]);
            tx.dataRead().nodeLabelIntersectionScan(cursor, node.labels);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Ignore
    public void shouldFindUpdatedNodeInInConjunctionLabelScan() throws Exception {
        Node node = this.createNode("label1");
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            int label2 = tx.tokenWrite().labelGetOrCreateForName("label2");
            tx.dataWrite().nodeAddLabel(node.node, label2);
            tx.dataRead().nodeLabelIntersectionScan(cursor, new int[]{node.labels[0], label2});
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)node.node, (long)cursor.nodeReference());
        }
    }

    @Ignore
    public void shouldNotFindNodeWithJustOneUpdatedLabelInInConjunctionLabelScan() throws Exception {
        Node node = this.createNode(new String[0]);
        try (Transaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            int label1 = tx.tokenWrite().labelGetOrCreateForName("labe1");
            int label2 = tx.tokenWrite().labelGetOrCreateForName("label2");
            tx.dataWrite().nodeAddLabel(node.node, label2);
            tx.dataRead().nodeLabelIntersectionScan(cursor, new int[]{label1, label2});
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    public void shouldCountNewLabelsFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        try (Transaction tx = this.beginTransaction();){
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assert.assertEquals((long)2L, (long)countTxState);
            Assert.assertEquals((long)1L, (long)countNoTxState);
        }
    }

    @Test
    public void shouldCountNewNodesFromTxState() throws Exception {
        this.createNode(new String[0]);
        this.createNode(new String[0]);
        try (Transaction tx = this.beginTransaction();){
            tx.dataWrite().nodeCreate();
            long countTxState = tx.dataRead().countsForNode(-1);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(-1);
            Assert.assertEquals((long)3L, (long)countTxState);
            Assert.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    public void shouldNotCountRemovedLabelsFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        try (Transaction tx = this.beginTransaction();){
            tx.dataWrite().nodeRemoveLabel(node2.node, node2.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assert.assertEquals((long)1L, (long)countTxState);
            Assert.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    public void shouldNotCountRemovedNodesFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        try (Transaction tx = this.beginTransaction();){
            tx.dataWrite().nodeDelete(node2.node);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assert.assertEquals((long)1L, (long)countTxState);
            Assert.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    public void hasPropertiesShouldSeeNewlyCreatedProperties() throws Exception {
        long node;
        try (Transaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try (NodeCursor cursor = tx.cursors().allocateNodeCursor();
             PropertyCursor props = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(node, cursor);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertFalse((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
            Assert.assertTrue((boolean)this.hasProperties(cursor, props));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private boolean hasProperties(NodeCursor cursor, PropertyCursor props) {
        cursor.properties(props);
        return props.next();
    }

    @Test
    public void hasPropertiesShouldSeeNewlyCreatedPropertiesOnNewlyCreatedNode() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor();
                 PropertyCursor props = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(node, cursor);
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)this.hasProperties(cursor, props));
                tx.dataWrite().nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
                Assert.assertTrue((boolean)this.hasProperties(cursor, props));
            }
        }
    }

    @Test
    public void hasPropertiesShouldSeeNewlyRemovedProperties() throws Exception {
        int prop3;
        int prop2;
        int prop1;
        long node;
        try (Transaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            prop3 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop3");
            tx.dataWrite().nodeSetProperty(node, prop1, (Value)Values.longValue((long)1L));
            tx.dataWrite().nodeSetProperty(node, prop2, (Value)Values.longValue((long)2L));
            tx.dataWrite().nodeSetProperty(node, prop3, (Value)Values.longValue((long)3L));
            tx.success();
        }
        tx = this.beginTransaction();
        var7_2 = null;
        try (NodeCursor cursor = tx.cursors().allocateNodeCursor();
             PropertyCursor props = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(node, cursor);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop1);
            Assert.assertTrue((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop2);
            Assert.assertTrue((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop3);
            Assert.assertFalse((boolean)this.hasProperties(cursor, props));
        }
        catch (Throwable throwable) {
            var7_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void propertyTypeShouldBeTxStateAware() throws Exception {
        long node;
        try (Transaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try (NodeCursor nodes = tx.cursors().allocateNodeCursor();
             PropertyCursor properties = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(node, nodes);
            Assert.assertTrue((boolean)nodes.next());
            Assert.assertFalse((boolean)this.hasProperties(nodes, properties));
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(node, prop, (Value)Values.stringValue((String)"foo"));
            nodes.properties(properties);
            Assert.assertTrue((boolean)properties.next());
            MatcherAssert.assertThat((Object)properties.propertyType(), (Matcher)Matchers.equalTo((Object)ValueGroup.TEXT));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertLabels(LabelSet labels, int ... expected) {
        Assert.assertEquals((long)expected.length, (long)labels.numberOfLabels());
        Arrays.sort(expected);
        int[] labelArray = new int[labels.numberOfLabels()];
        for (int i = 0; i < labels.numberOfLabels(); ++i) {
            labelArray[i] = labels.label(i);
        }
        Arrays.sort(labelArray);
        Assert.assertTrue((String)"labels match expected", (boolean)Arrays.equals(expected, labelArray));
    }

    public Node createNode(String ... labels) throws Exception {
        long node;
        int[] labelIds = new int[labels.length];
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            node = write.nodeCreate();
            for (int i = 0; i < labels.length; ++i) {
                labelIds[i] = tx.tokenWrite().labelGetOrCreateForName(labels[i]);
                write.nodeAddLabel(node, labelIds[i]);
            }
            tx.success();
        }
        return new Node(node, labelIds);
    }

    private static class Node {
        private final long node;
        private final int[] labels;

        private Node(long node, int[] labels) {
            this.node = node;
            this.labels = labels;
        }

        public long node() {
            return this.node;
        }

        public int[] labels() {
            return this.labels;
        }
    }
}

