/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.values.storable.Values;

public abstract class PropertyCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final String LONG_STRING = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget nibh cursus, efficitur risus non, ultrices justo. Nulla laoreet eros mi, non molestie magna luctus in. Fusce nibh neque, tristique ultrices laoreet et, aliquet non dolor. Donec ultrices nisi eget urna luctus volutpat. Vivamus hendrerit eget justo vel scelerisque. Morbi interdum volutpat diam, et cursus arcu efficitur consectetur. Cras vitae facilisis ipsum, vitae ullamcorper orci. Nullam tristique ante sed nibh consequat posuere. Curabitur mauris nisl, condimentum ac varius vel, imperdiet a neque. Sed euismod condimentum nisl, vel efficitur turpis tempus id.\n\nSed in tempor arcu. Suspendisse molestie rutrum risus a dignissim. Donec et orci non diam tincidunt sollicitudin non id nisi. Aliquam vehicula imperdiet viverra. Cras et lacinia eros. Etiam imperdiet ac dolor ut tristique. Phasellus ut lacinia ex. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer libero justo, tincidunt ut felis non, interdum consectetur mauris. Cras eu felis ante. Sed dapibus nulla urna, at elementum tortor ultricies pretium. Maecenas sed augue non urna consectetur fringilla vitae eu libero. Vivamus interdum bibendum risus, quis luctus eros.\n\nSed neque augue, fermentum sit amet iaculis ut, porttitor ac odio. Phasellus et sapien non sapien consequat fermentum accumsan non dolor. Integer eget pellentesque lectus, vitae lobortis ante. Nam elementum, dui ut finibus rutrum, purus mauris efficitur purus, efficitur tempus ante metus bibendum velit. Curabitur commodo, risus et eleifend facilisis, eros augue posuere tortor, eu dictum erat tortor consectetur orci. Fusce a velit dignissim, tempus libero nec, faucibus risus. Nullam pharetra mauris sit amet volutpat facilisis. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Praesent lacinia non felis ut lobortis.\n\nOrci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed eu nisi dui. Suspendisse imperdiet lorem vel eleifend faucibus. Mauris non venenatis metus. Aenean neque magna, rhoncus vel velit in, dictum convallis leo. Phasellus pulvinar eu sapien ac vehicula. Praesent placerat augue quam, egestas vehicula velit porttitor in. Vivamus velit metus, pellentesque quis fermentum et, porta quis velit. Curabitur sed lacus quis nibh convallis tincidunt.\n\nEtiam eu elit eget dolor dignissim lacinia. Vivamus tortor ex, dapibus id elementum non, suscipit ac nisl. Aenean vel tempor libero, eu venenatis elit. Nunc nec velit eu odio interdum pellentesque sed et eros. Nam quis mi in metus tristique aliquam. Nullam facilisis dapibus lacus, nec lacinia velit. Proin massa enim, accumsan ac libero at, iaculis sodales tellus. Vivamus fringilla justo sed luctus tincidunt. Sed placerat fringilla ex, vel placerat sem faucibus eget. Vestibulum semper dui sit amet efficitur blandit. Donec eu tellus velit. Etiam a mi nec massa euismod posuere. Cras eget lacus leo.";
    private static long bare;
    private static long byteProp;
    private static long shortProp;
    private static long intProp;
    private static long inlineLongProp;
    private static long longProp;
    private static long floatProp;
    private static long doubleProp;
    private static long trueProp;
    private static long falseProp;
    private static long charProp;
    private static long emptyStringProp;
    private static long shortStringProp;
    private static long longStringProp;
    private static long utf8Prop;
    private static long smallArray;
    private static long bigArray;
    private static long allProps;
    private static String chinese;

    protected boolean supportsBigProperties() {
        return true;
    }

    @Override
    void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            bare = graphDb.createNode().getId();
            byteProp = this.createNodeWithProperty(graphDb, "byteProp", (byte)13);
            shortProp = this.createNodeWithProperty(graphDb, "shortProp", (short)13);
            intProp = this.createNodeWithProperty(graphDb, "intProp", 13);
            inlineLongProp = this.createNodeWithProperty(graphDb, "inlineLongProp", 13L);
            longProp = this.createNodeWithProperty(graphDb, "longProp", Long.MAX_VALUE);
            floatProp = this.createNodeWithProperty(graphDb, "floatProp", Float.valueOf(13.0f));
            doubleProp = this.createNodeWithProperty(graphDb, "doubleProp", 13.0);
            trueProp = this.createNodeWithProperty(graphDb, "trueProp", true);
            falseProp = this.createNodeWithProperty(graphDb, "falseProp", false);
            charProp = this.createNodeWithProperty(graphDb, "charProp", Character.valueOf('x'));
            emptyStringProp = this.createNodeWithProperty(graphDb, "emptyStringProp", "");
            shortStringProp = this.createNodeWithProperty(graphDb, "shortStringProp", "hello");
            longStringProp = this.createNodeWithProperty(graphDb, "longStringProp", LONG_STRING);
            utf8Prop = this.createNodeWithProperty(graphDb, "utf8Prop", chinese);
            smallArray = this.createNodeWithProperty(graphDb, "smallArray", new int[]{1, 2, 3, 4});
            bigArray = this.createNodeWithProperty(graphDb, "bigArray", new String[]{LONG_STRING});
            Node all = graphDb.createNode();
            all.setProperty("byteProp", (Object)13);
            all.setProperty("shortProp", (Object)13);
            all.setProperty("intProp", (Object)13);
            all.setProperty("inlineLongProp", (Object)13L);
            all.setProperty("longProp", (Object)Long.MAX_VALUE);
            all.setProperty("floatProp", (Object)Float.valueOf(13.0f));
            all.setProperty("doubleProp", (Object)13.0);
            all.setProperty("trueProp", (Object)true);
            all.setProperty("falseProp", (Object)false);
            all.setProperty("charProp", (Object)Character.valueOf('x'));
            all.setProperty("emptyStringProp", (Object)"");
            all.setProperty("shortStringProp", (Object)"hello");
            if (this.supportsBigProperties()) {
                all.setProperty("longStringProp", (Object)LONG_STRING);
            }
            all.setProperty("utf8Prop", (Object)chinese);
            if (this.supportsBigProperties()) {
                all.setProperty("smallArray", (Object)new int[]{1, 2, 3, 4});
                all.setProperty("bigArray", (Object)new String[]{LONG_STRING});
            }
            allProps = all.getId();
            tx.success();
        }
    }

    private long createNodeWithProperty(GraphDatabaseService graphDb, String propertyKey, Object value) {
        Node p = graphDb.createNode();
        p.setProperty(propertyKey, value);
        return p.getId();
    }

    @Test
    public void shouldNotAccessNonExistentProperties() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             PropertyCursor props = this.cursors.allocatePropertyCursor();){
            this.read.singleNode(bare, node);
            Assert.assertTrue((String)"node by reference", (boolean)node.next());
            Assert.assertFalse((String)"no properties", (boolean)this.hasProperties(node, props));
            node.properties(props);
            Assert.assertFalse((String)"no properties by direct method", (boolean)props.next());
            this.read.nodeProperties(node.nodeReference(), node.propertiesReference(), props);
            Assert.assertFalse((String)"no properties via property ref", (boolean)props.next());
            Assert.assertFalse((String)"only one node", (boolean)node.next());
        }
    }

    @Test
    public void shouldAccessSingleProperty() {
        this.assertAccessSingleProperty(byteProp, Values.of((Object)13));
        this.assertAccessSingleProperty(shortProp, Values.of((Object)13));
        this.assertAccessSingleProperty(intProp, Values.of((Object)13));
        this.assertAccessSingleProperty(inlineLongProp, Values.of((Object)13L));
        this.assertAccessSingleProperty(longProp, Values.of((Object)Long.MAX_VALUE));
        this.assertAccessSingleProperty(floatProp, Values.of((Object)Float.valueOf(13.0f)));
        this.assertAccessSingleProperty(doubleProp, Values.of((Object)13.0));
        this.assertAccessSingleProperty(trueProp, Values.of((Object)true));
        this.assertAccessSingleProperty(falseProp, Values.of((Object)false));
        this.assertAccessSingleProperty(charProp, Values.of((Object)Character.valueOf('x')));
        this.assertAccessSingleProperty(emptyStringProp, Values.of((Object)""));
        this.assertAccessSingleProperty(shortStringProp, Values.of((Object)"hello"));
        if (this.supportsBigProperties()) {
            this.assertAccessSingleProperty(longStringProp, Values.of((Object)LONG_STRING));
        }
        this.assertAccessSingleProperty(utf8Prop, Values.of((Object)chinese));
        if (this.supportsBigProperties()) {
            this.assertAccessSingleProperty(smallArray, Values.of((Object)new int[]{1, 2, 3, 4}));
            this.assertAccessSingleProperty(bigArray, Values.of((Object)new String[]{LONG_STRING}));
        }
    }

    @Test
    public void shouldAccessAllNodeProperties() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             PropertyCursor props = this.cursors.allocatePropertyCursor();){
            this.read.singleNode(allProps, node);
            Assert.assertTrue((String)"node by reference", (boolean)node.next());
            Assert.assertTrue((String)"has properties", (boolean)this.hasProperties(node, props));
            node.properties(props);
            HashSet<Object> values = new HashSet<Object>();
            while (props.next()) {
                values.add(props.propertyValue().asObject());
            }
            Assert.assertTrue((String)"byteProp", (boolean)values.contains((byte)13));
            Assert.assertTrue((String)"shortProp", (boolean)values.contains((short)13));
            Assert.assertTrue((String)"intProp", (boolean)values.contains(13));
            Assert.assertTrue((String)"inlineLongProp", (boolean)values.contains(13L));
            Assert.assertTrue((String)"longProp", (boolean)values.contains(Long.MAX_VALUE));
            Assert.assertTrue((String)"floatProp", (boolean)values.contains(Float.valueOf(13.0f)));
            Assert.assertTrue((String)"doubleProp", (boolean)values.contains(13.0));
            Assert.assertTrue((String)"trueProp", (boolean)values.contains(true));
            Assert.assertTrue((String)"falseProp", (boolean)values.contains(false));
            Assert.assertTrue((String)"charProp", (boolean)values.contains(Character.valueOf('x')));
            Assert.assertTrue((String)"emptyStringProp", (boolean)values.contains(""));
            Assert.assertTrue((String)"shortStringProp", (boolean)values.contains("hello"));
            Assert.assertTrue((String)"utf8Prop", (boolean)values.contains(chinese));
            if (this.supportsBigProperties()) {
                Assert.assertTrue((String)"longStringProp", (boolean)values.contains(LONG_STRING));
                Assert.assertThat((String)"smallArray", values, (Matcher)Matchers.hasItem(PropertyCursorTestBase.intArray(1, 2, 3, 4)));
                Assert.assertThat((String)"bigArray", values, (Matcher)Matchers.hasItem((Matcher)Matchers.arrayContaining((Object[])new String[]{LONG_STRING})));
            }
            int expected = this.supportsBigProperties() ? 16 : 13;
            Assert.assertEquals((String)"number of values", (long)expected, (long)values.size());
        }
    }

    private void assertAccessSingleProperty(long nodeId, Object expectedValue) {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             PropertyCursor props = this.cursors.allocatePropertyCursor();){
            this.read.singleNode(nodeId, node);
            Assert.assertTrue((String)"node by reference", (boolean)node.next());
            Assert.assertTrue((String)"has properties", (boolean)this.hasProperties(node, props));
            node.properties(props);
            Assert.assertTrue((String)"has properties by direct method", (boolean)props.next());
            Assert.assertEquals((String)"correct value", (Object)expectedValue, (Object)props.propertyValue());
            Assert.assertFalse((String)"single property", (boolean)props.next());
            this.read.nodeProperties(node.nodeReference(), node.propertiesReference(), props);
            Assert.assertTrue((String)"has properties via property ref", (boolean)props.next());
            Assert.assertEquals((String)"correct value", (Object)expectedValue, (Object)props.propertyValue());
            Assert.assertFalse((String)"single property", (boolean)props.next());
        }
    }

    private boolean hasProperties(NodeCursor node, PropertyCursor props) {
        node.properties(props);
        return props.next();
    }

    private static TypeSafeMatcher<int[]> intArray(final int ... content) {
        return new TypeSafeMatcher<int[]>(){

            protected boolean matchesSafely(int[] item) {
                if (item.length != content.length) {
                    return false;
                }
                for (int i = 0; i < content.length; ++i) {
                    if (item[i] == content[i]) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)content);
            }
        };
    }

    static {
        chinese = "\u9020Unicode\u4e4b";
    }
}

