/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTestSupport;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class RelationshipTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    public void shouldSeeSingleRelationshipInTransaction() throws Exception {
        int label;
        long n2;
        long n1;
        try (Transaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            long decoyNode = tx.dataWrite().nodeCreate();
            label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            tx.dataWrite().relationshipCreate(n2, label, decoyNode);
            tx.success();
        }
        tx = this.beginTransaction();
        var7_2 = null;
        try {
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();){
                tx.dataRead().singleRelationship(r, relationship);
                Assert.assertTrue((String)"should find relationship", (boolean)relationship.next());
                Assert.assertEquals((long)label, (long)relationship.type());
                Assert.assertEquals((long)n1, (long)relationship.sourceNodeReference());
                Assert.assertEquals((long)n2, (long)relationship.targetNodeReference());
                Assert.assertEquals((long)r, (long)relationship.relationshipReference());
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var7_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeSingleRelationshipWhichWasDeletedInTransaction() throws Exception {
        long r;
        try (Transaction tx = this.beginTransaction();){
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long decoyNode = tx.dataWrite().nodeCreate();
            tx.dataWrite().relationshipCreate(n2, label, decoyNode);
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.success();
        }
        tx = this.beginTransaction();
        var9_2 = null;
        try {
            Assert.assertTrue((String)"should delete relationship", (boolean)tx.dataWrite().relationshipDelete(r));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();){
                tx.dataRead().singleRelationship(r, relationship);
                Assert.assertFalse((String)"should not find relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var9_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldScanRelationshipInTransaction() throws Exception {
        int type;
        long n2;
        long n1;
        int nRelationshipsInStore = 10;
        try (Transaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            this.relateNTimes(10, type, n1, n2, tx);
            tx.success();
        }
        tx = this.beginTransaction();
        var8_3 = null;
        try {
            long r = tx.dataWrite().relationshipCreate(n1, type, n2);
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();){
                tx.dataRead().allRelationshipsScan(relationship);
                this.assertCountRelationships(relationship, 11, n1, type, n2);
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var8_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotScanRelationshipWhichWasDeletedInTransaction() throws Exception {
        long r;
        int type;
        long n2;
        long n1;
        int nRelationshipsInStore = 11;
        try (Transaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            this.relateNTimes(5, type, n1, n2, tx);
            r = tx.dataWrite().relationshipCreate(n1, type, n2);
            this.relateNTimes(5, type, n1, n2, tx);
            tx.success();
        }
        tx = this.beginTransaction();
        var10_3 = null;
        try {
            Assert.assertTrue((String)"should delete relationship", (boolean)tx.dataWrite().relationshipDelete(r));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();){
                tx.dataRead().allRelationshipsScan(relationship);
                this.assertCountRelationships(relationship, 10, n1, type, n2);
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var10_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var10_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var10_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeRelationshipInTransaction() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var6_2 = null;
        try {
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor();){
                tx.dataRead().singleNode(n1, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.allRelationships(relationship);
                Assert.assertTrue((String)"should find relationship", (boolean)relationship.next());
                Assert.assertEquals((long)r, (long)relationship.relationshipReference());
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeRelationshipDeletedInTransaction() throws Exception {
        long r;
        long n1;
        try (Transaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.success();
        }
        tx = this.beginTransaction();
        var8_2 = null;
        try {
            tx.dataWrite().relationshipDelete(r);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor();){
                tx.dataRead().singleNode(n1, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.allRelationships(relationship);
                Assert.assertFalse((String)"should not find relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var8_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeRelationshipInTransactionBeforeCursorInitialization() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = this.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var6_2 = null;
        try {
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor();){
                tx.dataRead().singleNode(n1, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.allRelationships(relationship);
                Assert.assertTrue((String)"should find relationship", (boolean)relationship.next());
                Assert.assertEquals((long)r, (long)relationship.relationshipReference());
                tx.dataWrite().relationshipCreate(n1, label, n2);
                Assert.assertFalse((String)"should not find relationship added after cursor init", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldTraverseSparseNodeWithoutGroups() throws Exception {
        this.traverseWithoutGroups(RelationshipTestSupport.sparse(graphDb), false);
    }

    @Test
    public void shouldTraverseDenseNodeWithoutGroups() throws Exception {
        this.traverseWithoutGroups(RelationshipTestSupport.dense(graphDb), false);
    }

    @Test
    public void shouldTraverseSparseNodeWithoutGroupsWithDetachedReferences() throws Exception {
        this.traverseWithoutGroups(RelationshipTestSupport.sparse(graphDb), true);
    }

    @Test
    public void shouldTraverseDenseNodeWithoutGroupsWithDetachedReferences() throws Exception {
        this.traverseWithoutGroups(RelationshipTestSupport.dense(graphDb), true);
    }

    @Test
    public void shouldTraverseSparseNodeViaGroups() throws Exception {
        this.traverseViaGroups(RelationshipTestSupport.sparse(graphDb), false);
    }

    @Test
    public void shouldTraverseDenseNodeViaGroups() throws Exception {
        this.traverseViaGroups(RelationshipTestSupport.dense(graphDb), false);
    }

    @Test
    public void shouldTraverseSparseNodeViaGroupsWithDetachedReferences() throws Exception {
        this.traverseViaGroups(RelationshipTestSupport.sparse(graphDb), true);
    }

    @Test
    public void shouldTraverseDenseNodeViaGroupsWithDetachedReferences() throws Exception {
        this.traverseViaGroups(RelationshipTestSupport.dense(graphDb), true);
    }

    @Test
    public void shouldSeeNewRelationshipPropertyInTransaction() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            String propKey1 = "prop1";
            String propKey2 = "prop2";
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            int prop1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            int prop2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            Assert.assertEquals((Object)tx.dataWrite().relationshipSetProperty(r, prop1, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            Assert.assertEquals((Object)tx.dataWrite().relationshipSetProperty(r, prop2, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(n1, node);
                Assert.assertTrue((String)"should access node", (boolean)node.next());
                node.allRelationships(relationship);
                Assert.assertTrue((String)"should access relationship", (boolean)relationship.next());
                relationship.properties(property);
                while (property.next()) {
                    if (property.propertyKey() == prop1) {
                        Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                        continue;
                    }
                    if (property.propertyKey() == prop2) {
                        Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                        continue;
                    }
                    Assert.fail((String)(property.propertyKey() + " was not the property key you were looking for"));
                }
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship.next());
            }
            tx.success();
        }
    }

    @Test
    public void shouldSeeAddedPropertyFromExistingRelationshipWithoutPropertiesInTransaction() throws Exception {
        long relationshipId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            tx.success();
        }
        tx = this.beginTransaction();
        var5_3 = null;
        try {
            int propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)tx.dataWrite().relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                Assert.assertTrue((String)"should access relationship", (boolean)relationship.next());
                relationship.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                Assert.assertFalse((String)"should only find one properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getRelationshipById(relationshipId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"hello"));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeAddedPropertyFromExistingRelationshipWithPropertiesInTransaction() throws Exception {
        RelationshipScanCursor relationship2;
        int propToken1;
        long relationshipId;
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            Assert.assertEquals((Object)write.relationshipSetProperty(relationshipId, propToken1, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var8_4 = null;
        try {
            int propToken2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            Assert.assertEquals((Object)tx.dataWrite().relationshipSetProperty(relationshipId, propToken2, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            relationship2 = tx.cursors().allocateRelationshipScanCursor();
            Throwable throwable = null;
            try (PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleRelationship(relationshipId, relationship2);
                Assert.assertTrue((String)"should access relationship", (boolean)relationship2.next());
                relationship2.properties(property);
                while (property.next()) {
                    if (property.propertyKey() == propToken1) {
                        Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                        continue;
                    }
                    if (property.propertyKey() == propToken2) {
                        Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                        continue;
                    }
                    Assert.fail((String)(property.propertyKey() + " was not the property you were looking for"));
                }
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship2.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (relationship2 != null) {
                    if (throwable != null) {
                        try {
                            relationship2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        relationship2.close();
                    }
                }
            }
            tx.success();
        }
        catch (Throwable relationship2) {
            var8_4 = relationship2;
            throw relationship2;
        }
        finally {
            if (tx != null) {
                if (var8_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable relationship2) {
                        var8_4.addSuppressed(relationship2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var8_4 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            relationship2 = graphDb.getRelationshipById(relationshipId);
            MatcherAssert.assertThat((Object)relationship2.getProperty(propKey1), (Matcher)Matchers.equalTo((Object)"hello"));
            MatcherAssert.assertThat((Object)relationship2.getProperty(propKey2), (Matcher)Matchers.equalTo((Object)"world"));
        }
        catch (Throwable throwable) {
            var8_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeUpdatedPropertyFromExistingRelationshipWithPropertiesInTransaction() throws Exception {
        int propToken;
        long relationshipId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)write.relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var6_3 = null;
        try {
            Assert.assertEquals((Object)tx.dataWrite().relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"world")), (Object)Values.stringValue((String)"hello"));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                Assert.assertTrue((String)"should access relationship", (boolean)relationship.next());
                relationship.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assert.assertFalse((String)"should only find one property", (boolean)property.next());
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getRelationshipById(relationshipId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"world"));
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldNotSeeRemovedPropertyInTransaction() throws Exception {
        int propToken;
        long relationshipId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)write.relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var6_3 = null;
        try {
            Assert.assertEquals((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, propToken), (Object)Values.stringValue((String)"hello"));
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                Assert.assertTrue((String)"should access relationship", (boolean)relationship.next());
                relationship.properties(property);
                Assert.assertFalse((String)"should not find any properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            Assert.assertFalse((boolean)graphDb.getRelationshipById(relationshipId).hasProperty(propKey));
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldSeeRemovedThenAddedPropertyInTransaction() throws Exception {
        int propToken;
        long relationshipId;
        String propKey = "prop1";
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            relationshipId = write.relationshipCreate(write.nodeCreate(), tx.tokenWrite().relationshipTypeGetOrCreateForName("R"), write.nodeCreate());
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assert.assertEquals((Object)write.relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.success();
        }
        tx = this.beginTransaction();
        var6_3 = null;
        try {
            Assert.assertEquals((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, propToken), (Object)Values.stringValue((String)"hello"));
            Assert.assertEquals((Object)tx.dataWrite().relationshipSetProperty(relationshipId, propToken, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (RelationshipScanCursor relationship = tx.cursors().allocateRelationshipScanCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleRelationship(relationshipId, relationship);
                Assert.assertTrue((String)"should access relationship", (boolean)relationship.next());
                relationship.properties(property);
                Assert.assertTrue((boolean)property.next());
                Assert.assertEquals((long)propToken, (long)property.propertyKey());
                Assert.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assert.assertFalse((String)"should not find any properties", (boolean)property.next());
                Assert.assertFalse((String)"should only find one relationship", (boolean)relationship.next());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_3 = null;
        try (org.neo4j.graphdb.Transaction ignored = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getRelationshipById(relationshipId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"world"));
        }
        catch (Throwable throwable) {
            var6_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldCountFromTxState() throws Exception {
        this.assertCount(100, RelationshipDirection.OUT, group -> {
            Assert.assertEquals((long)101L, (long)group.outgoingCount());
            Assert.assertEquals((long)0L, (long)group.incomingCount());
            Assert.assertEquals((long)0L, (long)group.loopCount());
            Assert.assertEquals((long)101L, (long)group.totalCount());
        });
        this.assertCount(1, RelationshipDirection.OUT, group -> {
            Assert.assertEquals((long)2L, (long)group.outgoingCount());
            Assert.assertEquals((long)0L, (long)group.incomingCount());
            Assert.assertEquals((long)0L, (long)group.loopCount());
            Assert.assertEquals((long)2L, (long)group.totalCount());
        });
        this.assertCount(100, RelationshipDirection.IN, group -> {
            Assert.assertEquals((long)0L, (long)group.outgoingCount());
            Assert.assertEquals((long)101L, (long)group.incomingCount());
            Assert.assertEquals((long)0L, (long)group.outgoingCount());
            Assert.assertEquals((long)101L, (long)group.totalCount());
        });
        this.assertCount(1, RelationshipDirection.IN, group -> {
            Assert.assertEquals((long)0L, (long)group.outgoingCount());
            Assert.assertEquals((long)2L, (long)group.incomingCount());
            Assert.assertEquals((long)0L, (long)group.loopCount());
            Assert.assertEquals((long)2L, (long)group.totalCount());
        });
        this.assertCount(100, RelationshipDirection.LOOP, group -> {
            Assert.assertEquals((long)0L, (long)group.incomingCount());
            Assert.assertEquals((long)0L, (long)group.outgoingCount());
            Assert.assertEquals((long)101L, (long)group.loopCount());
            Assert.assertEquals((long)101L, (long)group.totalCount());
        });
        this.assertCount(1, RelationshipDirection.LOOP, group -> {
            Assert.assertEquals((long)0L, (long)group.outgoingCount());
            Assert.assertEquals((long)0L, (long)group.incomingCount());
            Assert.assertEquals((long)2L, (long)group.loopCount());
            Assert.assertEquals((long)2L, (long)group.totalCount());
        });
    }

    @Test
    public void groupCursorShouldSeeNewTypes() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            long start = write.nodeCreate();
            int outgoing = tx.tokenWrite().relationshipTypeGetOrCreateForName("OUT");
            int incoming = tx.tokenWrite().relationshipTypeGetOrCreateForName("IN");
            int looping = tx.tokenWrite().relationshipTypeGetOrCreateForName("LOOP");
            long out = write.relationshipCreate(start, outgoing, write.nodeCreate());
            long in1 = write.relationshipCreate(write.nodeCreate(), incoming, start);
            long in2 = write.relationshipCreate(write.nodeCreate(), incoming, start);
            long loop = write.relationshipCreate(start, looping, start);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                Assert.assertTrue((boolean)node.next());
                node.relationships(group);
                while (group.next()) {
                    int t = group.type();
                    if (t == outgoing) {
                        Assert.assertEquals((long)1L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.OUT, group, traversal, out);
                        this.assertNoRelationships(RelationshipDirection.IN, group, traversal);
                        this.assertNoRelationships(RelationshipDirection.LOOP, group, traversal);
                        continue;
                    }
                    if (t == incoming) {
                        Assert.assertEquals((long)0L, (long)group.outgoingCount());
                        Assert.assertEquals((long)2L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.IN, group, traversal, in1, in2);
                        this.assertNoRelationships(RelationshipDirection.OUT, group, traversal);
                        this.assertNoRelationships(RelationshipDirection.LOOP, group, traversal);
                        continue;
                    }
                    if (t == looping) {
                        Assert.assertEquals((long)0L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)1L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.LOOP, group, traversal, loop);
                        this.assertNoRelationships(RelationshipDirection.OUT, group, traversal);
                        this.assertNoRelationships(RelationshipDirection.IN, group, traversal);
                        continue;
                    }
                    Assert.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
    }

    @Test
    public void groupCursorShouldAddToCountFromTxState() throws Exception {
        long existingRelationship;
        int type;
        long start;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("OUT");
            existingRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            tx.success();
        }
        tx = this.beginTransaction();
        var7_2 = null;
        try {
            write = tx.dataWrite();
            long newRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                Assert.assertTrue((boolean)node.next());
                node.relationships(group);
                Assert.assertTrue((boolean)group.next());
                Assert.assertEquals((long)type, (long)group.type());
                Assert.assertEquals((long)2L, (long)group.outgoingCount());
                Assert.assertEquals((long)0L, (long)group.incomingCount());
                Assert.assertEquals((long)0L, (long)group.loopCount());
                this.assertRelationships(RelationshipDirection.OUT, group, traversal, newRelationship, existingRelationship);
                Assert.assertFalse((boolean)group.next());
            }
        }
        catch (Throwable throwable) {
            var7_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void groupCursorShouldSeeBothOldAndNewRelationshipsFromSparseNode() throws Exception {
        long existingRelationship;
        int one;
        long start;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            one = tx.tokenWrite().relationshipTypeGetOrCreateForName("ONE");
            existingRelationship = write.relationshipCreate(start, one, write.nodeCreate());
            tx.success();
        }
        tx = this.beginTransaction();
        var7_2 = null;
        try {
            write = tx.dataWrite();
            int two = tx.tokenWrite().relationshipTypeGetOrCreateForName("TWO");
            long newRelationship = write.relationshipCreate(start, two, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                Assert.assertTrue((boolean)node.next());
                Assert.assertFalse((boolean)node.isDense());
                node.relationships(group);
                while (group.next()) {
                    int t = group.type();
                    if (t == one) {
                        Assert.assertEquals((long)1L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.OUT, group, traversal, existingRelationship);
                        continue;
                    }
                    if (t == two) {
                        Assert.assertEquals((long)1L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.OUT, group, traversal, newRelationship);
                        continue;
                    }
                    Assert.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
        catch (Throwable throwable) {
            var7_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void groupCursorShouldSeeBothOldAndNewRelationshipsFromDenseNode() throws Exception {
        int bulk;
        long existingRelationship;
        int one;
        long start;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            one = tx.tokenWrite().relationshipTypeGetOrCreateForName("ONE");
            existingRelationship = write.relationshipCreate(start, one, write.nodeCreate());
            bulk = tx.tokenWrite().relationshipTypeGetOrCreateForName("BULK");
            for (int i = 0; i < 100; ++i) {
                write.relationshipCreate(start, bulk, write.nodeCreate());
            }
            tx.success();
        }
        tx = this.beginTransaction();
        var8_2 = null;
        try {
            write = tx.dataWrite();
            int two = tx.tokenWrite().relationshipTypeGetOrCreateForName("TWO");
            long newRelationship = write.relationshipCreate(start, two, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                Assert.assertTrue((boolean)node.next());
                Assert.assertTrue((boolean)node.isDense());
                node.relationships(group);
                while (group.next()) {
                    int t = group.type();
                    if (t == one) {
                        Assert.assertEquals((long)1L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.OUT, group, traversal, existingRelationship);
                        continue;
                    }
                    if (t == two) {
                        Assert.assertEquals((long)1L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.OUT, group, traversal, newRelationship);
                        continue;
                    }
                    if (t == bulk) {
                        Assert.assertEquals((long)100L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        continue;
                    }
                    Assert.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
        catch (Throwable throwable) {
            var8_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void groupCursorShouldNewRelationshipBetweenAlreadyConnectedSparseNodes() throws Exception {
        long existingRelationship;
        int type;
        long start;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            long end = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            existingRelationship = write.relationshipCreate(start, type, end);
            tx.success();
        }
        tx = this.beginTransaction();
        var9_2 = null;
        try {
            write = tx.dataWrite();
            long newRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                Assert.assertTrue((boolean)node.next());
                Assert.assertFalse((boolean)node.isDense());
                node.relationships(group);
                Assert.assertTrue((boolean)group.next());
                Assert.assertEquals((long)type, (long)group.type());
                Assert.assertEquals((long)2L, (long)group.outgoingCount());
                Assert.assertEquals((long)0L, (long)group.incomingCount());
                Assert.assertEquals((long)0L, (long)group.loopCount());
                this.assertRelationships(RelationshipDirection.OUT, group, traversal, newRelationship, existingRelationship);
                Assert.assertFalse((boolean)group.next());
            }
        }
        catch (Throwable throwable) {
            var9_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void groupCursorShouldNewRelationshipBetweenAlreadyConnectedDenseNodes() throws Exception {
        int bulk;
        long existingRelationship;
        int type;
        long start;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            long end = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            existingRelationship = write.relationshipCreate(start, type, end);
            bulk = tx.tokenWrite().relationshipTypeGetOrCreateForName("BULK");
            for (int i = 0; i < 100; ++i) {
                write.relationshipCreate(start, bulk, write.nodeCreate());
            }
            tx.success();
        }
        tx = this.beginTransaction();
        var10_2 = null;
        try {
            write = tx.dataWrite();
            long newRelationship = write.relationshipCreate(start, type, write.nodeCreate());
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                Assert.assertTrue((boolean)node.next());
                Assert.assertTrue((boolean)node.isDense());
                node.relationships(group);
                while (group.next()) {
                    int t = group.type();
                    if (t == type) {
                        Assert.assertEquals((long)2L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        this.assertRelationships(RelationshipDirection.OUT, group, traversal, existingRelationship, newRelationship);
                        continue;
                    }
                    if (t == bulk) {
                        Assert.assertEquals((long)bulk, (long)group.type());
                        Assert.assertEquals((long)100L, (long)group.outgoingCount());
                        Assert.assertEquals((long)0L, (long)group.incomingCount());
                        Assert.assertEquals((long)0L, (long)group.loopCount());
                        continue;
                    }
                    Assert.fail((String)(t + "  is not the type you're looking for "));
                }
            }
        }
        catch (Throwable throwable) {
            var10_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var10_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var10_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldCountNewRelationships() throws Exception {
        int relationship;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            relationship = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            write.relationshipCreate(write.nodeCreate(), relationship, write.nodeCreate());
            tx.success();
        }
        tx = this.beginTransaction();
        var3_2 = null;
        try {
            write = tx.dataWrite();
            write.relationshipCreate(write.nodeCreate(), relationship, write.nodeCreate());
            long countsTxState = tx.dataRead().countsForRelationship(-1, relationship, -1);
            long countsNoTxState = tx.dataRead().countsForRelationshipWithoutTxState(-1, relationship, -1);
            Assert.assertEquals((long)2L, (long)countsTxState);
            Assert.assertEquals((long)1L, (long)countsNoTxState);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotCountRemovedRelationships() throws Exception {
        long relationship;
        int relationshipId;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            relationshipId = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), relationshipId, write.nodeCreate());
            tx.success();
        }
        tx = this.beginTransaction();
        var5_2 = null;
        try {
            write = tx.dataWrite();
            write.relationshipDelete(relationship);
            long countsTxState = tx.dataRead().countsForRelationship(-1, relationshipId, -1);
            long countsNoTxState = tx.dataRead().countsForRelationshipWithoutTxState(-1, relationshipId, -1);
            Assert.assertEquals((long)0L, (long)countsTxState);
            Assert.assertEquals((long)1L, (long)countsNoTxState);
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertRelationships(RelationshipDirection direction, RelationshipGroupCursor group, RelationshipTraversalCursor traversal, long ... relationships) {
        switch (direction) {
            case OUT: {
                group.outgoing(traversal);
                break;
            }
            case IN: {
                group.incoming(traversal);
                break;
            }
            case LOOP: {
                group.loops(traversal);
                break;
            }
            default: {
                throw new AssertionError((Object)"Where is your god now!");
            }
        }
        LongHashSet set = LongHashSet.newSetWith((long[])relationships);
        for (long relationship : relationships) {
            Assert.assertTrue((boolean)traversal.next());
            Assert.assertTrue((boolean)set.contains(traversal.relationshipReference()));
            set.remove(traversal.relationshipReference());
        }
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertFalse((boolean)traversal.next());
    }

    private void assertNoRelationships(RelationshipDirection direction, RelationshipGroupCursor group, RelationshipTraversalCursor traversal) {
        switch (direction) {
            case OUT: {
                group.outgoing(traversal);
                Assert.assertFalse((boolean)traversal.next());
                break;
            }
            case IN: {
                group.incoming(traversal);
                Assert.assertFalse((boolean)traversal.next());
                break;
            }
            case LOOP: {
                group.loops(traversal);
                Assert.assertFalse((boolean)traversal.next());
                break;
            }
            default: {
                throw new AssertionError((Object)"Where is your god now!");
            }
        }
    }

    private void traverseWithoutGroups(RelationshipTestSupport.StartNode start, boolean detached) throws Exception {
        try (Transaction tx = this.beginTransaction();){
            Map<String, Integer> expectedCounts = this.modifyStartNodeRelationships(start, tx);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor();){
                tx.dataRead().singleNode(start.id, node);
                Assert.assertTrue((String)"access node", (boolean)node.next());
                if (detached) {
                    tx.dataRead().relationships(start.id, node.allRelationshipsReference(), relationship);
                } else {
                    node.allRelationships(relationship);
                }
                Map<String, Integer> counts = RelationshipTestSupport.count(tx, relationship);
                RelationshipTestSupport.assertCounts(expectedCounts, counts);
            }
            tx.failure();
        }
    }

    private void traverseViaGroups(RelationshipTestSupport.StartNode start, boolean detached) throws Exception {
        try (Transaction tx = this.beginTransaction();){
            Read read = tx.dataRead();
            Map<String, Integer> expectedCounts = this.modifyStartNodeRelationships(start, tx);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();
                 RelationshipTraversalCursor relationship = tx.cursors().allocateRelationshipTraversalCursor();){
                read.singleNode(start.id, node);
                Assert.assertTrue((String)"access node", (boolean)node.next());
                if (detached) {
                    read.relationshipGroups(start.id, node.relationshipGroupReference(), group);
                } else {
                    node.relationships(group);
                }
                while (group.next()) {
                    if (detached) {
                        read.relationships(start.id, group.outgoingReference(), relationship);
                    } else {
                        group.outgoing(relationship);
                    }
                    RelationshipTestSupport.assertCount(tx, relationship, expectedCounts, group.type(), Direction.OUTGOING);
                    if (detached) {
                        read.relationships(start.id, group.incomingReference(), relationship);
                    } else {
                        group.incoming(relationship);
                    }
                    RelationshipTestSupport.assertCount(tx, relationship, expectedCounts, group.type(), Direction.INCOMING);
                    if (detached) {
                        read.relationships(start.id, group.loopsReference(), relationship);
                    } else {
                        group.loops(relationship);
                    }
                    RelationshipTestSupport.assertCount(tx, relationship, expectedCounts, group.type(), Direction.BOTH);
                }
            }
        }
    }

    private Map<String, Integer> modifyStartNodeRelationships(RelationshipTestSupport.StartNode start, Transaction tx) throws KernelException {
        HashMap<String, Integer> expectedCounts = new HashMap<String, Integer>();
        for (Map.Entry<String, List<RelationshipTestSupport.StartRelationship>> kv : start.relationships.entrySet()) {
            List<RelationshipTestSupport.StartRelationship> rs = kv.getValue();
            RelationshipTestSupport.StartRelationship head = rs.get(0);
            int type = tx.token().relationshipType(head.type.name());
            switch (head.direction) {
                case INCOMING: {
                    tx.dataWrite().relationshipCreate(tx.dataWrite().nodeCreate(), type, start.id);
                    tx.dataWrite().relationshipCreate(tx.dataWrite().nodeCreate(), type, start.id);
                    break;
                }
                case OUTGOING: {
                    tx.dataWrite().relationshipCreate(start.id, type, tx.dataWrite().nodeCreate());
                    tx.dataWrite().relationshipCreate(start.id, type, tx.dataWrite().nodeCreate());
                    break;
                }
                case BOTH: {
                    tx.dataWrite().relationshipCreate(start.id, type, start.id);
                    tx.dataWrite().relationshipCreate(start.id, type, start.id);
                    break;
                }
                default: {
                    throw new IllegalStateException("Oh ye be cursed, foul checkstyle!");
                }
            }
            tx.dataWrite().relationshipDelete(head.id);
            expectedCounts.put(kv.getKey(), rs.size() + 1);
        }
        String newTypeName = "NEW";
        int newType = tx.token().relationshipTypeGetOrCreateForName(newTypeName);
        tx.dataWrite().relationshipCreate(tx.dataWrite().nodeCreate(), newType, start.id);
        tx.dataWrite().relationshipCreate(start.id, newType, tx.dataWrite().nodeCreate());
        tx.dataWrite().relationshipCreate(start.id, newType, start.id);
        expectedCounts.put(RelationshipTestSupport.computeKey(newTypeName, Direction.OUTGOING), 1);
        expectedCounts.put(RelationshipTestSupport.computeKey(newTypeName, Direction.INCOMING), 1);
        expectedCounts.put(RelationshipTestSupport.computeKey(newTypeName, Direction.BOTH), 1);
        return expectedCounts;
    }

    @Test
    public void hasPropertiesShouldSeeNewlyCreatedProperties() throws Exception {
        long relationship;
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor();){
            tx.dataRead().singleRelationship(relationship, cursor);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertFalse((boolean)this.hasProperties(cursor, tx));
            tx.dataWrite().relationshipSetProperty(relationship, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
            Assert.assertTrue((boolean)this.hasProperties(cursor, tx));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void hasPropertiesShouldSeeNewlyCreatedPropertiesOnNewlyCreatedRelationship() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            long relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor();){
                tx.dataRead().singleRelationship(relationship, cursor);
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)this.hasProperties(cursor, tx));
                tx.dataWrite().relationshipSetProperty(relationship, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
                Assert.assertTrue((boolean)this.hasProperties(cursor, tx));
            }
        }
    }

    @Test
    public void hasPropertiesShouldSeeNewlyRemovedProperties() throws Exception {
        int prop3;
        int prop2;
        int prop1;
        long relationship;
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            prop3 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop3");
            tx.dataWrite().relationshipSetProperty(relationship, prop1, (Value)Values.longValue((long)1L));
            tx.dataWrite().relationshipSetProperty(relationship, prop2, (Value)Values.longValue((long)2L));
            tx.dataWrite().relationshipSetProperty(relationship, prop3, (Value)Values.longValue((long)3L));
            tx.success();
        }
        tx = this.beginTransaction();
        var7_2 = null;
        try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor();){
            tx.dataRead().singleRelationship(relationship, cursor);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)this.hasProperties(cursor, tx));
            tx.dataWrite().relationshipRemoveProperty(relationship, prop1);
            Assert.assertTrue((boolean)this.hasProperties(cursor, tx));
            tx.dataWrite().relationshipRemoveProperty(relationship, prop2);
            Assert.assertTrue((boolean)this.hasProperties(cursor, tx));
            tx.dataWrite().relationshipRemoveProperty(relationship, prop3);
            Assert.assertFalse((boolean)this.hasProperties(cursor, tx));
        }
        catch (Throwable throwable) {
            var7_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void propertyTypeShouldBeTxStateAware() throws Exception {
        long relationship;
        try (Transaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int token = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            relationship = write.relationshipCreate(write.nodeCreate(), token, write.nodeCreate());
            tx.success();
        }
        tx = this.beginTransaction();
        var4_2 = null;
        try (RelationshipScanCursor relationships = tx.cursors().allocateRelationshipScanCursor();
             PropertyCursor properties = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleRelationship(relationship, relationships);
            Assert.assertTrue((boolean)relationships.next());
            Assert.assertFalse((boolean)this.hasProperties(relationships, tx));
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().relationshipSetProperty(relationship, prop, (Value)Values.stringValue((String)"foo"));
            relationships.properties(properties);
            Assert.assertTrue((boolean)properties.next());
            MatcherAssert.assertThat((Object)properties.propertyType(), (Matcher)Matchers.equalTo((Object)ValueGroup.TEXT));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private boolean hasProperties(RelationshipScanCursor cursor, Transaction tx) {
        try (PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor();){
            cursor.properties(propertyCursor);
            boolean bl = propertyCursor.next();
            return bl;
        }
    }

    private void relateNTimes(int nRelationshipsInStore, int type, long n1, long n2, Transaction tx) throws KernelException {
        for (int i = 0; i < nRelationshipsInStore; ++i) {
            tx.dataWrite().relationshipCreate(n1, type, n2);
        }
    }

    private void assertCountRelationships(RelationshipScanCursor relationship, int expectedCount, long sourceNode, int type, long targetNode) {
        int count = 0;
        while (relationship.next()) {
            Assert.assertEquals((long)sourceNode, (long)relationship.sourceNodeReference());
            Assert.assertEquals((long)type, (long)relationship.type());
            Assert.assertEquals((long)targetNode, (long)relationship.targetNodeReference());
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    private void assertCount(int count, RelationshipDirection direction, Consumer<RelationshipGroupCursor> asserter) throws Exception {
        int type;
        long start;
        Write write;
        try (Transaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            start = write.nodeCreate();
            type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < count; ++i) {
                this.createRelationship(direction, start, type, write);
            }
            tx.success();
        }
        tx = this.beginTransaction();
        var8_5 = null;
        try {
            write = tx.dataWrite();
            this.createRelationship(direction, start, type, write);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 RelationshipGroupCursor group = tx.cursors().allocateRelationshipGroupCursor();){
                Read read = tx.dataRead();
                read.singleNode(start, node);
                Assert.assertTrue((boolean)node.next());
                node.relationships(group);
                Assert.assertTrue((boolean)group.next());
                asserter.accept(group);
            }
        }
        catch (Throwable throwable) {
            var8_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void createRelationship(RelationshipDirection direction, long start, int type, Write write) throws EntityNotFoundException {
        switch (direction) {
            case OUT: {
                write.relationshipCreate(start, type, write.nodeCreate());
                break;
            }
            case IN: {
                write.relationshipCreate(write.nodeCreate(), type, start);
                break;
            }
            case LOOP: {
                write.relationshipCreate(start, type, start);
                break;
            }
            default: {
                throw new IllegalStateException("Checkstyle, you win again!");
            }
        }
    }

    static enum RelationshipDirection {
        OUT,
        IN,
        LOOP;

    }
}

