/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class IndexQueryTest {
    private final int propId = 0;
    private PointValue gps1 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-12.6, -56.7});
    private PointValue gps2 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-12.6, -55.7});
    private PointValue gps3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-11.0, -55.0});
    private PointValue gps4 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
    private PointValue gps5 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{14.6, 56.7});
    private PointValue gps6 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{14.6, 58.7});
    private PointValue gps7 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.6, 59.7});
    private PointValue car1 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0});
    private PointValue car2 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{2.0, 2.0});
    private PointValue car3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 2.0, 3.0});
    private PointValue car4 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{2.0, 3.0, 4.0});
    private PointValue gps1_3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.6, 56.8, 100.0});
    private PointValue gps2_3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.8, 56.9, 200.0});

    @Test
    public void testExists() {
        IndexQuery.ExistsPredicate p = IndexQuery.exists((int)0);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "string"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 1));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 1.0));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, true));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, new long[]{1L}));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, null));
    }

    @Test
    public void testExact() {
        this.assertExactPredicate("string");
        this.assertExactPredicate(1);
        this.assertExactPredicate(1.0);
        this.assertExactPredicate(true);
        this.assertExactPredicate(new long[]{1L});
        this.assertExactPredicate(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
    }

    private void assertExactPredicate(Object value) {
        IndexQuery.ExactPredicate p = IndexQuery.exact((int)0, (Object)value);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, value));
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testExact_ComparingBigDoublesAndLongs() {
        IndexQuery.ExactPredicate p = IndexQuery.exact((int)0, (Object)0x20000000000001L);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 9.007199254740992E15));
    }

    @Test
    public void testNumRange_FalseForIrrelevant() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)true);
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testNumRange_InclusiveLowerInclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_ExclusiveLowerExclusiveLower() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)false, (Number)13, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 13));
    }

    @Test
    public void testNumRange_InclusiveLowerExclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 13));
    }

    @Test
    public void testNumRange_ExclusiveLowerInclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)false, (Number)13, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_LowerNullValue() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, null, (boolean)true, (Number)13, (boolean)true);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_UpperNullValue() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, null, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_ComparingBigDoublesAndLongs() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Number)0x20000000000001L, (boolean)true, null, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 9.007199254740992E15));
    }

    @Test
    public void testStringRange_FalseForIrrelevant() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringRange_InclusiveLowerInclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bee"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "beea"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bef"));
    }

    @Test
    public void testStringRange_ExclusiveLowerInclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)false, (String)"bee", (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bee"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "beea"));
    }

    @Test
    public void testStringRange_InclusiveLowerExclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bed"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bee"));
    }

    @Test
    public void testStringRange_ExclusiveLowerExclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)false, (String)"bee", (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bed"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bee"));
    }

    @Test
    public void testStringRange_UpperUnbounded() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)false, null, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "xxxxx"));
    }

    @Test
    public void testStringRange_LowerUnbounded() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, null, (boolean)false, (String)"bee", (boolean)false);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, ""));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bed"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bee"));
    }

    @Test
    public void testGeometryRange_FalseForIrrelevant() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.gps2, (boolean)true, (Value)this.gps5, (boolean)true);
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testGeometryRange_InclusiveLowerInclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.gps2, (boolean)true, (Value)this.gps5, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps2));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps6));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps7));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
    }

    @Test
    public void testGeometryRange_ExclusiveLowerInclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.gps2, (boolean)false, (Value)this.gps5, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps2));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps6));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
    }

    @Test
    public void testGeometryRange_InclusiveLowerExclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.gps2, (boolean)true, (Value)this.gps5, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps2));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
    }

    @Test
    public void testGeometryRange_ExclusiveLowerExclusiveUpper() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.gps2, (boolean)false, (Value)this.gps5, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps2));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps4));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
    }

    @Test
    public void testGeometryRange_UpperUnbounded() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.gps2, (boolean)false, null, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps2));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps7));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
    }

    @Test
    public void testGeometryRange_LowerUnbounded() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, null, (boolean)false, (Value)this.gps5, (boolean)false);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps1));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
    }

    @Test
    public void testGeometryRange_Cartesian() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.car1, (boolean)false, (Value)this.car2, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car4));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps2_3d));
    }

    @Test
    public void testGeometryRange_Cartesian3D() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.car3, (boolean)true, (Value)this.car4, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.car4));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps2_3d));
    }

    @Test
    public void testGeometryRange_WGS84_3D() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)this.gps1_3d, (boolean)true, (Value)this.gps2_3d, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps5));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car3));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car4));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps1_3d));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps2_3d));
    }

    @Test
    public void testDateRange() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (Value)DateValue.date((int)2014, (int)7, (int)7), (boolean)true, (Value)DateValue.date((int)2017, (int)3, (int)7), (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, DateValue.date((int)2014, (int)6, (int)8)));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, DateValue.date((int)2014, (int)7, (int)7)));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, DateValue.date((int)2016, (int)6, (int)8)));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, DateValue.date((int)2017, (int)3, (int)7)));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, DateValue.date((int)2017, (int)3, (int)8)));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, LocalDateTimeValue.localDateTime((int)2016, (int)3, (int)8, (int)0, (int)0, (int)0, (int)0)));
    }

    @Test
    public void testValueGroupRange() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (ValueGroup)ValueGroup.DATE);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, DateValue.date((int)-4000, (int)1, (int)31)));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, DateValue.date((int)2018, (int)3, (int)7)));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, DateTimeValue.datetime((int)2018, (int)3, (int)7, (int)0, (int)0, (int)0, (int)0, (ZoneId)ZoneOffset.UTC)));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, Values.stringValue((String)"hej")));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps2_3d));
    }

    @Test
    public void testCRSRange() {
        IndexQuery.RangePredicate p = IndexQuery.range((int)0, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, this.gps2));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, DateValue.date((int)-4000, (int)1, (int)31)));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, Values.stringValue((String)"hej")));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car1));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.car4));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, this.gps1_3d));
    }

    @Test
    public void testStringPrefix_FalseForIrrelevant() {
        IndexQuery.StringPrefixPredicate p = IndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"dog"));
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringPrefix_SomeValues() {
        IndexQuery.StringPrefixPredicate p = IndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"dog"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "doffington"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "doh, not this again!"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "dog"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "doggidog"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "doggidogdog"));
    }

    @Test
    public void testStringContains_FalseForIrrelevant() {
        IndexQuery.StringContainsPredicate p = IndexQuery.stringContains((int)0, (TextValue)Values.stringValue((String)"cat"));
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringContains_SomeValues() {
        IndexQuery.StringContainsPredicate p = IndexQuery.stringContains((int)0, (TextValue)Values.stringValue((String)"cat"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "dog"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "cameraman"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "Cat"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "cat"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bobcat"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "scatman"));
    }

    @Test
    public void testStringSuffix_FalseForIrrelevant() {
        IndexQuery.StringSuffixPredicate p = IndexQuery.stringSuffix((int)0, (TextValue)Values.stringValue((String)"less"));
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringSuffix_SomeValues() {
        IndexQuery.StringSuffixPredicate p = IndexQuery.stringSuffix((int)0, (TextValue)Values.stringValue((String)"less"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "lesser being"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "make less noise please..."));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "less"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "clueless"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "cluelessly clueless"));
    }

    private void assertFalseForOtherThings(IndexQuery p) {
        Assert.assertFalse((boolean)this.test(p, "other string"));
        Assert.assertFalse((boolean)this.test(p, "string1"));
        Assert.assertFalse((boolean)this.test(p, ""));
        Assert.assertFalse((boolean)this.test(p, -1));
        Assert.assertFalse((boolean)this.test(p, -1.0));
        Assert.assertFalse((boolean)this.test(p, false));
        Assert.assertFalse((boolean)this.test(p, new long[]{-1L}));
        Assert.assertFalse((boolean)this.test(p, null));
    }

    private boolean test(IndexQuery p, Object x) {
        return p.acceptsValue(x instanceof Value ? (Value)x : Values.of((Object)x));
    }
}

