/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.io.IOException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.CursorsClosedPostCondition;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.ManagedTestCursors;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;

public abstract class KernelAPIReadTestBase<ReadSupport extends KernelAPIReadTestSupport> {
    protected static final TemporaryFolder folder = new TemporaryFolder();
    protected static KernelAPIReadTestSupport testSupport;
    protected Transaction tx;
    protected Read read;
    protected ExplicitIndexRead indexRead;
    protected SchemaRead schemaRead;
    protected Token token;
    protected ManagedTestCursors cursors;
    @Rule
    public CursorsClosedPostCondition cursorsClosedPostCondition = new CursorsClosedPostCondition(() -> this.cursors);

    public abstract ReadSupport newTestSupport();

    public abstract void createTestGraph(GraphDatabaseService var1);

    @Before
    public void setupGraph() throws IOException, KernelException {
        if (testSupport == null) {
            folder.create();
            testSupport = this.newTestSupport();
            testSupport.setup(folder.getRoot(), this::createTestGraph);
        }
        Kernel kernel = testSupport.kernelToTest();
        this.tx = kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        this.token = this.tx.token();
        this.read = this.tx.dataRead();
        this.indexRead = this.tx.indexRead();
        this.schemaRead = this.tx.schemaRead();
        this.cursors = new ManagedTestCursors(this.tx.cursors());
    }

    protected Transaction beginTransaction() throws TransactionFailureException {
        Kernel kernel = testSupport.kernelToTest();
        return kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
    }

    @After
    public void closeTransaction() throws Exception {
        this.tx.success();
        this.tx.close();
    }

    @AfterClass
    public static void tearDown() {
        if (testSupport != null) {
            testSupport.tearDown();
            folder.delete();
            testSupport = null;
        }
    }
}

