/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;

public abstract class KernelAPIWriteTestBase<WriteSupport extends KernelAPIWriteTestSupport> {
    protected static final TemporaryFolder folder = new TemporaryFolder();
    protected static KernelAPIWriteTestSupport testSupport;
    protected static GraphDatabaseService graphDb;

    public abstract WriteSupport newTestSupport();

    @Before
    public void setupGraph() throws IOException {
        if (testSupport == null) {
            folder.create();
            testSupport = this.newTestSupport();
            testSupport.setup(folder.getRoot());
            graphDb = testSupport.graphBackdoor();
        }
        testSupport.clearGraph();
    }

    protected Transaction beginTransaction() throws TransactionFailureException {
        Kernel kernel = testSupport.kernelToTest();
        return kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
    }

    @AfterClass
    public static void tearDown() {
        if (testSupport != null) {
            testSupport.tearDown();
            folder.delete();
            testSupport = null;
        }
    }
}

