/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;

public abstract class LargeNodeCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static List<Long> NODE_IDS = new ArrayList<Long>();
    private static int N_NODES = 10000;
    private static Random random = new Random(2L);

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        ArrayList<Node> deleted = new ArrayList<Node>();
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < N_NODES; ++i) {
                Node node = graphDb.createNode();
                if (random.nextBoolean()) {
                    NODE_IDS.add(node.getId());
                    continue;
                }
                deleted.add(node);
            }
            tx.success();
        }
        tx = graphDb.beginTx();
        var4_4 = null;
        try {
            for (Node node : deleted) {
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldScanNodes() {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor();){
            this.read.allNodesScan(nodes);
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
        }
        Assert.assertEquals(NODE_IDS, ids);
    }

    @Test
    public void shouldAccessNodesByReference() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor();){
            for (long id : NODE_IDS) {
                this.read.singleNode(id, nodes);
                Assert.assertTrue((String)"should access defined node", (boolean)nodes.next());
                Assert.assertEquals((String)"should access the correct node", (long)id, (long)nodes.nodeReference());
                Assert.assertFalse((String)"should only access a single node", (boolean)nodes.next());
            }
        }
    }
}

