/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class LockingTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotBlockConstraintCreationOnUnrelatedPropertyWrite() throws Throwable {
        int label;
        int constraintProp;
        int nodeProp;
        try (Transaction tx = this.beginTransaction();){
            nodeProp = tx.tokenWrite().propertyKeyGetOrCreateForName("nodeProp");
            constraintProp = tx.tokenWrite().propertyKeyGetOrCreateForName("constraintProp");
            label = tx.tokenWrite().labelGetOrCreateForName("label");
            tx.success();
        }
        tx = this.beginTransaction();
        var5_2 = null;
        try {
            tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(label, constraintProp));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        CountDownLatch createNodeLatch = new CountDownLatch(1);
        CountDownLatch createConstraintLatch = new CountDownLatch(1);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future<?> f1 = executor.submit(() -> {
            try (Transaction tx = this.beginTransaction();){
                this.createNodeWithProperty(tx, nodeProp);
                createNodeLatch.countDown();
                Assert.assertTrue((boolean)createConstraintLatch.await(5L, TimeUnit.MINUTES));
                tx.success();
            }
            catch (Exception e) {
                Assert.fail((String)("Create node failed: " + e));
            }
            finally {
                createNodeLatch.countDown();
            }
        });
        Future<?> f2 = executor.submit(() -> {
            try (Transaction tx = this.beginTransaction();){
                Assert.assertTrue((boolean)createNodeLatch.await(5L, TimeUnit.MINUTES));
                tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(label, constraintProp));
                tx.success();
            }
            catch (KernelException e) {
                Assert.assertEquals((Object)Status.Schema.ConstraintAlreadyExists, (Object)e.status());
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted during create constraint");
            }
            finally {
                createConstraintLatch.countDown();
            }
        });
        try {
            f1.get();
            f2.get();
        }
        finally {
            executor.shutdown();
        }
    }

    private void createNodeWithProperty(Transaction tx, int propId1) throws KernelException {
        long node = tx.dataWrite().nodeCreate();
        tx.dataWrite().nodeSetProperty(node, propId1, (Value)Values.intValue((int)42));
    }

    protected abstract LabelSchemaDescriptor labelDescriptor(int var1, int ... var2);
}

