/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

public class ManagedTestCursors
implements CursorFactory {
    private List<Cursor> allCursors = new ArrayList<Cursor>();
    private CursorFactory cursors;

    ManagedTestCursors(CursorFactory c) {
        this.cursors = c;
    }

    void assertAllClosedAndReset() {
        for (Cursor n : this.allCursors) {
            if (n.isClosed()) continue;
            Assert.fail((String)("The Cursor " + n.toString() + " was not closed properly."));
        }
        this.allCursors.clear();
    }

    public NodeCursor allocateNodeCursor() {
        NodeCursor n = this.cursors.allocateNodeCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipScanCursor allocateRelationshipScanCursor() {
        RelationshipScanCursor n = this.cursors.allocateRelationshipScanCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        RelationshipTraversalCursor n = this.cursors.allocateRelationshipTraversalCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public PropertyCursor allocatePropertyCursor() {
        PropertyCursor n = this.cursors.allocatePropertyCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipGroupCursor allocateRelationshipGroupCursor() {
        RelationshipGroupCursor n = this.cursors.allocateRelationshipGroupCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor() {
        NodeValueIndexCursor n = this.cursors.allocateNodeValueIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor() {
        NodeLabelIndexCursor n = this.cursors.allocateNodeLabelIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeExplicitIndexCursor allocateNodeExplicitIndexCursor() {
        NodeExplicitIndexCursor n = this.cursors.allocateNodeExplicitIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipExplicitIndexCursor allocateRelationshipExplicitIndexCursor() {
        RelationshipExplicitIndexCursor n = this.cursors.allocateRelationshipExplicitIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }
}

