/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;

public abstract class NodeCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static List<Long> NODE_IDS;
    private static long foo;
    private static long bar;
    private static long baz;
    private static long barbaz;
    private static long bare;
    private static long gone;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        Node deleted;
        try (Transaction tx = graphDb.beginTx();){
            foo = graphDb.createNode(new Label[]{Label.label((String)"Foo")}).getId();
            bar = graphDb.createNode(new Label[]{Label.label((String)"Bar")}).getId();
            baz = graphDb.createNode(new Label[]{Label.label((String)"Baz")}).getId();
            barbaz = graphDb.createNode(new Label[]{Label.label((String)"Bar"), Label.label((String)"Baz")}).getId();
            deleted = graphDb.createNode();
            gone = deleted.getId();
            bare = graphDb.createNode().getId();
            tx.success();
        }
        tx = graphDb.beginTx();
        var4_3 = null;
        try {
            deleted.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        var4_3 = null;
        try {
            NODE_IDS = new ArrayList<Long>();
            for (Node node : graphDb.getAllNodes()) {
                NODE_IDS.add(node.getId());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldScanNodes() {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor();){
            this.read.allNodesScan(nodes);
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
        }
        Assert.assertEquals(NODE_IDS, ids);
    }

    @Test
    public void shouldAccessNodesByReference() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor();){
            for (long id : NODE_IDS) {
                this.read.singleNode(id, nodes);
                Assert.assertTrue((String)"should access defined node", (boolean)nodes.next());
                Assert.assertEquals((String)"should access the correct node", (long)id, (long)nodes.nodeReference());
                Assert.assertFalse((String)"should only access a single node", (boolean)nodes.next());
            }
        }
    }

    @Test
    public void shouldNotAccessNegativeReferences() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();){
            this.read.singleNode(-2L, node);
            Assert.assertFalse((String)"should not access negative reference node", (boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindDeletedNode() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor();){
            this.read.singleNode(gone, nodes);
            Assert.assertFalse((String)"should not access deleted node", (boolean)nodes.next());
        }
    }

    @Test
    public void shouldReadLabels() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor();){
            this.read.singleNode(foo, nodes);
            Assert.assertTrue((String)"should access defined node", (boolean)nodes.next());
            LabelSet labels = nodes.labels();
            Assert.assertEquals((String)"number of labels", (long)1L, (long)labels.numberOfLabels());
            int fooLabel = labels.label(0);
            Assert.assertTrue((boolean)nodes.hasLabel(fooLabel));
            Assert.assertFalse((String)"should only access a single node", (boolean)nodes.next());
            this.read.singleNode(bar, nodes);
            Assert.assertTrue((String)"should access defined node", (boolean)nodes.next());
            labels = nodes.labels();
            Assert.assertEquals((String)"number of labels", (long)1L, (long)labels.numberOfLabels());
            int barLabel = labels.label(0);
            Assert.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assert.assertTrue((boolean)nodes.hasLabel(barLabel));
            Assert.assertFalse((String)"should only access a single node", (boolean)nodes.next());
            this.read.singleNode(baz, nodes);
            Assert.assertTrue((String)"should access defined node", (boolean)nodes.next());
            labels = nodes.labels();
            Assert.assertEquals((String)"number of labels", (long)1L, (long)labels.numberOfLabels());
            int bazLabel = labels.label(0);
            Assert.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assert.assertFalse((boolean)nodes.hasLabel(barLabel));
            Assert.assertTrue((boolean)nodes.hasLabel(bazLabel));
            Assert.assertFalse((String)"should only access a single node", (boolean)nodes.next());
            Assert.assertNotEquals((String)"distinct labels", (long)fooLabel, (long)barLabel);
            Assert.assertNotEquals((String)"distinct labels", (long)fooLabel, (long)bazLabel);
            Assert.assertNotEquals((String)"distinct labels", (long)barLabel, (long)bazLabel);
            this.read.singleNode(barbaz, nodes);
            Assert.assertTrue((String)"should access defined node", (boolean)nodes.next());
            labels = nodes.labels();
            Assert.assertEquals((String)"number of labels", (long)2L, (long)labels.numberOfLabels());
            if (labels.label(0) == barLabel) {
                Assert.assertEquals((long)bazLabel, (long)labels.label(1));
            } else {
                Assert.assertEquals((long)bazLabel, (long)labels.label(0));
                Assert.assertEquals((long)barLabel, (long)labels.label(1));
            }
            Assert.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assert.assertTrue((boolean)nodes.hasLabel(barLabel));
            Assert.assertTrue((boolean)nodes.hasLabel(bazLabel));
            Assert.assertFalse((String)"should only access a single node", (boolean)nodes.next());
            this.read.singleNode(bare, nodes);
            Assert.assertTrue((String)"should access defined node", (boolean)nodes.next());
            labels = nodes.labels();
            Assert.assertEquals((String)"number of labels", (long)0L, (long)labels.numberOfLabels());
            Assert.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assert.assertFalse((boolean)nodes.hasLabel(barLabel));
            Assert.assertFalse((boolean)nodes.hasLabel(bazLabel));
            Assert.assertFalse((String)"should only access a single node", (boolean)nodes.next());
        }
    }
}

