/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Label;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public abstract class NodeIndexOrderTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Parameterized.Parameter
    public IndexOrder indexOrder;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{{IndexOrder.ASCENDING}});
    }

    @Test
    public void shouldRangeScanInOrder() throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "hello"));
            this.nodeWithProp(tx, "bellow");
            expected.add(this.nodeWithProp(tx, "schmello"));
            expected.add(this.nodeWithProp(tx, "low"));
            expected.add(this.nodeWithProp(tx, "trello"));
            this.nodeWithProp(tx, "yellow");
            expected.add(this.nodeWithProp(tx, "low"));
            this.nodeWithProp(tx, "below");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor();){
                this.nodeWithProp(tx, "allow");
                expected.add(this.nodeWithProp(tx, "now"));
                expected.add(this.nodeWithProp(tx, "jello"));
                this.nodeWithProp(tx, "willow");
                IndexQuery.RangePredicate query = IndexQuery.range((int)prop, (String)"hello", (boolean)true, (String)"trello", (boolean)true);
                tx.dataRead().nodeIndexSeek(index, cursor, this.indexOrder, true, new IndexQuery[]{query});
                this.assertResultsInOrder(expected, cursor);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPrefixScanInOrder() throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "bee hive"));
            this.nodeWithProp(tx, "a");
            expected.add(this.nodeWithProp(tx, "become"));
            expected.add(this.nodeWithProp(tx, "be"));
            expected.add(this.nodeWithProp(tx, "bachelor"));
            this.nodeWithProp(tx, "street smart");
            expected.add(this.nodeWithProp(tx, "builder"));
            this.nodeWithProp(tx, "ceasar");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor();){
                this.nodeWithProp(tx, "allow");
                expected.add(this.nodeWithProp(tx, "bastard"));
                expected.add(this.nodeWithProp(tx, "bully"));
                this.nodeWithProp(tx, "willow");
                IndexQuery.StringPrefixPredicate query = IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"b"));
                tx.dataRead().nodeIndexSeek(index, cursor, this.indexOrder, true, new IndexQuery[]{query});
                this.assertResultsInOrder(expected, cursor);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertResultsInOrder(List<Pair<Long, Value>> expected, NodeValueIndexCursor cursor) {
        Comparator comparator = this.indexOrder == IndexOrder.ASCENDING ? (a, b) -> Values.COMPARATOR.compare((Value)a.other(), (Value)b.other()) : (a, b) -> Values.COMPARATOR.compare((Value)b.other(), (Value)a.other());
        expected.sort(comparator);
        Iterator<Pair<Long, Value>> expectedRows = expected.iterator();
        while (cursor.next() && expectedRows.hasNext()) {
            Pair<Long, Value> expectedRow = expectedRows.next();
            Assert.assertThat((Object)cursor.nodeReference(), (Matcher)Matchers.equalTo((Object)expectedRow.first()));
            for (int i = 0; i < cursor.numberOfProperties(); ++i) {
                Value value = cursor.propertyValue(i);
                Assert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)expectedRow.other()));
            }
        }
        Assert.assertFalse((boolean)expectedRows.hasNext());
        Assert.assertFalse((boolean)cursor.next());
    }

    private void createIndex() {
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop").create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var2_2 = null;
        try {
            graphDb.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private Pair<Long, Value> nodeWithProp(Transaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName("Node"));
        Value val = Values.of((Object)value);
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)node, (Object)val);
    }
}

