/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.collector.Collectors2;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public abstract class NodeIndexTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Parameterized.Parameter
    public boolean needsValues;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void shouldPerformStringSuffixSearch() throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "1suff"));
            this.nodeWithProp(tx, "pluff");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "2suff"));
            this.nodeWithPropId(tx, "skruff");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            this.assertNodeAndValueForSeek(expected, tx, index, this.needsValues, "pasuff", new IndexQuery[]{IndexQuery.stringSuffix((int)prop, (TextValue)Values.stringValue((String)"suff"))});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformScan() throws Exception {
        long nodeToChange;
        long nodeToDelete;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "suff1"));
            expected.add(this.nodeWithProp(tx, "supp"));
            nodeToDelete = this.nodeWithPropId(tx, "supp");
            nodeToChange = this.nodeWithPropId(tx, "supper");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var7_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "suff2"));
            tx.dataWrite().nodeDelete(nodeToDelete);
            tx.dataWrite().nodeRemoveProperty(nodeToChange, prop);
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            this.assertNodeAndValueForScan(expected, tx, index, false, "noff");
        }
        catch (Throwable throwable) {
            var7_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformEqualitySeek() throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "banana"));
            this.nodeWithProp(tx, "apple");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "banana"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            this.assertNodeAndValueForSeek(expected, tx, index, false, "banana", new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"banana")});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformStringPrefixSearch() throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "suff1"));
            this.nodeWithPropId(tx, "supp");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "suff2"));
            this.nodeWithPropId(tx, "skruff");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            this.assertNodeAndValueForSeek(expected, tx, index, this.needsValues, "suffpa", new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"suff"))});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformStringRangeSearch() throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "banana"));
            this.nodeWithProp(tx, "apple");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            this.assertNodeAndValueForSeek(expected, tx, index, this.needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformStringRangeSearchWithAddedNodeInTxState() throws Exception {
        long nodeToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "banana"));
            nodeToChange = this.nodeWithPropId(tx, "apple");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var5_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            TextValue newProperty = Values.stringValue((String)"blueberry");
            tx.dataWrite().nodeSetProperty(nodeToChange, prop, (Value)newProperty);
            expected.add(Pair.of((Object)nodeToChange, (Object)newProperty));
            this.assertNodeAndValueForSeek(expected, tx, index, this.needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformStringRangeSearchWithRemovedNodeInTxState() throws Exception {
        long nodeToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            nodeToChange = this.nodeWithPropId(tx, "banana");
            this.nodeWithPropId(tx, "apple");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var5_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            TextValue newProperty = Values.stringValue((String)"kiwi");
            tx.dataWrite().nodeSetProperty(nodeToChange, prop, (Value)newProperty);
            this.assertNodeAndValueForSeek(expected, tx, index, this.needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformStringRangeSearchWithDeletedNodeInTxState() throws Exception {
        long nodeToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            nodeToChange = this.nodeWithPropId(tx, "banana");
            this.nodeWithPropId(tx, "apple");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var5_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            tx.dataWrite().nodeDelete(nodeToChange);
            this.assertNodeAndValueForSeek(expected, tx, index, this.needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPerformStringContainsSearch() throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (Transaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "gnomebat"));
            this.nodeWithPropId(tx, "fishwombat");
            tx.success();
        }
        this.createIndex();
        tx = this.beginTransaction();
        var3_3 = null;
        try {
            int label = tx.tokenRead().nodeLabel("Node");
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "homeopatic"));
            this.nodeWithPropId(tx, "telephonecompany");
            IndexReference index = tx.schemaRead().index(label, new int[]{prop});
            this.assertNodeAndValueForSeek(expected, tx, index, this.needsValues, "immense", new IndexQuery[]{IndexQuery.stringContains((int)prop, (TextValue)Values.stringValue((String)"me"))});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowIfTransactionTerminated() throws Exception {
        try (Transaction tx = this.beginTransaction();){
            this.terminate(tx);
            this.exception.expect(TransactionTerminatedException.class);
            tx.dataRead().nodeExists(42L);
        }
    }

    protected abstract void terminate(Transaction var1);

    private long nodeWithPropId(Transaction tx, Object value) throws Exception {
        return (Long)this.nodeWithProp(tx, value).first();
    }

    private Pair<Long, Value> nodeWithProp(Transaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName("Node"));
        Value val = Values.of((Object)value);
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)node, (Object)val);
    }

    private void createIndex() {
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop").create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var2_2 = null;
        try {
            graphDb.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertNodeAndValueForSeek(Set<Pair<Long, Value>> expected, Transaction tx, IndexReference index, boolean needsValues, Object anotherValueFoundByQuery, IndexQuery ... queries) throws Exception {
        try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor();){
            tx.dataRead().nodeIndexSeek(index, nodes, IndexOrder.NONE, needsValues, queries);
            this.assertNodeAndValue(expected, tx, needsValues, anotherValueFoundByQuery, nodes);
        }
    }

    private void assertNodeAndValueForScan(Set<Pair<Long, Value>> expected, Transaction tx, IndexReference index, boolean needsValues, Object anotherValueFoundByQuery) throws Exception {
        try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor();){
            tx.dataRead().nodeIndexScan(index, nodes, IndexOrder.NONE, needsValues);
            this.assertNodeAndValue(expected, tx, needsValues, anotherValueFoundByQuery, nodes);
        }
    }

    private void assertNodeAndValue(Set<Pair<Long, Value>> expected, Transaction tx, boolean needsValues, Object anotherValueFoundByQuery, NodeValueIndexCursor nodes) throws Exception {
        for (Pair<Long, Value> pair : expected) {
            tx.dataWrite().nodeDelete(((Long)pair.first()).longValue());
        }
        this.nodeWithPropId(tx, anotherValueFoundByQuery);
        if (needsValues) {
            HashSet<Pair> found = new HashSet<Pair>();
            while (nodes.next()) {
                found.add(Pair.of((Object)nodes.nodeReference(), (Object)nodes.propertyValue(0)));
            }
            Assert.assertThat(found, (Matcher)CoreMatchers.equalTo(expected));
        } else {
            HashSet<Long> foundIds = new HashSet<Long>();
            while (nodes.next()) {
                foundIds.add(nodes.nodeReference());
            }
            ImmutableSet expectedIds = (ImmutableSet)expected.stream().map(Pair::first).collect(Collectors2.toImmutableSet());
            Assert.assertThat(foundIds, (Matcher)CoreMatchers.equalTo((Object)expectedIds));
        }
    }
}

