/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTestSupport;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.exceptions.KernelException;

public abstract class RelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long bare;
    private static long start;
    private static long end;
    private static RelationshipTestSupport.StartNode sparse;
    private static RelationshipTestSupport.StartNode dense;

    protected boolean supportsDirectTraversal() {
        return true;
    }

    protected boolean supportsSparseNodes() {
        return true;
    }

    private static void bareStartAndEnd(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            bare = graphDb.createNode().getId();
            Node x = graphDb.createNode();
            Node y = graphDb.createNode();
            start = x.getId();
            end = y.getId();
            x.createRelationshipTo(y, RelationshipType.withName((String)"GEN"));
            tx.success();
        }
    }

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        RelationshipTestSupport.someGraph(graphDb);
        RelationshipTraversalCursorTestBase.bareStartAndEnd(graphDb);
        sparse = RelationshipTestSupport.sparse(graphDb);
        dense = RelationshipTestSupport.dense(graphDb);
    }

    @Test
    public void shouldNotAccessGroupsOfBareNode() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();){
            this.read.singleNode(bare, node);
            Assert.assertTrue((String)"access node", (boolean)node.next());
            node.relationships(group);
            Assert.assertFalse((String)"access group", (boolean)group.next());
        }
    }

    @Test
    public void shouldTraverseRelationshipsOfGivenType() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            int empty = 0;
            this.read.allNodesScan(node);
            while (node.next()) {
                node.relationships(group);
                boolean none = true;
                while (group.next()) {
                    none = false;
                    Sizes degree = new Sizes();
                    group.outgoing(relationship);
                    while (relationship.next()) {
                        Assert.assertEquals((String)("node #" + node.nodeReference() + " relationship should have same label as group"), (long)group.type(), (long)relationship.type());
                        ++degree.outgoing;
                    }
                    group.incoming(relationship);
                    while (relationship.next()) {
                        Assert.assertEquals((String)("node #" + node.nodeReference() + "relationship should have same label as group"), (long)group.type(), (long)relationship.type());
                        ++degree.incoming;
                    }
                    group.loops(relationship);
                    while (relationship.next()) {
                        Assert.assertEquals((String)("node #" + node.nodeReference() + "relationship should have same label as group"), (long)group.type(), (long)relationship.type());
                        ++degree.loop;
                    }
                    Assert.assertNotEquals((String)"all", (long)0L, (long)(degree.incoming + degree.outgoing + degree.loop));
                    Assert.assertEquals((String)("node #" + node.nodeReference() + " outgoing"), (long)group.outgoingCount(), (long)degree.outgoing);
                    Assert.assertEquals((String)("node #" + node.nodeReference() + " incoming"), (long)group.incomingCount(), (long)degree.incoming);
                    Assert.assertEquals((String)("node #" + node.nodeReference() + " loop"), (long)group.loopCount(), (long)degree.loop);
                    Assert.assertEquals((String)("node #" + node.nodeReference() + " all = incoming + outgoing - loop"), (long)group.totalCount(), (long)(degree.incoming + degree.outgoing + degree.loop));
                }
                if (!none) continue;
                ++empty;
            }
            Assert.assertEquals((String)"number of empty nodes", (long)1L, (long)empty);
        }
    }

    @Test
    public void shouldFollowSpecificRelationship() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            this.read.singleNode(start, node);
            Assert.assertTrue((String)"access start node", (boolean)node.next());
            node.relationships(group);
            Assert.assertTrue((String)"access relationship group", (boolean)group.next());
            group.outgoing(relationship);
            Assert.assertTrue((String)"access outgoing relationships", (boolean)relationship.next());
            Assert.assertEquals((String)"source node", (long)start, (long)relationship.sourceNodeReference());
            Assert.assertEquals((String)"target node", (long)end, (long)relationship.targetNodeReference());
            Assert.assertEquals((String)"node of origin", (long)start, (long)relationship.originNodeReference());
            Assert.assertEquals((String)"neighbouring node", (long)end, (long)relationship.neighbourNodeReference());
            Assert.assertEquals((String)"relationship should have same label as group", (long)group.type(), (long)relationship.type());
            Assert.assertFalse((String)"only a single relationship", (boolean)relationship.next());
            group.incoming(relationship);
            Assert.assertFalse((String)"no incoming relationships", (boolean)relationship.next());
            group.loops(relationship);
            Assert.assertFalse((String)"no loop relationships", (boolean)relationship.next());
            Assert.assertFalse((String)"only a single group", (boolean)group.next());
            this.read.singleNode(end, node);
            Assert.assertTrue((String)"access start node", (boolean)node.next());
            node.relationships(group);
            Assert.assertTrue((String)"access relationship group", (boolean)group.next());
            group.incoming(relationship);
            Assert.assertTrue((String)"access incoming relationships", (boolean)relationship.next());
            Assert.assertEquals((String)"source node", (long)start, (long)relationship.sourceNodeReference());
            Assert.assertEquals((String)"target node", (long)end, (long)relationship.targetNodeReference());
            Assert.assertEquals((String)"node of origin", (long)end, (long)relationship.originNodeReference());
            Assert.assertEquals((String)"neighbouring node", (long)start, (long)relationship.neighbourNodeReference());
            Assert.assertEquals((String)"relationship should have same label as group", (long)group.type(), (long)relationship.type());
            Assert.assertFalse((String)"only a single relationship", (boolean)relationship.next());
            group.outgoing(relationship);
            Assert.assertFalse((String)"no outgoing relationships", (boolean)relationship.next());
            group.loops(relationship);
            Assert.assertFalse((String)"no loop relationships", (boolean)relationship.next());
            Assert.assertFalse((String)"only a single group", (boolean)group.next());
        }
    }

    @Test
    public void shouldHaveBeenAbleToCreateDenseAndSparseNodes() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();){
            this.read.singleNode(RelationshipTraversalCursorTestBase.dense.id, node);
            Assert.assertTrue((String)"access dense node", (boolean)node.next());
            Assert.assertTrue((String)"dense node", (boolean)node.isDense());
            this.read.singleNode(RelationshipTraversalCursorTestBase.sparse.id, node);
            Assert.assertTrue((String)"access sparse node", (boolean)node.next());
            Assert.assertFalse((String)"sparse node", (node.isDense() && this.supportsSparseNodes() ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldTraverseSparseNodeViaGroups() throws Exception {
        this.traverseViaGroups(sparse, false);
    }

    @Test
    public void shouldTraverseDenseNodeViaGroups() throws Exception {
        this.traverseViaGroups(dense, false);
    }

    @Test
    public void shouldTraverseSparseNodeViaGroupsWithDetachedReferences() throws Exception {
        this.traverseViaGroups(sparse, true);
    }

    @Test
    public void shouldTraverseDenseNodeViaGroupsWithDetachedReferences() throws Exception {
        this.traverseViaGroups(dense, true);
    }

    @Test
    public void shouldTraverseSparseNodeWithoutGroups() throws Exception {
        Assume.assumeTrue((this.supportsSparseNodes() && this.supportsDirectTraversal() ? 1 : 0) != 0);
        this.traverseWithoutGroups(sparse, false);
    }

    @Test
    public void shouldTraverseDenseNodeWithoutGroups() throws Exception {
        Assume.assumeTrue((boolean)this.supportsDirectTraversal());
        this.traverseWithoutGroups(dense, false);
    }

    @Test
    public void shouldTraverseSparseNodeWithoutGroupsWithDetachedReferences() throws Exception {
        Assume.assumeTrue((boolean)this.supportsSparseNodes());
        this.traverseWithoutGroups(sparse, true);
    }

    @Test
    public void shouldTraverseDenseNodeWithoutGroupsWithDetachedReferences() throws Exception {
        Assume.assumeTrue((boolean)this.supportsDirectTraversal());
        this.traverseWithoutGroups(dense, true);
    }

    private void traverseViaGroups(RelationshipTestSupport.StartNode start, boolean detached) throws KernelException {
        Map<String, Integer> expectedCounts = start.expectedCounts();
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            this.read.singleNode(start.id, node);
            Assert.assertTrue((String)"access node", (boolean)node.next());
            if (detached) {
                this.read.relationshipGroups(start.id, node.relationshipGroupReference(), group);
            } else {
                node.relationships(group);
            }
            while (group.next()) {
                if (detached) {
                    this.read.relationships(start.id, group.outgoingReference(), relationship);
                } else {
                    group.outgoing(relationship);
                }
                RelationshipTestSupport.assertCount(this.tx, relationship, expectedCounts, group.type(), Direction.OUTGOING);
                if (detached) {
                    this.read.relationships(start.id, group.incomingReference(), relationship);
                } else {
                    group.incoming(relationship);
                }
                RelationshipTestSupport.assertCount(this.tx, relationship, expectedCounts, group.type(), Direction.INCOMING);
                if (detached) {
                    this.read.relationships(start.id, group.loopsReference(), relationship);
                } else {
                    group.loops(relationship);
                }
                RelationshipTestSupport.assertCount(this.tx, relationship, expectedCounts, group.type(), Direction.BOTH);
            }
        }
    }

    private void traverseWithoutGroups(RelationshipTestSupport.StartNode start, boolean detached) throws KernelException {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            this.read.singleNode(start.id, node);
            Assert.assertTrue((String)"access node", (boolean)node.next());
            if (detached) {
                this.read.relationships(start.id, node.allRelationshipsReference(), relationship);
            } else {
                node.allRelationships(relationship);
            }
            Map<String, Integer> counts = RelationshipTestSupport.count(this.tx, relationship);
            RelationshipTestSupport.assertCounts(start.expectedCounts(), counts);
        }
    }

    private static class Sizes {
        int incoming;
        int outgoing;
        int loop;

        private Sizes() {
        }
    }
}

