/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;

public abstract class TokenTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    public void labelGetOrCreateForName() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForName("")));
        int id = this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.labelGetOrCreateForName("label")));
        Assert.assertEquals((long)id, (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.nodeLabel("label"))));
    }

    @Test
    public void labelGetOrCreateForNames() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForNames(new String[]{null}, new int[1])));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForNames(new String[]{""}, new int[1])));
        String[] names = new String[]{"a", "b"};
        int[] ids = new int[2];
        this.forToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForNames(names, ids)));
        Assert.assertEquals((long)ids[0], (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.nodeLabel("a"))));
        Assert.assertEquals((long)ids[1], (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.nodeLabel("b"))));
    }

    @Test
    public void propertyKeyGetOrCreateForName() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForName("")));
        int id = this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKeyGetOrCreateForName("prop")));
        Assert.assertEquals((long)id, (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKey("prop"))));
    }

    @Test
    public void propertyKeyGetOrCreateForNames() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForNames(new String[]{null}, new int[1])));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForNames(new String[]{""}, new int[1])));
        String[] names = new String[]{"a", "b"};
        int[] ids = new int[2];
        this.forToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForNames(names, ids)));
        Assert.assertEquals((long)ids[0], (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKey("a"))));
        Assert.assertEquals((long)ids[1], (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKey("b"))));
    }

    @Test
    public void relationshipTypeGetOrCreateForName() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForName("")));
        int id = this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipTypeGetOrCreateForName("rel")));
        Assert.assertEquals((long)id, (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipType("rel"))));
    }

    @Test
    public void relationshipTypeGetOrCreateForNames() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForNames(new String[]{null}, new int[1])));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForNames(new String[]{""}, new int[1])));
        String[] names = new String[]{"a", "b"};
        int[] ids = new int[2];
        this.forToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForNames(names, ids)));
        Assert.assertEquals((long)ids[0], (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipType("a"))));
        Assert.assertEquals((long)ids[1], (long)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipType("b"))));
    }

    private void assertIllegalToken(ThrowingConsumer<Token, KernelException> f) {
        try (Transaction tx2 = this.beginTransaction();){
            f.accept((Object)tx2.token());
            Assert.fail((String)"Expected IllegalTokenNameException");
        }
        catch (IllegalTokenNameException tx2) {
        }
        catch (KernelException e) {
            Assert.fail((String)("Unwanted exception: " + e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int mapToken(ThrowingFunction<Token, Integer, KernelException> f) {
        try (Transaction tx = this.beginTransaction();){
            int n = (Integer)f.apply((Object)tx.token());
            return n;
        }
        catch (KernelException e) {
            Assert.fail((String)("Unwanted exception: " + e.getMessage()));
            return -1;
        }
    }

    private void forToken(ThrowingConsumer<Token, KernelException> f) {
        try (Transaction tx = this.beginTransaction();){
            f.accept((Object)tx.token());
        }
        catch (KernelException e) {
            Assert.fail((String)("Unwanted exception: " + e.getMessage()));
        }
    }
}

