/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.values.storable.Values;

public abstract class TransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    public void shouldDetectNodeDeletedInTransaction() throws Exception {
        long unaffected;
        long deletedInTx;
        try (Transaction tx = this.beginTransaction();){
            deletedInTx = tx.dataWrite().nodeCreate();
            unaffected = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.beginTransaction();
        var10_2 = null;
        try {
            long addedInTx = tx.dataWrite().nodeCreate();
            long addedAndRemovedInTx = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeDelete(deletedInTx);
            tx.dataWrite().nodeDelete(addedAndRemovedInTx);
            Assert.assertFalse((boolean)tx.dataRead().nodeDeletedInTransaction(addedInTx));
            Assert.assertFalse((boolean)tx.dataRead().nodeDeletedInTransaction(unaffected));
            Assertions.assertTrue((boolean)tx.dataRead().nodeDeletedInTransaction(addedAndRemovedInTx));
            Assertions.assertTrue((boolean)tx.dataRead().nodeDeletedInTransaction(deletedInTx));
        }
        catch (Throwable throwable) {
            var10_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var10_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var10_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldDetectRelationshipDeletedInTransaction() throws Exception {
        long unaffected;
        long deletedInTx;
        int relType;
        long node;
        try (Transaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            relType = tx.tokenWrite().relationshipTypeCreateForName("REL_TYPE");
            deletedInTx = tx.dataWrite().relationshipCreate(node, relType, node);
            unaffected = tx.dataWrite().relationshipCreate(node, relType, node);
            tx.success();
        }
        tx = this.beginTransaction();
        var13_2 = null;
        try {
            long addedInTx = tx.dataWrite().relationshipCreate(node, relType, node);
            long addedAndRemovedInTx = tx.dataWrite().relationshipCreate(node, relType, node);
            tx.dataWrite().relationshipDelete(deletedInTx);
            tx.dataWrite().relationshipDelete(addedAndRemovedInTx);
            Assert.assertFalse((boolean)tx.dataRead().relationshipDeletedInTransaction(addedInTx));
            Assert.assertFalse((boolean)tx.dataRead().relationshipDeletedInTransaction(unaffected));
            Assertions.assertTrue((boolean)tx.dataRead().relationshipDeletedInTransaction(addedAndRemovedInTx));
            Assertions.assertTrue((boolean)tx.dataRead().relationshipDeletedInTransaction(deletedInTx));
        }
        catch (Throwable throwable) {
            var13_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var13_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var13_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldReportInTransactionNodeProperty() throws Exception {
        int p5;
        int p4;
        int p3;
        int p2;
        int p1;
        long node;
        try (Transaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            p1 = tx.tokenWrite().propertyKeyCreateForName("p1");
            p2 = tx.tokenWrite().propertyKeyCreateForName("p2");
            p3 = tx.tokenWrite().propertyKeyCreateForName("p3");
            p4 = tx.tokenWrite().propertyKeyCreateForName("p4");
            p5 = tx.tokenWrite().propertyKeyCreateForName("p5");
            tx.dataWrite().nodeSetProperty(node, p1, Values.of((Object)1));
            tx.dataWrite().nodeSetProperty(node, p3, Values.of((Object)3));
            tx.dataWrite().nodeSetProperty(node, p4, Values.of((Object)4));
            tx.success();
        }
        tx = this.beginTransaction();
        var9_2 = null;
        try {
            tx.dataWrite().nodeSetProperty(node, p3, Values.of((Object)13));
            tx.dataWrite().nodeRemoveProperty(node, p4);
            tx.dataWrite().nodeSetProperty(node, p5, Values.of((Object)15));
            Assert.assertNull((String)"Unchanged existing property is null", (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p1));
            Assert.assertNull((String)"Unchanged missing property is null", (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p2));
            Assert.assertEquals((String)"Changed property is new value", (Object)Values.of((Object)13), (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p3));
            Assert.assertEquals((String)"Removed property is NO_VALUE", (Object)Values.NO_VALUE, (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p4));
            Assert.assertEquals((String)"Added property is new value", (Object)Values.of((Object)15), (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p5));
        }
        catch (Throwable throwable) {
            var9_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

