/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.concurrent.TimeoutException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.helpers.Indexes;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class IndexesTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final Register.DoubleLongRegister register = Registers.newDoubleLongRegister();

    @Test
    public void shouldNotTimeOutIfNoIndexes() throws Throwable {
        SchemaRead schemaRead = this.schemaWithIndexes(new IndexReference[0]);
        Indexes.awaitResampling((SchemaRead)schemaRead, (long)0L);
    }

    @Test
    public void shouldNotTimeOutIfNoUpdates() throws Throwable {
        IndexReference index = (IndexReference)Mockito.mock(IndexReference.class);
        SchemaRead schemaRead = this.schemaWithIndexes(index);
        this.setUpdates(schemaRead, 0);
        Indexes.awaitResampling((SchemaRead)schemaRead, (long)0L);
    }

    @Test
    public void shouldAwaitIndexResampling() throws Throwable {
        IndexReference index = (IndexReference)Mockito.mock(IndexReference.class);
        SchemaRead schemaRead = this.schemaWithIndexes(index);
        this.setUpdates(schemaRead, 1, 2, 3, 0);
        Indexes.awaitResampling((SchemaRead)schemaRead, (long)60L);
    }

    @Test
    public void shouldAwaitIndexResamplingForHeavyLoad() throws Throwable {
        IndexReference index = (IndexReference)Mockito.mock(IndexReference.class);
        SchemaRead schemaRead = this.schemaWithIndexes(index);
        this.setUpdates(schemaRead, 1, 2, 3, 2);
        Indexes.awaitResampling((SchemaRead)schemaRead, (long)60L);
    }

    @Test
    public void shouldTimeout() throws Throwable {
        IndexReference index = (IndexReference)Mockito.mock(IndexReference.class);
        SchemaRead schemaRead = this.schemaWithIndexes(index);
        this.setUpdates(schemaRead, 1, 1, 1);
        this.exception.expect(TimeoutException.class);
        Indexes.awaitResampling((SchemaRead)schemaRead, (long)1L);
    }

    private SchemaRead schemaWithIndexes(IndexReference ... indexes) {
        SchemaRead schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
        Mockito.when((Object)schemaRead.indexesGetAll()).thenReturn((Object)Iterators.iterator((Object[])indexes));
        return schemaRead;
    }

    private void setUpdates(SchemaRead schemaRead, final int ... updates) throws IndexNotFoundKernelException {
        Mockito.when((Object)schemaRead.indexUpdatesAndSize((IndexReference)ArgumentMatchers.any(IndexReference.class), (Register.DoubleLongRegister)ArgumentMatchers.any(Register.DoubleLongRegister.class))).thenAnswer((Answer)new Answer<Register.DoubleLongRegister>(){
            private int i;

            public Register.DoubleLongRegister answer(InvocationOnMock invocationOnMock) throws Throwable {
                Register.DoubleLongRegister r = (Register.DoubleLongRegister)invocationOnMock.getArgument(1);
                r.write((long)updates[this.i], 0L);
                this.i = (this.i + 1) % updates.length;
                return r;
            }
        });
    }
}

