/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class PopulationProgressTest {
    @Inject
    protected RandomRule random;

    PopulationProgressTest() {
    }

    @Test
    void shouldCalculateProgressOfSingle() {
        PopulationProgress populationProgress = PopulationProgress.single((long)50L, (long)100L);
        float progress = populationProgress.getProgress();
        Assertions.assertEquals((float)0.5f, (float)progress);
    }

    @Test
    void shouldCalculateProgressOfMultipleEquallyWeightedProgresses() {
        PopulationProgress part1 = PopulationProgress.single((long)1L, (long)1L);
        PopulationProgress part2 = PopulationProgress.single((long)4L, (long)10L);
        PopulationProgress multi = PopulationProgress.multiple().add(part1, 1.0f).add(part2, 1.0f).build();
        float progress = multi.getProgress();
        Assertions.assertEquals((float)0.7f, (float)progress);
    }

    @Test
    void shouldCalculateProgressOfMultipleDifferentlyWeightedProgresses() {
        PopulationProgress part1 = PopulationProgress.single((long)1L, (long)3L);
        PopulationProgress part2 = PopulationProgress.single((long)4L, (long)10L);
        PopulationProgress multi = PopulationProgress.multiple().add(part1, 3.0f).add(part2, 1.0f).build();
        float progress = multi.getProgress();
        Assertions.assertEquals((float)0.35f, (float)progress);
    }

    @Test
    void shouldAlwaysResultInFullyCompleted() {
        int partCount = this.random.nextInt(5, 10);
        PopulationProgress.MultiBuilder builder = PopulationProgress.multiple();
        for (int i = 0; i < partCount; ++i) {
            long total = this.random.nextLong(10000000L);
            builder.add(PopulationProgress.single((long)total, (long)total), this.random.nextFloat() * (float)this.random.nextInt(1, 10));
        }
        PopulationProgress populationProgress = builder.build();
        float progress = populationProgress.getProgress();
        Assertions.assertEquals((float)1.0f, (float)progress);
    }

    @Test
    void shouldCalculateProgressForNestedMultipleParts() {
        PopulationProgress multiPart1 = PopulationProgress.multiple().add(PopulationProgress.single((long)1L, (long)1L), 1.0f).add(PopulationProgress.single((long)1L, (long)5L), 1.0f).build();
        Assertions.assertEquals((float)0.6f, (float)multiPart1.getProgress());
        PopulationProgress multiPart2 = PopulationProgress.multiple().add(PopulationProgress.single((long)6L, (long)10L), 1.0f).add(PopulationProgress.single((long)1L, (long)5L), 1.0f).build();
        Assertions.assertEquals((float)0.4f, (float)multiPart2.getProgress());
        PopulationProgress.MultiBuilder builder = PopulationProgress.multiple();
        PopulationProgress all = builder.add(multiPart1, 1.0f).add(multiPart2, 1.0f).build();
        Assertions.assertEquals((double)0.5, (double)all.getProgress());
    }
}

