/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Arrays;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class IndexQueryTest {
    private final int propId = 0;
    private final PointValue gps1 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-12.6, -56.7});
    private final PointValue gps2 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-12.6, -55.7});
    private final PointValue gps3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-11.0, -55.0});
    private final PointValue gps4 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
    private final PointValue gps5 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{14.6, 56.7});
    private final PointValue gps6 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{14.6, 58.7});
    private final PointValue gps7 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.6, 59.7});
    private final PointValue car1 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0});
    private final PointValue car2 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{2.0, 2.0});
    private final PointValue car3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 2.0, 3.0});
    private final PointValue car4 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{2.0, 3.0, 4.0});
    private final PointValue gps1_3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.6, 56.8, 100.0});
    private final PointValue gps2_3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.8, 56.9, 200.0});

    IndexQueryTest() {
    }

    @Test
    void testAll() {
        PropertyIndexQuery.AllEntriesPredicate allEntries = PropertyIndexQuery.allEntries();
        Stream.of(999, Arrays.array((Object[])new Integer[]{-999, 999}), "foo", Arrays.array((Object[])new String[]{"foo", "bar"}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.994807, 55.612088}), Arrays.array((Object[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.994807, 55.612088}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-0.101008, 51.503773})}), ZonedDateTime.now(), Arrays.array((Object[])new ZonedDateTime[]{ZonedDateTime.now(), ZonedDateTime.now().plusWeeks(2L)}), true, Arrays.array((Object[])new Boolean[]{false, true})).map(value -> IndexQueryTest.test((PropertyIndexQuery)allEntries, value)).forEach(org.junit.jupiter.api.Assertions::assertTrue);
    }

    @Test
    void testExists() {
        PropertyIndexQuery.ExistsPredicate p = PropertyIndexQuery.exists((int)0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "string"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 1.0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, true));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, new long[]{1L}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, null));
    }

    @Test
    void testExact() {
        this.assertExactPredicate("string");
        this.assertExactPredicate(1);
        this.assertExactPredicate(1.0);
        this.assertExactPredicate(true);
        this.assertExactPredicate(new long[]{1L});
        this.assertExactPredicate(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
    }

    private void assertExactPredicate(Object value) {
        PropertyIndexQuery.ExactPredicate p = PropertyIndexQuery.exact((int)0, (Object)value);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, value));
        IndexQueryTest.assertFalseForOtherThings((PropertyIndexQuery)p);
    }

    @Test
    void testExact_ComparingBigDoublesAndLongs() {
        PropertyIndexQuery.ExactPredicate p = PropertyIndexQuery.exact((int)0, (Object)0x20000000000001L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 9.007199254740992E15));
    }

    @Test
    void testNumRange_FalseForIrrelevant() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)true);
        IndexQueryTest.assertFalseForOtherThings((PropertyIndexQuery)p);
    }

    @Test
    void testNumRange_InclusiveLowerInclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 10));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 11));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 12));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 13));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 14));
    }

    @Test
    void testNumRange_ExclusiveLowerExclusiveLower() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Number)11, (boolean)false, (Number)13, (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 11));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 12));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 13));
    }

    @Test
    void testNumRange_InclusiveLowerExclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 10));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 11));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 12));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 13));
    }

    @Test
    void testNumRange_ExclusiveLowerInclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Number)11, (boolean)false, (Number)13, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 11));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 12));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 13));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 14));
    }

    @Test
    void testNumRange_LowerNullValue() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, null, (boolean)true, (Number)13, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 10));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 11));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 12));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 13));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 14));
    }

    @Test
    void testNumRange_UpperNullValue() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Number)11, (boolean)true, null, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 10));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 11));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 12));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 13));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 14));
    }

    @Test
    void testNumRange_ComparingBigDoublesAndLongs() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Number)0x20000000000001L, (boolean)true, null, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, 9.007199254740992E15));
    }

    @Test
    void testStringRange_FalseForIrrelevant() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        IndexQueryTest.assertFalseForOtherThings((PropertyIndexQuery)p);
    }

    @Test
    void testStringRange_InclusiveLowerInclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bba"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbb"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bee"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "beea"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bef"));
    }

    @Test
    void testStringRange_ExclusiveLowerInclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (String)"bbb", (boolean)false, (String)"bee", (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbb"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbba"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bee"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "beea"));
    }

    @Test
    void testStringRange_InclusiveLowerExclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bba"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbb"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bed"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bee"));
    }

    @Test
    void testStringRange_ExclusiveLowerExclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (String)"bbb", (boolean)false, (String)"bee", (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbb"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbba"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bed"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bee"));
    }

    @Test
    void testStringRange_UpperUnbounded() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (String)"bbb", (boolean)false, null, (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbb"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bbba"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "xxxxx"));
    }

    @Test
    void testStringRange_LowerUnbounded() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, null, (boolean)false, (String)"bee", (boolean)false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, ""));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bed"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bee"));
    }

    @Test
    void testGeometryRange_FalseForIrrelevant() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.gps2, (boolean)true, (Value)this.gps5, (boolean)true);
        IndexQueryTest.assertFalseForOtherThings((PropertyIndexQuery)p);
    }

    @Test
    void testGeometryRange_InclusiveLowerInclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.gps2, (boolean)true, (Value)this.gps5, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps6));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps7));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
    }

    @Test
    void testGeometryRange_ExclusiveLowerInclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.gps2, (boolean)false, (Value)this.gps5, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps6));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
    }

    @Test
    void testGeometryRange_InclusiveLowerExclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.gps2, (boolean)true, (Value)this.gps5, (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
    }

    @Test
    void testGeometryRange_ExclusiveLowerExclusiveUpper() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.gps2, (boolean)false, (Value)this.gps5, (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps4));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
    }

    @Test
    void testGeometryRange_UpperUnbounded() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.gps2, (boolean)false, null, (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps7));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
    }

    @Test
    void testGeometryRange_LowerUnbounded() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, null, (boolean)false, (Value)this.gps5, (boolean)false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
    }

    @Test
    void testGeometryRange_Cartesian() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.car1, (boolean)false, (Value)this.car2, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car4));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2_3d));
    }

    @Test
    void testGeometryRange_Cartesian3D() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.car3, (boolean)true, (Value)this.car4, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car4));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2_3d));
    }

    @Test
    void testGeometryRange_WGS84_3D() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)this.gps1_3d, (boolean)true, (Value)this.gps2_3d, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car4));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2_3d));
    }

    @Test
    void testDateRange() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (Value)DateValue.date((int)2014, (int)7, (int)7), (boolean)true, (Value)DateValue.date((int)2017, (int)3, (int)7), (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)2014, (int)6, (int)8)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)2014, (int)7, (int)7)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)2016, (int)6, (int)8)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)2017, (int)3, (int)7)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)2017, (int)3, (int)8)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, LocalDateTimeValue.localDateTime((int)2016, (int)3, (int)8, (int)0, (int)0, (int)0, (int)0)));
    }

    @Test
    void testValueGroupRange() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (ValueGroup)ValueGroup.DATE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)-4000, (int)1, (int)31)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)2018, (int)3, (int)7)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateTimeValue.datetime((int)2018, (int)3, (int)7, (int)0, (int)0, (int)0, (int)0, (ZoneId)ZoneOffset.UTC)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, Values.stringValue((String)"hej")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2_3d));
    }

    @Test
    void testCRSRange() {
        PropertyIndexQuery.RangePredicate p = PropertyIndexQuery.range((int)0, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, DateValue.date((int)-4000, (int)1, (int)31)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, Values.stringValue((String)"hej")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.car4));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, this.gps1_3d));
    }

    @Test
    void testStringPrefix_FalseForIrrelevant() {
        PropertyIndexQuery.StringPrefixPredicate p = PropertyIndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"dog"));
        IndexQueryTest.assertFalseForOtherThings((PropertyIndexQuery)p);
    }

    @Test
    void testStringPrefix_SomeValues() {
        PropertyIndexQuery.StringPrefixPredicate p = PropertyIndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"dog"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "doffington"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "doh, not this again!"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "dog"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "doggidog"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "doggidogdog"));
    }

    @Test
    void testStringContains_FalseForIrrelevant() {
        PropertyIndexQuery.StringContainsPredicate p = PropertyIndexQuery.stringContains((int)0, (TextValue)Values.stringValue((String)"cat"));
        IndexQueryTest.assertFalseForOtherThings((PropertyIndexQuery)p);
    }

    @Test
    void testStringContains_SomeValues() {
        PropertyIndexQuery.StringContainsPredicate p = PropertyIndexQuery.stringContains((int)0, (TextValue)Values.stringValue((String)"cat"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "dog"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "cameraman"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "Cat"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "cat"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "bobcat"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "scatman"));
    }

    @Test
    void testStringSuffix_FalseForIrrelevant() {
        PropertyIndexQuery.StringSuffixPredicate p = PropertyIndexQuery.stringSuffix((int)0, (TextValue)Values.stringValue((String)"less"));
        IndexQueryTest.assertFalseForOtherThings((PropertyIndexQuery)p);
    }

    @Test
    void testStringSuffix_SomeValues() {
        PropertyIndexQuery.StringSuffixPredicate p = PropertyIndexQuery.stringSuffix((int)0, (TextValue)Values.stringValue((String)"less"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "lesser being"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "make less noise please..."));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "less"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "clueless"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)IndexQueryTest.test((PropertyIndexQuery)p, "cluelessly clueless"));
    }

    @Test
    void testValueCategoryOfTokenPredicate() {
        TokenPredicate query = new TokenPredicate(1);
        Assertions.assertThat((Comparable)query.valueCategory()).isEqualTo((Object)ValueCategory.NO_CATEGORY);
    }

    @Test
    void testIndexQueryTypeOfTokenPredicate() {
        TokenPredicate query = new TokenPredicate(1);
        Assertions.assertThat((Comparable)query.type()).isEqualTo((Object)IndexQuery.IndexQueryType.TOKEN_LOOKUP);
    }

    private static void assertFalseForOtherThings(PropertyIndexQuery p) {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, "other string"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, "string1"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, ""));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, -1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, -1.0));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, new long[]{-1L}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IndexQueryTest.test(p, null));
    }

    private static boolean test(PropertyIndexQuery p, Object x) {
        return p.acceptsValue(x instanceof Value ? (Value)x : Values.of((Object)x));
    }
}

