/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;

class PrivilegeActionTest {
    private static final Map<PrivilegeAction, Set<PrivilegeAction>> expected = new HashMap<PrivilegeAction, Set<PrivilegeAction>>();

    PrivilegeActionTest() {
    }

    @Test
    void shouldSatisfySelf() {
        for (PrivilegeAction action : PrivilegeAction.values()) {
            Assertions.assertTrue((boolean)action.satisfies(action));
        }
    }

    @Test
    void shouldSatisfyAtAllLevels() {
        for (PrivilegeAction groupAction : expected.keySet()) {
            PrivilegeActionTest.assertGroupSatisfies(groupAction, expected.get(groupAction));
        }
    }

    static void assertGroupSatisfies(PrivilegeAction group, Set<PrivilegeAction> actions) {
        for (PrivilegeAction action : actions) {
            if (expected.containsKey(action)) {
                PrivilegeActionTest.assertGroupSatisfies(group, expected.get(action));
            }
            Assertions.assertTrue((boolean)group.satisfies(action), (String)String.format("%s should satisfy %s", group, action));
        }
    }

    @Test
    void shouldNotSatisfy() {
        for (PrivilegeAction action : PrivilegeAction.values()) {
            for (PrivilegeAction notSatisfied : PrivilegeActionTest.notChild(action)) {
                Assertions.assertFalse((boolean)action.satisfies(notSatisfied), (String)String.format("%s should not satisfy %s", action, notSatisfied));
            }
        }
    }

    private static Set<PrivilegeAction> notChild(PrivilegeAction action) {
        HashSet<PrivilegeAction> notChildren = new HashSet<PrivilegeAction>(Arrays.asList(PrivilegeAction.values()));
        PrivilegeActionTest.removeChildren(action, notChildren);
        return notChildren;
    }

    private static void removeChildren(PrivilegeAction action, Set<PrivilegeAction> notChildren) {
        notChildren.remove(action);
        if (expected.containsKey(action)) {
            for (PrivilegeAction child : expected.get(action)) {
                PrivilegeActionTest.removeChildren(child, notChildren);
            }
        }
    }

    static {
        expected.put(PrivilegeAction.ADMIN, Set.of(PrivilegeAction.DBMS_ACTIONS, PrivilegeAction.TRANSACTION_MANAGEMENT, PrivilegeAction.START_DATABASE, PrivilegeAction.STOP_DATABASE));
        expected.put(PrivilegeAction.TRANSACTION_MANAGEMENT, Set.of(PrivilegeAction.SHOW_TRANSACTION, PrivilegeAction.TERMINATE_TRANSACTION, PrivilegeAction.SHOW_CONNECTION, PrivilegeAction.TERMINATE_CONNECTION));
        expected.put(PrivilegeAction.ROLE_MANAGEMENT, Set.of(PrivilegeAction.SHOW_ROLE, PrivilegeAction.CREATE_ROLE, PrivilegeAction.RENAME_ROLE, PrivilegeAction.DROP_ROLE, PrivilegeAction.ASSIGN_ROLE, PrivilegeAction.REMOVE_ROLE));
        expected.put(PrivilegeAction.USER_MANAGEMENT, Set.of(PrivilegeAction.SHOW_USER, PrivilegeAction.CREATE_USER, PrivilegeAction.RENAME_USER, PrivilegeAction.DROP_USER, PrivilegeAction.ALTER_USER));
        expected.put(PrivilegeAction.ALTER_USER, Set.of(PrivilegeAction.SET_USER_STATUS, PrivilegeAction.SET_PASSWORDS, PrivilegeAction.SET_USER_HOME_DATABASE));
        expected.put(PrivilegeAction.DATABASE_MANAGEMENT, Set.of(PrivilegeAction.CREATE_DATABASE, PrivilegeAction.DROP_DATABASE, PrivilegeAction.ALTER_DATABASE));
        expected.put(PrivilegeAction.ALTER_DATABASE, Set.of(PrivilegeAction.SET_DATABASE_ACCESS));
        expected.put(PrivilegeAction.PRIVILEGE_MANAGEMENT, Set.of(PrivilegeAction.SHOW_PRIVILEGE, PrivilegeAction.ASSIGN_PRIVILEGE, PrivilegeAction.REMOVE_PRIVILEGE));
        expected.put(PrivilegeAction.WRITE, Set.of(PrivilegeAction.SET_LABEL, PrivilegeAction.REMOVE_LABEL, PrivilegeAction.CREATE_ELEMENT, PrivilegeAction.DELETE_ELEMENT, PrivilegeAction.SET_PROPERTY));
        expected.put(PrivilegeAction.GRAPH_ACTIONS, Set.of(PrivilegeAction.TRAVERSE, PrivilegeAction.READ, PrivilegeAction.WRITE, PrivilegeAction.MATCH));
        expected.put(PrivilegeAction.MERGE, Set.of(PrivilegeAction.MATCH, PrivilegeAction.TRAVERSE, PrivilegeAction.READ, PrivilegeAction.CREATE_ELEMENT, PrivilegeAction.SET_PROPERTY));
        expected.put(PrivilegeAction.MATCH, Set.of(PrivilegeAction.TRAVERSE, PrivilegeAction.READ));
        expected.put(PrivilegeAction.INDEX, Set.of(PrivilegeAction.CREATE_INDEX, PrivilegeAction.DROP_INDEX, PrivilegeAction.SHOW_INDEX));
        expected.put(PrivilegeAction.CONSTRAINT, Set.of(PrivilegeAction.CREATE_CONSTRAINT, PrivilegeAction.DROP_CONSTRAINT, PrivilegeAction.SHOW_CONSTRAINT));
        expected.put(PrivilegeAction.TOKEN, Set.of(PrivilegeAction.CREATE_LABEL, PrivilegeAction.CREATE_RELTYPE, PrivilegeAction.CREATE_PROPERTYKEY));
        expected.put(PrivilegeAction.DATABASE_ACTIONS, Set.of(PrivilegeAction.INDEX, PrivilegeAction.CONSTRAINT, PrivilegeAction.TOKEN, PrivilegeAction.ACCESS));
        expected.put(PrivilegeAction.DBMS_ACTIONS, Set.of(PrivilegeAction.ROLE_MANAGEMENT, PrivilegeAction.USER_MANAGEMENT, PrivilegeAction.DATABASE_MANAGEMENT, PrivilegeAction.PRIVILEGE_MANAGEMENT, PrivilegeAction.EXECUTE_ADMIN, PrivilegeAction.IMPERSONATE));
    }
}

