/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;

class LoggingMonitorTest {
    LoggingMonitorTest() {
    }

    @Test
    void shouldNotIncludeStackTraceWhenNotDebugLevel() {
        AssertableLogProvider logProvider = new AssertableLogProvider(false);
        LoggingMonitor monitor = new LoggingMonitor(logProvider.getLog(LoggingMonitorTest.class));
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withName("index").materialise(1L);
        monitor.failedToOpenIndex(index, "I'll do something about this.", new Exception("Dammit Leroy!"));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotContainMessage("java.lang.Exception: Dammit Leroy!");
    }

    @Test
    void shouldIncludeStackTraceWhenDebugLevel() {
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        LoggingMonitor monitor = new LoggingMonitor(logProvider.getLog(LoggingMonitorTest.class));
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withName("index").materialise(1L);
        monitor.failedToOpenIndex(index, "I'll do something about this.", new Exception("Dammit Leroy!"));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"java.lang.Exception: Dammit Leroy!"});
    }
}

